<?php
/*
 * $Id: tables_update.inc.php,v 1.1.2.8 2004/01/05 01:38:08 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This file is contributed by Urmet Ja"nes <urmet.janes@proekspert.ee>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

$test[] = '0.5.1'; // 20010327
function dcl_upgrade0_5_1()
{
	global $phpgw_setup, $setup_info;

	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='20010327' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.5.2';
	return $setup_info['dcl']['currentver'];
}

$test[] = '0.5.2'; // 20010413
function dcl_upgrade0_5_2()
{
	global $phpgw_setup, $setup_info;

	$phpgw_setup->oProc->Query("INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_SMTP_SERVER', 'dcl_config_varchar', 'localhost')");
	$phpgw_setup->oProc->Query("INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_SMTP_ENABLED', 'dcl_config_varchar', 'Y')");
	$phpgw_setup->oProc->Query("INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_SMTP_PORT', 'dcl_config_int', 25)");
	$phpgw_setup->oProc->Query("INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_SMTP_TIMEOUT', 'dcl_config_int', 30)");
	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='20010413' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.5.3';
	return $setup_info['dcl']['currentver'];
}

$test[] = '0.5.3'; // 20010715
function dcl_upgrade0_5_3()
{
	global $phpgw_setup, $setup_info;

	$phpgw_setup->oProc->CreateTable('dcl_chklst_tpl',
					array(
						'fd' => array(
							'dcl_chklst_tpl_id' => array('type' => 'auto', 'precision' => 4, 'nullable' => false),
							'dcl_chklst_tpl_name' => array('type' => 'varchar', 'precision' => 255, 'nullable' => false),
							'dcl_chklst_tpl_active' => array('type' => 'char', 'precision' => 1, 'default' => 'Y', 'nullable' => false)
						),
						'pk' => array('dcl_chklst_tpl_id'),
						'fk' => array(),
						'ix' => array(),
						'uc' => array()
					)
	);

	$phpgw_setup->oProc->CreateTable('dcl_chklst',
					array(
						'fd' => array(
							'dcl_chklst_id' => array('type' => 'auto', 'precision' => 4, 'nullable' => false),
							'dcl_chklst_tpl_id' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
							'dcl_chklst_summary' => array('type' => 'varchar', 'precision' => 255, 'nullable' => false),
							'dcl_chklst_createby' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
							'dcl_chklst_createon' => array('type' => 'timestamp', 'default' => 'now()', 'nullable' => false),
							'dcl_chklst_modifyby' => array('type' => 'int', 'precision' => 4),
							'dcl_chklst_modifyon' => array('type' => 'timestamp', 'default' => 'now()'),
							'dcl_chklst_status' => array('type' => 'varchar', 'precision' => 255, 'nullable' => false)
						),
						'pk' => array('dcl_chklst_id'),
						'fk' => array(),
						'ix' => array(),
						'uc' => array()
					)
	);

	$phpgw_setup->oProc->Query("INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_PROJECT_BROWSE_PARENTS_ONLY', 'dcl_config_varchar', 'N')");
	$phpgw_setup->oProc->Query("INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_PROJECT_INCLUDE_PARENT_STATS', 'dcl_config_varchar', 'N')");
	$phpgw_setup->oProc->Query("INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_PROJECT_INCLUDE_CHILD_STATS', 'dcl_config_varchar', 'Y')");
	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='20010715' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.5.4';
	return $setup_info['dcl']['currentver'];
}

$test[] = '0.5.4'; // 20010729
function dcl_upgrade0_5_4()
{
	global $phpgw_setup, $setup_info;

	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='20010729' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.5.5';
	return $setup_info['dcl']['currentver'];
}

$test[] = '0.5.5'; // 20010911
function dcl_upgrade0_5_5()
{
	global $phpgw_setup, $setup_info;

	$phpgw_setup->oProc->Query("INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_FILE_PATH', 'dcl_config_varchar', '.')");
	$phpgw_setup->oProc->Query("INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_HTML_TITLE', 'dcl_config_varchar', 'Double Choco Latte - Copyright (C) 1998-2001 Michael L. Dean and Tim R. Norman')");
	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='20010911' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.5.6';
	return $setup_info['dcl']['currentver'];
}

$test[] = '0.5.6'; // 20010916
function dcl_upgrade0_5_6()
{
	global $phpgw_setup, $setup_info;

	$phpgw_setup->oProc->CreateTable('dcl_status_type',
					array(
						'fd' => array(
							'dcl_status_type_id' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
							'dcl_status_type_name' => array('type' => 'varchar', 'precision' => 50, 'nullable' => false)
						),
						'pk' => array('dcl_status_type_id'),
						'fk' => array(),
						'ix' => array(),
						'uc' => array()
					)
	);

	$phpgw_setup->oProc->Query("insert into dcl_status_type values (1, 'Open')");
	$phpgw_setup->oProc->Query("insert into dcl_status_type values (2, 'Completed')");
	$phpgw_setup->oProc->Query("insert into dcl_status_type values (3, 'Deferred')");

	$phpgw_setup->oProc->AddColumn('statuses', 'dcl_status_type',
		array('type' => 'int', 'precision' => 4, 'nullable' => false, 'default' => 1));

	$phpgw_setup->oProc->Query("INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_DEFAULT_PROJECT_STATUS', 'dcl_config_int', 1)");
	$phpgw_setup->oProc->Query("INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_DEFAULT_TICKET_STATUS', 'dcl_config_int', 1)");
	$phpgw_setup->oProc->Query("update statuses set dcl_status_type = 1");
	$phpgw_setup->oProc->Query("update statuses set dcl_status_type = 2 where id = 2");
	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='20010916' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.5.7';
	return $setup_info['dcl']['currentver'];
}

$test[] = '0.5.7'; // 20010918
function dcl_upgrade0_5_7()
{
	global $phpgw_setup, $setup_info;

	$phpgw_setup->oProc->RenameTable('projects', 'dcl_projects');
	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='20010918' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.5.8';
	return $setup_info['dcl']['currentver'];
}

$test[] = '0.5.8'; // 20010923
function dcl_upgrade0_5_8()
{
	global $phpgw_setup, $setup_info;

	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='20010923' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.5.9';
	return $setup_info['dcl']['currentver'];
}

$test[] = '0.5.9'; // 20011203
function dcl_upgrade0_5_9()
{
	global $phpgw_setup, $setup_info;

	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_ENABLED', 'dcl_config_varchar', 'N')");
	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_AUTORESPOND', 'dcl_config_varchar', 'N')");
	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_REPLY', 'dcl_config_varchar', 'N')");
	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_AUTORESPONSE_EMAIL', 'dcl_config_varchar', 'nobody@localhost')");
	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_FILE_PATH', 'dcl_config_varchar', '/tmp')");
	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_STATUS', 'dcl_config_int', 0)");
	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_PRIORITY', 'dcl_config_int', 0)");
	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_SEVERITY', 'dcl_config_int', 0)");
	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='20011203' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.5.10';
	return $setup_info['dcl']['currentver'];
}

$test[] = '0.5.10'; // 20011209
function dcl_upgrade0_5_10()
{
	global $phpgw_setup, $setup_info;

	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='20011209' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.5.11';
	return $setup_info['dcl']['currentver'];
}

$test[] = '0.5.11'; // 20011210
function dcl_upgrade0_5_11()
{
	global $phpgw_setup, $setup_info;

	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='20011210' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.5.12';
	return $setup_info['dcl']['currentver'];
}

$test[] = '0.5.12'; // 20011215
function dcl_upgrade0_5_12()
{
	global $phpgw_setup, $setup_info;

	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_ACCOUNT', 'dcl_config_int', 0)");
	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_REPLY_LOGGED_BY', 'dcl_config_int', 0)");
	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='20011215' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.5.13';
	return $setup_info['dcl']['currentver'];
}

$test[] = '0.5.13'; // 20020120
function dcl_upgrade0_5_13()
{
	global $phpgw_setup, $setup_info;

	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='20020120' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.5.14';
	return $setup_info['dcl']['currentver'];
}

$test[] = '0.5.14'; // 20020215
function dcl_upgrade0_5_14()
{
	global $phpgw_setup, $setup_info;

	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='20020215' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.5.15';
	return $setup_info['dcl']['currentver'];
}

$test[] = '0.5.15'; // 20020706
function dcl_upgrade0_5_15()
{
	global $phpgw_setup, $setup_info;

	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='20020706' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.5.16';
	return $setup_info['dcl']['currentver'];
}

$test[] = '0.5.16'; // 20021021
function dcl_upgrade0_5_16()
{
	global $phpgw_setup, $setup_info;

	$phpgw_setup->oProc->CreateTable('dcl_product_module',
					array(
						'fd' => array(
							'product_module_id' => array('type' => 'auto', 'precision' => 4, 'nullable' => false),
							'product_id' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
							'module_name' => array('type' => 'varchar', 'precision' => 50, 'nullable' => false),
							'active' => array('type' => 'char', 'precision' => 1, 'nullable' => false)
						),
						'pk' => array('product_module_id'),
						'fk' => array(),
						'ix' => array(),
						'uc' => array()
					)
	);

	$phpgw_setup->oProc->AddColumn('workorders', 'module_id',
		array('type' => 'int', 'precision' => 4, 'nullable' => true));

	$phpgw_setup->oProc->AddColumn('tickets', 'module_id',
		array('type' => 'int', 'precision' => 4, 'nullable' => true));

	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='20021021' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.5.17';
	return $setup_info['dcl']['currentver'];
}

$test[] = '0.5.17'; // 20021023
function dcl_upgrade0_5_17()
{
	global $phpgw_setup, $setup_info;

	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_SMTP_DEFAULT_EMAIL', 'dcl_config_varchar', 'nobody@localhost')");
	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_WO_NOTIFICATION_HTML', 'dcl_config_varchar', 'N')");
	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_WO_EMAIL_TEMPLATE', 'dcl_config_varchar', 'notify_wo_en.tpl')");
	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_TCK_NOTIFICATION_HTML', 'dcl_config_varchar', 'N')");
	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_TCK_EMAIL_TEMPLATE', 'dcl_config_varchar', 'notify_tck_en.tpl')");
	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='20021023' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.5.18';
	return $setup_info['dcl']['currentver'];
}

$test[] = '0.5.18';
function dcl_upgrade0_5_18()
{
	global $phpgw_setup, $setup_info;

	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='0.9.0' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.9.0';
	return $setup_info['dcl']['currentver'];
}

$test[] = '0.9.0';
function dcl_upgrade0_9_0()
{
	global $phpgw_setup, $setup_info;

	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='0.9.1' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.9.1';
	return $setup_info['dcl']['currentver'];
}

$test[] = '0.9.1';
function dcl_upgrade0_9_1()
{
	global $phpgw_setup, $setup_info;

	$phpgw_setup->oProc->AddColumn('timecards', 'reassign_from_id',
		array('type' => 'int', 'precision' => 4, 'nullable' => true));

	$phpgw_setup->oProc->AddColumn('timecards', 'reassign_to_id',
		array('type' => 'int', 'precision' => 4, 'nullable' => true));

	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='0.9.2' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.9.2';
	return $setup_info['dcl']['currentver'];
}

$test[] = '0.9.2';
function dcl_upgrade0_9_2()
{
	global $phpgw_setup, $setup_info;

	// One word: BRUTAL
	$phpgw_setup->oProc->CreateTable('dcl_wo_account',
					array(
						'fd' => array(
							'wo_id' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
							'seq' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
							'account_id' => array('type' => 'int', 'precision' => 4, 'nullable' => false)
						),
						'pk' => array('wo_id', 'seq', 'account_id'),
						'fk' => array(),
						'ix' => array(),
						'uc' => array()
					)
	);

	$phpgw_setup->oProc->Query("Insert Into dcl_wo_account Select jcn, seq, account From workorders where account is not null and account > 0");

	$phpgw_setup->oProc->DropColumn('workorders',
					array(
						'fd' => array(
							'jcn' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
							'seq' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
							'product' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
							'createby' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
							'createdon' => array('type' => 'timestamp', 'nullable' => false),
							'closedby' => array('type' => 'int', 'precision' => 4),
							'closedon' => array('type' => 'date'),
							'status' => array('type' => 'int', 'precision' => 4),
							'statuson' => array('type' => 'timestamp', 'nullable' => false),
							'lastactionon' => array('type' => 'timestamp'),
							'deadlineon' => array('type' => 'date'),
							'eststarton' => array('type' => 'date'),
							'estendon' => array('type' => 'date'),
							'starton' => array('type' => 'date'),
							'esthours' => array('type' => 'float', 'precision' => 8),
							'totalhours' => array('type' => 'float', 'precision' => 8),
							'priority' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
							'severity' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
							'contact' => array('type' => 'varchar', 'precision' => 50),
							'contactphone' => array('type' => 'char', 'precision' => 10),
							'summary' => array('type' => 'varchar', 'precision' => 100, 'nullable' => false),
							'notes' => array('type' => 'varchar', 'precision' => 1024),
							'description' => array('type' => 'varchar', 'precision' => 1024, 'nullable' => false),
							'responsible' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
							'revision' => array('type' => 'varchar', 'precision' => 20),
							'publicview' => array('type' => 'bool'),
							'etchours' => array('type' => 'float', 'precision' => 8),
							'module_id' => array('type' => 'int', 'precision' => 4)
						),
						'pk' => array('jcn', 'seq'),
						'fk' => array(),
						'ix' => array(),
						'uc' => array()
					),
					'account'
	);

	$phpgw_setup->oProc->CreateTable('dcl_wo_type',
					array(
						'fd' => array(
							'wo_type_id' => array('type' => 'auto', 'precision' => 4, 'nullable' => false),
							'type_name' => array('type' => 'varchar', 'precision' => 50, 'nullable' => false),
							'active' => array('type' => 'char', 'precision' => 1, 'nullable' => false)
						),
						'pk' => array('wo_type_id'),
						'fk' => array(),
						'ix' => array(),
						'uc' => array()
					)
	);

	$phpgw_setup->oProc->AddColumn('workorders', 'wo_type_id',
		array('type' => 'int', 'precision' => 4, 'nullable' => true));

	$phpgw_setup->oProc->Query("Insert Into dcl_wo_type (type_name, active) values ('Issue', 'Y')");
	$phpgw_setup->oProc->Query("Update workorders set wo_type_id = 1");

	$phpgw_setup->oProc->CreateTable('dcl_session',
					array(
						'fd' => array(
							'dcl_session_id' => array('type' => 'varchar', 'precision' => 32, 'nullable' => false),
							'personnel_id' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
							'create_date' => array('type' => 'timestamp'),
							'update_date' => array('type' => 'timestamp'),
							'session_data' => array('type' => 'text')
						),
						'pk' => array('dcl_session_id'),
						'fk' => array(),
						'ix' => array(),
						'uc' => array()
					)
	);

	$phpgw_setup->oProc->CreateTable('dcl_preferences',
					array(
						'fd' => array(
							'personnel_id' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
							'preferences_data' => array('type' => 'text')
						),
						'pk' => array('personnel_id'),
						'fk' => array(),
						'ix' => array(),
						'uc' => array()
					)
	);

	$phpgw_setup->oProc->CreateTable('dcl_wiki',
					array(
						'fd' => array(
							'dcl_entity_type_id' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
							'dcl_entity_id' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
							'dcl_entity_id2' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
							'page_name' => array('type' => 'varchar', 'precision' => 255, 'nullable' => false),
							'page_text' => array('type' => 'text'),
							'page_date' => array('type' => 'timestamp'),
							'page_ip' => array('type' => 'varchar', 'precision' => 255)
						),
						'pk' => array('dcl_entity_type_id'),
						'fk' => array(),
						'ix' => array(),
						'uc' => array()
					)
	);

	// TODO: The next 2 lines may need abstraction
	$phpgw_setup->oProc->Query("create unique index uc_accounts_short on accounts(short)");
	$phpgw_setup->oProc->Query("create unique index uc_accounts_name on accounts(name)");

	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_AUTORESPOND', 'dcl_config_varchar', 'N')");
	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_AUTORESPONSE_EMAIL', 'dcl_config_varchar', 'nobody@localhost')");
	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_ENABLED', 'dcl_config_varchar', 'N')");
	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_FILE_PATH', 'dcl_config_varchar', '/tmp')");
	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_WO_PRIORITY', 'dcl_config_int', 0)");
	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_REPLY', 'dcl_config_varchar', 'N')");
	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_WO_SEVERITY', 'dcl_config_int', 0)");
	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_WO_STATUS', 'dcl_config_int', 0)");
	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_WO_SECONDARY_ACCOUNTS_ENABLED', 'dcl_config_varchar', 'N')");
	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_datetime) values ('LAST_CONFIG_UPDATE', 'dcl_config_datetime', " . $phpgw_setup->oProc->m_odb->GetDateSQL() . ')');
	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_SESSION_TIMEOUT', 'dcl_config_int', 20)");
	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_WIKI_ENABLED', 'dcl_config_varchar', 'N')");
	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_WIKI_VIEW', 'dcl_config_int', 4)");
	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_WIKI_EDIT', 'dcl_config_int', 5)");
	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='0.9.3' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.9.3';
	return $setup_info['dcl']['currentver'];
}

$test[] = '0.9.3';
function dcl_upgrade0_9_3()
{
	global $phpgw_setup, $setup_info, $dcl_domain_info, $dcl_domain;

	$phpgw_setup->oProc->CreateTable('dcl_sccs',
					array(
						'fd' => array(
							'dcl_sccs_id' => array('type' => 'auto', 'precision' => 4, 'nullable' => false),
							'sccs_repository' => array('type' => 'varchar', 'precision' => 255, 'nullable' => false),
							'sccs_descr' => array('type' => 'varchar', 'precision' => 50, 'nullable' => false)
						),
						'pk' => array('dcl_sccs_id'),
						'fk' => array(),
						'ix' => array(),
						'uc' => array()
					)
	);

	$phpgw_setup->oProc->CreateTable('dcl_sccs_xref',
					array(
						'fd' => array(
							'dcl_sccs_xref_id' => array('type' => 'auto', 'precision' => 4, 'nullable' => false),
							'dcl_entity_type_id' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
							'dcl_entity_id' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
							'dcl_entity_id2' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
							'dcl_sccs_id' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
							'personnel_id' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
							'sccs_project_path' => array('type' => 'varchar', 'precision' => 255, 'nullable' => false),
							'sccs_file_name' => array('type' => 'varchar', 'precision' => 255, 'nullable' => false),
							'sccs_version' => array('type' => 'varchar', 'precision' => 50, 'nullable' => false),
							'sccs_comments' => array('type' => 'text'),
							'sccs_checkin_on' => array('type' => 'timestamp', 'nullable' => false, 'default' => 'now()')
						),
						'pk' => array('dcl_sccs_xref_id'),
						'fk' => array(),
						'ix' => array(),
						'uc' => array()
					)
	);

	$phpgw_setup->oProc->CreateTable('dcl_wo_id',
					array(
						'fd' => array(
							'jcn' => array('type' => 'auto', 'precision' => 4, 'nullable' => false),
							'seq' => array('type' => 'int', 'precision' => 4, 'nullable' => false)
						),
						'pk' => array('jcn'),
						'fk' => array(),
						'ix' => array(),
						'uc' => array()
					)
	);

	$sType = $dcl_domain_info[$dcl_domain]['dbType'];

	// Initialize dcl_wo_id with current workorders contents
	if ($sType == 'mssql' || $sType == 'sybase')
		$phpgw_setup->oProc->Query('SET IDENTITY_INSERT dcl_wo_id ON');

	$phpgw_setup->oProc->Query("INSERT INTO dcl_wo_id (jcn, seq) SELECT jcn, max(seq) FROM workorders GROUP BY jcn");

	if ($sType == 'mssql' || $sType == 'sybase')
		$phpgw_setup->oProc->Query('SET IDENTITY_INSERT dcl_wo_id OFF');
	else if ($sType == 'pgsql')
		$phpgw_setup->oProc->Query("SELECT SETVAL('seq_dcl_wo_id', (SELECT MAX(jcn) FROM dcl_wo_id))");

	if ($sType == 'mssql' || $sType == 'sybase')
	{
		function __fixDateField($table, $field, $nullable)
		{
			global $phpgw_setup;
			$sNull = $nullable ? "NULL" : "NOT NULL";
			$phpgw_setup->oProc->Query("ALTER TABLE $table ALTER COLUMN $field varchar(10) $sNull");
			$phpgw_setup->oProc->Query("UPDATE $table SET $field = substring($field, 1, 4) + '-' + substring($field, 5, 2) + '-' + substring($field, 7, 2) where $field is not null");
			$phpgw_setup->oProc->Query("ALTER TABLE $table ALTER COLUMN $field smalldatetime $sNull");
		}

		function __fixTimestampField($table, $field, $nullable)
		{
			global $phpgw_setup;
			$sNull = $nullable ? "NULL" : "NOT NULL";
			$phpgw_setup->oProc->Query("ALTER TABLE $table ALTER COLUMN $field varchar(19) $sNull");
			$phpgw_setup->oProc->Query("UPDATE $table SET $field = substring($field, 1, 4) + '-' + substring($field, 5, 2) + '-' + substring($field, 7, 2) + ' ' + substring($field, 9, 2) + ':' + substring($field, 11, 2) + ':' + substring($field, 13, 2) where $field is not null");
			$phpgw_setup->oProc->Query("ALTER TABLE $table ALTER COLUMN $field datetime $sNull");
		}

		// Oh, the humanity!

		// timecards
		__fixDateField('timecards', 'actionon', false);
		__fixTimestampField('timecards', 'inputon', false);

		// workorders
		__fixTimestampField('workorders', 'createdon', false);
		__fixDateField('workorders', 'closedon', true);
		__fixTimestampField('workorders', 'lastactionon', true);
		__fixDateField('workorders', 'deadlineon', true);
		__fixDateField('workorders', 'eststarton', true);
		__fixDateField('workorders', 'estendon', true);
		__fixDateField('workorders', 'starton', true);

		// dcl_projects
		__fixTimestampField('dcl_projects', 'createdon', true);
		__fixDateField('dcl_projects', 'projectdeadline', true);
		__fixTimestampField('dcl_projects', 'lastactivity', true);
		__fixTimestampField('dcl_projects', 'finalclose', true);

		// tickets
		__fixTimestampField('tickets', 'createdon', false);
		__fixTimestampField('tickets', 'closedon', true);
		__fixTimestampField('tickets', 'statuson', false);
		__fixTimestampField('tickets', 'lastactionon', true);

		// ticketresolutions
		__fixTimestampField('ticketresolutions', 'loggedon', false);
		__fixTimestampField('ticketresolutions', 'startedon', false);

		// faq
		__fixTimestampField('faq', 'createon', false);
		__fixTimestampField('faq', 'modifyon', false);

		// faqtopics
		__fixTimestampField('faqtopics', 'createon', false);
		__fixTimestampField('faqtopics', 'modifyon', false);

		// faqquestions
		__fixTimestampField('faqquestions', 'createon', false);
		__fixTimestampField('faqquestions', 'modifyon', false);

		// faqanswers
		__fixTimestampField('faqanswers', 'createon', false);
		__fixTimestampField('faqanswers', 'modifyon', false);

		// dcl_config
		__fixDateField('dcl_config', 'dcl_config_date', true);
		__fixTimestampField('dcl_config', 'dcl_config_datetime', true);

		// dcl_chklst
		__fixTimestampField('dcl_chklst', 'dcl_chklst_createon', false);
		__fixTimestampField('dcl_chklst', 'dcl_chklst_modifyon', true);

		$phpgw_setup->oProc->query("UPDATE dcl_config SET dcl_config_varchar = 'Y-m-d' WHERE dcl_config_name = 'DCL_DATE_FORMAT_DB'");
		$phpgw_setup->oProc->query("UPDATE dcl_config SET dcl_config_varchar = 'Y-m-d H:i:s' WHERE dcl_config_name = 'DCL_TIMESTAMP_FORMAT_DB'");
	}
	else if ($sType == 'mysql')
	{
		function __mysql_fixTimestampField($table, $field, $nullable, $bDefaultNow)
		{
			global $phpgw_setup;
			$sNull = $nullable ? "NULL" : "NOT NULL";
			$sDefault = $bDefaultNow ? "DEFAULT 'now()'" : '';
			$phpgw_setup->oProc->Query("ALTER TABLE $table CHANGE $field $field datetime $sDefault $sNull");
		}

		__mysql_fixTimestampField('timecards', 'inputon', true, false);
		__mysql_fixTimestampField('workorders', 'createdon', true, false);
		__mysql_fixTimestampField('workorders', 'statuson', true, false);
		__mysql_fixTimestampField('workorders', 'lastactionon', true, false);
		__mysql_fixTimestampField('dcl_projects', 'createdon', true, false);

		__mysql_fixTimestampField('dcl_projects', 'lastactivity', true, false);
		__mysql_fixTimestampField('tickets', 'createdon', false, true);
		__mysql_fixTimestampField('tickets', 'closedon', true, false);
		__mysql_fixTimestampField('tickets', 'statuson', false, false);
		__mysql_fixTimestampField('tickets', 'lastactionon', true, false);

		__mysql_fixTimestampField('ticketresolutions', 'loggedon', false, true);
		__mysql_fixTimestampField('ticketresolutions', 'startedon', false, false);
		__mysql_fixTimestampField('faq', 'createon', false, true);
		__mysql_fixTimestampField('faq', 'modifyon', true, false);
		__mysql_fixTimestampField('faqtopics', 'createon', false, true);

		__mysql_fixTimestampField('faqtopics', 'modifyon', true, false);
		__mysql_fixTimestampField('faqquestions', 'createon', false, true);
		__mysql_fixTimestampField('faqquestions', 'modifyon', true, false);
		__mysql_fixTimestampField('faqanswers', 'createon', false, true);
		__mysql_fixTimestampField('faqanswers', 'modifyon', true, false);

		__mysql_fixTimestampField('dcl_config', 'dcl_config_datetime', true, false);
		__mysql_fixTimestampField('dcl_chklst', 'dcl_chklst_createon', false, true);
		__mysql_fixTimestampField('dcl_chklst', 'dcl_chklst_modifyon', true, false);
		__mysql_fixTimestampField('dcl_session', 'create_date', false, false);
		__mysql_fixTimestampField('dcl_session', 'update_date', false, false);

		__mysql_fixTimestampField('dcl_wiki', 'page_date', true, false);

		$phpgw_setup->oProc->query("UPDATE dcl_config SET dcl_config_varchar = 'Y-m-d H:i:s' WHERE dcl_config_name = 'DCL_TIMESTAMP_FORMAT_DB'");
	}

	if ($sType == 'pgsql')
	{
		// Change applicable tables to use text instead of varchar fields
		$phpgw_setup->oProc->RefreshTable('workorders');
		$phpgw_setup->oProc->RefreshTable('timecards');
		$phpgw_setup->oProc->RefreshTable('accounts');
		$phpgw_setup->oProc->RefreshTable('dcl_projects');

		// seq_projects will get renamed to seq_dcl_projects
		// and we have one other that needs changed
		$phpgw_setup->oProc->query('ALTER TABLE seq_severity RENAME TO seq_severities');
	}
	else
	{
		// drop (and later recreate) primary key on workorders as jcn, seq - must be done before dropping oid column
		if ($sType == 'mysql')
		{
			$phpgw_setup->oProc->query('ALTER TABLE workorders DROP COLUMN oid');
		}

		$phpgw_setup->oProc->DropPrimaryKey('workorders');

		// oid is a system field in pgsql that was used as pk in other servers
		if ($phpgw_setup->oProc->m_odb->FieldExists('workorders', 'oid'))
		{
			$phpgw_setup->oProc->DropColumn('workorders',
				array(
					'jcn' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
					'seq' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
					'product' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
					'createby' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
					'createdon' => array('type' => 'timestamp', 'nullable' => false),
					'closedby' => array('type' => 'int', 'precision' => 4),
					'closedon' => array('type' => 'date'),
					'status' => array('type' => 'int', 'precision' => 4),
					'statuson' => array('type' => 'timestamp', 'nullable' => false),
					'lastactionon' => array('type' => 'timestamp'),
					'deadlineon' => array('type' => 'date'),
					'eststarton' => array('type' => 'date'),
					'estendon' => array('type' => 'date'),
					'starton' => array('type' => 'date'),
					'esthours' => array('type' => 'float', 'precision' => 8),
					'totalhours' => array('type' => 'float', 'precision' => 8),
					'priority' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
					'severity' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
					'contact' => array('type' => 'varchar', 'precision' => 50),
					'contactphone' => array('type' => 'char', 'precision' => 10),
					'summary' => array('type' => 'varchar', 'precision' => 100, 'nullable' => false),
					'notes' => array('type' => 'text'),
					'description' => array('type' => 'text', 'nullable' => false),
					'responsible' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
					'revision' => array('type' => 'varchar', 'precision' => 20),
					'publicview' => array('type' => 'bool'),
					'etchours' => array('type' => 'float', 'precision' => 8),
					'module_id' => array('type' => 'int', 'precision' => 4),
					'wo_type_id' => array('type' => 'int', 'precision' => 4)
				),
				'oid');
		}

		$phpgw_setup->oProc->CreatePrimaryKey('workorders', array('jcn', 'seq'));
	}

	$phpgw_setup->oProc->Query("insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_SCCS_ENABLED', 'dcl_config_varchar', 'N')");
	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='0.9.4' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.9.4';
	return $setup_info['dcl']['currentver'];
}

$test[] = '0.9.4';
function dcl_upgrade0_9_4()
{
	global $phpgw_setup, $setup_info;

	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='0.9.4.1' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.9.4.1';
	return $setup_info['dcl']['currentver'];
}

$test[] = '0.9.4.1';
function dcl_upgrade0_9_4_1()
{
	global $phpgw_setup, $setup_info;

	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='0.9.4.2' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.9.4.2';
	return $setup_info['dcl']['currentver'];
}

$test[] = '0.9.4.2';
function dcl_upgrade0_9_4_2()
{
	global $phpgw_setup, $setup_info;

	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='0.9.4.3' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.9.4.3';
	return $setup_info['dcl']['currentver'];
}

$test[] = '0.9.4.3';
function dcl_upgrade0_9_4_3()
{
	global $phpgw_setup, $setup_info;

	$phpgw_setup->oProc->Query("UPDATE dcl_config SET dcl_config_varchar='0.9.4.4' WHERE dcl_config_name='DCL_VERSION'");

	$setup_info['dcl']['currentver'] = '0.9.4.4';
	return $setup_info['dcl']['currentver'];
}
?>
