/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * network.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: network.h,v 1.4 2003/12/28 08:12:38 uid68112 Exp $
*/

#ifndef __NETWORK_H__
#define __NETWORK_H__

#include <netinet/in.h>

/****************************************************************/
/* the following parameters are used to handle SOCKS proxy (v4) */
/****************************************************************/
extern char *socks_ip;              /* hostname or IP of the socks proxy (NULL=don't use socks proxy) */
extern unsigned short socks_port;   /* port number of the socks proxy (default:1080) */ 
extern char *socks_name;            /* userID to use on the socks proxy (or NULL if none required) */
extern char *socks_pass;            /* password to use on the socks proxy (or NULL if none required) */
                                    /* only valid when socks_name!=NULL AND SOCKSv5 enabled */
extern int use_socks_v5;            /* prefer SOCKSv5 instead of v4 */

extern char *web_proxy_address;		/* address (IP or name) and port of a web proxy to use which supports the command CONNECT */

/*************************************************/
/* open a TCP connection with the requested port */
/*************************************************/
/* en entree: port= port demande     */
/* en sortie: numero de socket ou -1 */
/*************************************/
int _x_tcp (int port);

/*************************************************/
/* open a UDP connection with the requested port */
/************************************************************/
/* input: port= wanted port number (0=find an unused one)   */
/*        if port!=0 and port_upper_range > port and <65536 */
/*        the function tries to bind on a free port in the  */
/*        range [port:port_upper_range].                    */
/*        if port_upper_range==0, only "port" is used       */
/* output: socket descriptor or -1                          */
/*        if port!=0 and port_upper_range=0, a returned     */
/*        value of -1 probably means the port is busy.      */
/*        if port_upper_range!=0, a returned value of -1    */
/*        probably means all ports on the given range are   */
/*        busy.                                             */
/************************************************************/
int _x_udp (int port, int port_upper_range);

/*****************************************************/
/* routine fixant le flag non bloquant sur un socket */
/*****************************************************/
void set_non_bloquant_sock(int socket_fd);

/*************************************************/
/* routine fixant le flag bloquant sur un socket */
/*************************************************/
void set_bloquant_sock(int socket_fd);

/*************************************************/
/* routine to set TOS on socket                  */
/*************************************************/
void set_tos_sock(int socket_fd, int tos);

/***************************************/
/* conversion nom d'hote -> adresse ip */
/***************************************/
/* en sortie: -1= fail, 0=ok */
/*****************************/
int str_to_inaddr (const char *str, struct in_addr *iap);

/****************************************************/
/* create a socket and connect it to the given host */
/***************************************************************/
/* input: non_block=1 (socket is created with O_NONBLOCK flag) */
/*********************************************************************************************/
/* output: sock_fd or -1,-2 or -3                                                            */
/*         if non_block==1, returned sock_fd must be tested (ready_to_write) before using it */
/*********************************************************************************************/
/* -1=unknown host           */
/* -2=socket creation failed */
/* -3=unable to contact host */
/***********************************************************************************/
/* WARNING: if non_block==1 and a SOCKS proxy is used, the connection will fail... */
/***********************************************************************************/
int create_and_open_sock_on(char *hostname,unsigned short port, int non_block);

/******************************/
/* return the default host IP */
/************************************************************************/
/* the default host IP is the IP of the interface used as default route */
/************************************************************************/
/* The parameter can be NULL and in this case, the default host IP is */
/* used, it can also be an IP (IPv4) or an interface to have an IP    */
/***************************************************************************************/
/* note: it is a non sens to set dynamic to TRUE and to provide an IP instead of an IF */
/***************************************************************************************/
GString *get_default_host_ip(const char *ip_or_if, gboolean dynamic_flag);

#endif
