/*-
 * Copyright (c) 1998-2001 Joao Cabral (jcnc@dhis.org)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *      DHIS(c)  Dynamic Host Information System Release 5.1
 */

#include<sys/types.h>
#include<sys/wait.h>
#include<sys/socket.h>
#include<netdb.h>
#include<netinet/in.h>
#include<arpa/inet.h>
#include<time.h>
#include<ctype.h>
#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<string.h>
#include<signal.h>
#include<syslog.h>
#include<sys/time.h>

#ifdef	QRC
#include<gmp.h>
#endif

/* Define statements */

#define POLL_STAGE      1
#define AUTH_STAGE      2
#define ON_STAGE        3



#define	DHIS_VERSION	51		/* DHIS Version */

#define	MAX_HOSTNAME	64
#define	MAX_PASS	16		/* Characters in password */

/* Message opcodes */
#define	ECHO_REQ	0x00000511
#define	ECHO_ACK	0x00000512
#define	AUTH_REQ	0x00000521
#define	AUTH_DENY	0x00000522
#define	AUTH_ACK	0x00000526
#define	AUTH_SX		0x00000524
#define	AUTH_SY		0x00000525
#define	CHECK_REQ	0x00000541
#define	CHECK_ACK	0x00000542
#define	OFFLINE_REQ	0x00000551


#define	DHID_CONF	"/etc/dhid.conf"
#define	DHID_PID	"/etc/dhid.pid"

#define	DEF_ISPORT	58800
#define	FAIL_ALLOW	3

#define	APASS		1
#define	AQRC		2

/* Configuration section */

struct ser_t {
		unsigned char hostname[MAX_HOSTNAME];
		int addr;
		int port;
		struct ser_t *next;
	     };

struct conf_t {
		int id;					/* HostID */
		unsigned char pass[MAX_PASS];		/* Password */
		int atype;
		struct ser_t *servers;
		struct ser_t *cserver;
		int refresh;
		int sid;
		int laddr;
#ifdef	QRC	
		mpz_t authp;
		mpz_t authq;
#endif
		int stage;
		int timeout;
		unsigned char on_cmd[256];
		unsigned char on_cmdp[256];
		unsigned char off_cmd[256];
		unsigned char off_cmdp[256];
		struct conf_t *next;
	      };

unsigned char *line_entry(int,unsigned char *);
unsigned char *line_ptr(int,unsigned char *);
unsigned char *dot_entry(int,unsigned char *);
void off_nl(unsigned char *);
void strtolower(unsigned char *);
void free_conf(void);
void read_conf(unsigned char *);

/* network section */

#define	MAX_MSG	256

typedef struct {
		int opcode;
		int serial;
		int version;
		int rport;
		int hostid;
		} header_t;

typedef struct { header_t hdr;
		unsigned char buff[MAX_MSG-sizeof(header_t)];
	       } msg_t;

typedef struct { header_t hdr; } echo_req_t;
typedef struct { header_t hdr; int oserial; } echo_ack_t;
typedef struct { header_t hdr; unsigned char pass[16]; int refresh; } auth_req_t;
typedef struct { header_t hdr; } auth_deny_t;
typedef struct { header_t hdr; int sid; int raddr;} auth_ack_t;
typedef struct { header_t hdr; unsigned char x[200]; } auth_sendx_t;
typedef struct { header_t hdr; unsigned char y[200]; } auth_sendy_t;
typedef struct { header_t hdr; int next_check; } check_req_t;
typedef struct { header_t hdr; int sid; } check_ack_t;
typedef struct { header_t hdr; int sid; } offline_req_t;


int msg_size_by_opcode(int);
void swap_int(int *);
void swap_msg(int *,int);
int little_endian(void);
void convert_message(msg_t *,int);
int get_serial(void);
int net_init(int);
int net_close(void);
int net_check_message(void);
int net_read_message(msg_t *,int *);
int net_write_message(msg_t *,int,int);

#ifdef	QRC
void qrc_random(mpz_t,int);
void qrc_genkey(mpz_t);
void qrc_genx(mpz_t,mpz_t);
void qrc_geny(mpz_t,mpz_t,mpz_t);
void qrc_sqrty(mpz_t,mpz_t,mpz_t);
void qrc_crt(mpz_t,mpz_t,mpz_t,mpz_t,mpz_t);
void qrc_fill_str(mpz_t,unsigned char *,int);
#endif

