/*
 * diasce
 * Copyright (C) 2002  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * ander1@wanadoo.es
 */

#include "main.h"

void cvs_inicializar(void)
{
	cvs_comando=CVS_NINGUNO;
	recordar_log=NULL;
}

void cvs_update(void)
{
	gchar *comando;
	gchar *cvsroot;
	gchar *compresion;
	gchar *directorio;
	gchar *modulo;
	gint error;
	
	cvsroot=pro_cvsroot();
	if ((cvsroot==NULL) || (cvsroot[0]==0)) {
		gen_ventana_mensaje(_("You don't have properly configured CVS, you must especify a CVSROOT in the project preferences.\n"),GTK_MESSAGE_ERROR);
		g_free(cvsroot);
		return;
	}
	modulo=pro_modulo_cvs();
	if ((modulo==NULL) || (modulo[0]==0)) {
		gen_ventana_mensaje(_("You don't have properly configured CVS, you must especify a modul in the project preferences.\n"),GTK_MESSAGE_ERROR);
		g_free(modulo);
		g_free(cvsroot);
		return;
	}
	compresion=pro_compresion_cvs();
	directorio=pro_prodir(LOCALE);
	chdir(directorio);
	
	gen_limpiar_mensajes();
	g_print(_("------------------------------ Updating %s ------------------------------\n\n"),modulo);
	
	comando=g_strdup_printf("cvs -d'%s' -z%s update -Pd 2>/dev/stdout\n",cvsroot,compresion);
	error=cvs_ejecutar_update(comando);
	g_free(comando);
	g_print(_("\nDone\n"));
	
	switch (error) {
		case 1: // authorization failed
			cvs_comando=cvs_comando | CVS_UPDATE;
			on_login1_activate(NULL,NULL);
			break;
	}
	
	if (cvs_comando & CVS_COMMIT) {
		cvs_comando=cvs_comando ^ CVS_COMMIT;
		if (error==0) {
			gen_ventana_mensaje(_("Update was run with out errors.\nNow commit will be run again."),GTK_MESSAGE_INFO);
			on_commit1_activate(NULL,NULL);
		} else {
			g_free(recordar_log);
			recordar_log=NULL;
		}
	}
	
	g_free(cvsroot);
	g_free(compresion);
	g_free(directorio);
	g_free(modulo);
}

void cvs_commit(gchar *log)
{
	gchar *cvsroot;
	gchar *compresion;
	gchar *directorio;
	gchar *modulo;
	gchar *comando;
	gint error;
	
	cvsroot=pro_cvsroot();
	if ((cvsroot==NULL) || (cvsroot[0]==0)) {
		gen_ventana_mensaje(_("You don't have properly configured CVS, you must especify a CVSROOT in the project preferences.\n"),GTK_MESSAGE_ERROR);
		g_free(cvsroot);
		return;
	}
	modulo=pro_modulo_cvs();
	if ((modulo==NULL) || (modulo[0]==0)) {
		gen_ventana_mensaje(_("You don't have properly configured CVS, you must especify a modul in the project preferences.\n"),GTK_MESSAGE_ERROR);
		g_free(modulo);
		g_free(cvsroot);
		return;
	}
	
	compresion=pro_compresion_cvs();
	directorio=pro_prodir(LOCALE);
	chdir(directorio);
	
	gen_limpiar_mensajes();
	g_print(_("------------------------------ Commiting %s ------------------------------\n\n"),modulo);

	comando=g_strdup_printf("cvs -d'%s' -z%s commit -m'%s' 2>/dev/stdout\n",cvsroot,compresion,log);
	error=cvs_ejecutar_commit(comando);
	g_free(comando);
	g_print(_("\nDone\n"));

	switch (error) {
		case 1: // authorization failed
			cvs_comando=cvs_comando | CVS_COMMIT;
			recordar_log=g_strdup(log);
			on_login1_activate(NULL,NULL);
			break;
		case 2: // Up-to-date check failed
			cvs_comando=cvs_comando | CVS_COMMIT;
			recordar_log=g_strdup(log);
			gen_ventana_mensaje(_("Commit could not be conpleated sucsesfuly because an up-to-date error.\nUpdate will be run automaticaly."),GTK_MESSAGE_INFO);
			cvs_update();
			break;
	}
	
	g_free(cvsroot);
	g_free(compresion);
	g_free(directorio);
	g_free(modulo);
}

void cvs_add(gchar *archivo,gint destino)
{
	gchar *comando;
	gchar *cvsroot;
	gchar *compresion;
	gchar *directorio;
	gchar *modulo;
	gchar *mensaje;
	gchar *nombre;
	gchar *prodir,*srcdir,*pixdir,*datadir,*docdir;
	gsize read, written;
	GError *error;

	cvsroot=pro_cvsroot();
	if ((cvsroot==NULL) || (cvsroot[0]==0)) {
		gen_ventana_mensaje(_("You don't have properly configured CVS, you must especify a CVSROOT in the project preferences.\n"),GTK_MESSAGE_ERROR);
		g_free(cvsroot);
		return;
	}
	modulo=pro_modulo_cvs();
	if ((modulo==NULL) || (modulo[0]==0)) {
		gen_ventana_mensaje(_("You don't have properly configured CVS, you must especify a modul in the project preferences.\n"),GTK_MESSAGE_ERROR);
		g_free(modulo);
		g_free(cvsroot);
		return;
	}
	
	prodir=pro_prodir(LOCALE);
	srcdir=pro_srcdir(LOCALE);
	pixdir=pro_pixdir(LOCALE);
	datadir=pro_datadir(LOCALE);
	docdir=pro_docdir(LOCALE);

	nombre=g_locale_from_utf8(archivo,-1,&read,&written,&error);
	compresion=pro_compresion_cvs();
	
	directorio=NULL;
	switch (destino) {
		case ROOT:
			directorio=g_strdup(prodir);
			break;
		case SOURCE:
			directorio=g_strdup_printf("%s/%s",prodir,srcdir);
			break;
		case PIXMAP:
			directorio=g_strdup_printf("%s/%s",prodir,pixdir);
			break;
		case DATA:
			directorio=g_strdup_printf("%s/%s",prodir,datadir);
			break;
		case DOC:
			directorio=g_strdup_printf("%s/%s",prodir,docdir);
			break;
	}
	
	chdir(directorio);
	
	mensaje=g_strdup_printf(_("------------------------------ Adding %s to %s ------------------------------\n\n"),nombre,modulo);

	comando=g_strdup_printf("cvs -d'%s' -z%s add %s 2>/dev/stdout\n",cvsroot,compresion,nombre);
	gen_comando(comando,mensaje);
	g_print(_("\nDone\n"));
	
	g_free(comando);
	g_free(cvsroot);
	g_free(compresion);
	g_free(directorio);
	g_free(modulo);
	g_free(mensaje);
	g_free(nombre);
	g_free(prodir);
	g_free(srcdir);
	g_free(pixdir);
	g_free(datadir);
	g_free(docdir);
}

void cvs_remove(gchar *archivo,gint destino)
{
	gchar *comando;
	gchar *cvsroot;
	gchar *compresion;
	gchar *directorio;
	gchar *modulo;
	gchar *mensaje;
	gchar *nombre;
	gchar *prodir,*srcdir,*pixdir,*datadir,*docdir;
	gsize read, written;
	GError *error;
	
	cvsroot=pro_cvsroot();
	if ((cvsroot==NULL) || (cvsroot[0]==0)) {
		gen_ventana_mensaje(_("You don't have properly configured CVS, you must especify a CVSROOT in the project preferences.\n"),GTK_MESSAGE_ERROR);
		g_free(cvsroot);
		return;
	}
	modulo=pro_modulo_cvs();
	if ((modulo==NULL) || (modulo[0]==0)) {
		gen_ventana_mensaje(_("You don't have properly configured CVS, you must especify a modul in the project preferences.\n"),GTK_MESSAGE_ERROR);
		g_free(modulo);
		g_free(cvsroot);
		return;
	}
	
	prodir=pro_prodir(LOCALE);
	srcdir=pro_srcdir(LOCALE);
	pixdir=pro_pixdir(LOCALE);
	datadir=pro_datadir(LOCALE);
	docdir=pro_docdir(LOCALE);

	nombre=g_locale_from_utf8(archivo,-1,&read,&written,&error);
	compresion=pro_compresion_cvs();

	directorio=NULL;
	switch (destino) {
		case ROOT:
			directorio=g_strdup(prodir);
			break;
		case SOURCE:
			directorio=g_strdup_printf("%s/%s",prodir,srcdir);
			break;
		case PIXMAP:
			directorio=g_strdup_printf("%s/%s",prodir,pixdir);
			break;
		case DATA:
			directorio=g_strdup_printf("%s/%s",prodir,datadir);
			break;
		case DOC:
			directorio=g_strdup_printf("%s/%s",prodir,docdir);
			break;
	}
	chdir(directorio);
	
	mensaje=g_strdup_printf(_("------------------------------ Removing %s from %s ------------------------------\n\n"),nombre,modulo);

	comando=g_strdup_printf("cvs -d'%s' -z%s remove %s 2>/dev/stdout\n",cvsroot,compresion,nombre);
	gen_comando(comando,mensaje);
	g_print(_("\nDone\n"));
	
	g_free(comando);
	g_free(cvsroot);
	g_free(compresion);
	g_free(directorio);
	g_free(modulo);
	g_free(mensaje);
	g_free(nombre);
	g_free(prodir);
	g_free(srcdir);
	g_free(pixdir);
	g_free(datadir);
	g_free(docdir);
}

// This funciton will run the update command
// It will reload modified files, and will try to detect some connection errors
// It will return different values depending on the detected error
// 0 - no error
// 1 - authorization failed
// 2 - conflict mergin file
gint cvs_ejecutar_update(gchar *comando)
{
	FILE *tuberia;
	gchar letra;
	gchar *cadena;
	gchar *temporal;
	guint mas;
	gsize bytes_read, bytes_written;
	GError *error;
	gboolean result =FALSE;
	const gchar *punto_malo;
	G_CONST_RETURN char *locale;
	gint cont,cont2;
	gint tipo;
	gboolean command_error;
	gint error_salida;
	gchar *nombre,*nombre_utf8;
	
	tuberia=popen(comando,"r");
	temporal=NULL;
	cadena=NULL;
	error_salida=0;
	do {
		gen_refrescar();
		mas=fread(&letra,1,1,tuberia);
		if (mas) {
			if (temporal!=NULL) {
				cadena=g_strdup_printf("%s%c",temporal,letra);
				g_free(temporal);
				temporal=cadena;
			} else {
				cadena=g_strdup_printf("%c",letra);
				temporal=cadena;
			}
			if (letra=='\n') {
				command_error=FALSE;
				if ((cadena[0]=='C') && (cadena[1]==' ')) {
					command_error=TRUE;
					error_salida=2;
					for (cont=0;cadena[cont]!=0;cont++);
					cont2=cont-1;
					for (;(cadena[cont]!='/') && (cadena[cont]!=' ');cont--);
					cont++;
					nombre=g_strndup(cadena+cont,cont2-cont);
					g_get_charset(&locale);
					nombre_utf8 = g_convert(nombre, strlen(nombre), "UTF-8", locale, &bytes_read, &bytes_written, &error);
					g_free(nombre);
					if (pro_existe_archivo(nombre_utf8)) {
						tipo=gen_tipo_archivo(nombre_utf8);
						if ((tipo==1) || (tipo==2)) {
							cefv_eliminar_archivo(nombre_utf8);
						}
						edit_recargar_archivo(nombre_utf8);
					}
					g_free(nombre_utf8);
				}
				if (!strncmp(cadena,"cvs update: authorization failed:",33)) {
					command_error=TRUE;
					error_salida=1;
				}
				if (((cadena[0]=='U') || (cadena[0]=='P') || (cadena[0]=='M')) && (cadena[1]==' ')) {
					for (cont=0;cadena[cont]!=0;cont++);
					cont2=cont-1;
					for (;(cadena[cont]!='/') && (cadena[cont]!=' ');cont--);
					cont++;
					nombre=g_strndup(cadena+cont,cont2-cont);
					g_get_charset(&locale);
					nombre_utf8 = g_convert(nombre, strlen(nombre), "UTF-8", locale, &bytes_read, &bytes_written, &error);
					g_free(nombre);
					if (pro_existe_archivo(nombre_utf8)) {
						tipo=gen_tipo_archivo(nombre_utf8);
						if ((tipo==1) || (tipo==2)) {
							cefv_eliminar_archivo(nombre_utf8);
						}
						edit_recargar_archivo(nombre_utf8);
					}
					g_free(nombre_utf8);
				}
				result = g_utf8_validate(temporal, -1, &punto_malo);
				if (!result) {
					temporal = cadena;
					g_get_charset(&locale);
					cadena = g_convert(temporal, strlen(temporal), "UTF-8", locale, &bytes_read, &bytes_written, &error);
					g_free(temporal);
				}
				if (command_error) {
					g_printerr("%s",cadena);
				} else {
					g_print("%s",cadena);
				}
				g_free(cadena);
				temporal=NULL;
				cadena=NULL;
			}
		}
	} while (mas);	
	if (cadena!=NULL) {
		g_free(cadena);
	}
	pclose(tuberia);
	
	return error_salida;
}

// This funciton will run the commit command
// It will try to detect some connection errors
// It will return different values depending on the detected error
// 0 - no error
// 1 - authorization failed
// 2 - Up-to-date check failed
gint cvs_ejecutar_commit(gchar *comando)
{
	FILE *tuberia;
	gchar letra;
	gchar *cadena;
	gchar *temporal;
	guint mas;
	gsize bytes_read, bytes_written;
	GError *error;
	gboolean result =FALSE;
	const gchar *punto_malo;
	G_CONST_RETURN char *locale;
	gboolean command_error;
	gint error_salida;
	
	tuberia=popen(comando,"r");
	temporal=NULL;
	cadena=NULL;
	error_salida=0;
	do {
		gen_refrescar();
		mas=fread(&letra,1,1,tuberia);
		if (mas) {
			if (temporal!=NULL) {
				cadena=g_strdup_printf("%s%c",temporal,letra);
				g_free(temporal);
				temporal=cadena;
			} else {
				cadena=g_strdup_printf("%c",letra);
				temporal=cadena;
			}
			if (letra=='\n') {
				command_error=FALSE;
				if (!strncmp(cadena,"cvs commit: authorization failed:",33)) {
					command_error=TRUE;
					error_salida=1;
				}
				if (!strncmp(cadena,"cvs server: Up-to-date check failed for",39)) {
					command_error=TRUE;
					error_salida=2;
				}
				result = g_utf8_validate(temporal, -1, &punto_malo);
				if (!result) {
					temporal = cadena;
					g_get_charset(&locale);
					cadena = g_convert(temporal, strlen(temporal), "UTF-8", locale, &bytes_read, &bytes_written, &error);
					g_free(temporal);
				}
				if (command_error) {
					g_printerr("%s",cadena);
				} else {
					g_print("%s",cadena);
				}
				g_free(cadena);
				temporal=NULL;
				cadena=NULL;
			}
		}
	} while (mas);	
	if (cadena!=NULL) {
		g_free(cadena);
	}
	pclose(tuberia);
	
	return error_salida;
}

void cvs_login(gchar *password)
{
	gchar *cvsroot;
	gchar *directorio;
	gchar *modulo;
	
	cvsroot=pro_cvsroot();
	if ((cvsroot==NULL) || (cvsroot[0]==0)) {
		gen_ventana_mensaje(_("You don't have properly configured CVS, you must especify a CVSROOT in the project preferences.\n"),GTK_MESSAGE_ERROR);
		g_free(cvsroot);
		return;
	}
	modulo=pro_modulo_cvs();
	if ((modulo==NULL) || (modulo[0]==0)) {
		gen_ventana_mensaje(_("You don't have properly configured CVS, you must especify a modul in the project preferences.\n"),GTK_MESSAGE_ERROR);
		g_free(modulo);
		g_free(cvsroot);
		return;
	}
	directorio=pro_prodir(LOCALE);
	chdir(directorio);
	
	gen_limpiar_mensajes();
	g_print(_("------------------------------ Logging in ------------------------------\n\n"));
	
	cvs_ejecutar_login(password);

	g_print(_("\nDone\n"));
	
	g_free(cvsroot);
	g_free(directorio);
	g_free(modulo);
}

void cvs_logout(void)
{
	gchar *comando;
	gchar *cvsroot;
	gchar *directorio;
	gchar *modulo;
	gchar *mensaje;
	
	cvsroot=pro_cvsroot();
	if ((cvsroot==NULL) || (cvsroot[0]==0)) {
		gen_ventana_mensaje(_("You don't have properly configured CVS, you must especify a CVSROOT in the project preferences.\n"),GTK_MESSAGE_ERROR);
		g_free(cvsroot);
		return;
	}
	modulo=pro_modulo_cvs();
	if ((modulo==NULL) || (modulo[0]==0)) {
		gen_ventana_mensaje(_("You don't have properly configured CVS, you must especify a modul in the project preferences.\n"),GTK_MESSAGE_ERROR);
		g_free(modulo);
		g_free(cvsroot);
		return;
	}
	directorio=pro_prodir(LOCALE);
	chdir(directorio);
	
	gen_limpiar_mensajes();
	mensaje=g_strdup_printf(_("------------------------------ Logging out ------------------------------\n\n"));
	
	comando=g_strdup_printf("cvs -d'%s' logout 2>/dev/stdout\n",cvsroot);
	gen_comando(comando,mensaje);
	g_print(_("\nDone\n"));
	
	g_free(comando);
	g_free(cvsroot);
	g_free(directorio);
	g_free(modulo);
	g_free(mensaje);
}

void cvs_ejecutar_login (gchar *password)
{
	gint login_socket;
	struct hostent *cvs_host;
	struct sockaddr_in cliente;
	socklen_t addr_size;
	gchar *cvsroot;
	gint cont1,cont2;
	gchar *host;
	gchar *user;
	gchar *root;
	gchar *a_port;
	gchar *passwd;
	gchar caracter,*tmp,*cadena;
	gboolean fin_comunicacion;
	gchar *mensaje;
	gint n;
	gint port;
	gsize bytes_read, bytes_written;
	GError *error;
	gboolean result =FALSE;
	const gchar *punto_malo;
	G_CONST_RETURN char *locale;

	// first we create the socket
	login_socket=socket(PF_INET,SOCK_STREAM,0);
	if (login_socket==-1) {
		return;
	}

	cvsroot=pro_cvsroot();
	
	//first we get the user name  from the cvsroot
	for (cont1=0;cvsroot[cont1]!='@';cont1++);
	for (cont2=cont1;cvsroot[cont2]!=':';cont2--);
	cont2++;
	user=g_strndup(cvsroot+cont2,cont1-cont2);
	
	//now we find out the server's name from the cvsroot
	for (cont1=0;cvsroot[cont1]!='@';cont1++);
	cont1++;
	for (cont2=cont1;cvsroot[cont2]!=':';cont2++);
	host=g_strndup(cvsroot+cont1,cont2-cont1);

	//now we get the cvs root
	for (cont1=0;cvsroot[cont1]!=0;cont1++);
	for (cont2=cont1;cvsroot[cont2]!=':';cont2--);
	cont2++;
	root=g_strndup(cvsroot+cont2,cont1-cont2);

	//we get the port from cvsroot if it is there
	for (cont1=0;cvsroot[cont1]!='/';cont1++);
	for (cont2=cont1;cvsroot[cont2]!=':';cont2--);
	cont2++;
	if (cont1!=cont2) {
		a_port=g_strndup(cvsroot+cont2,cont1-cont2);
		port=atoi(a_port);
	} else {
		port=2401;
		a_port=NULL;
	}
	
	passwd=cvs_encript_password(password);
	
	//we need the IP address
	cvs_host=gethostbyname(host);
	
	//initialitation of the client structure
	memset(&cliente,0,sizeof(cliente));
	cliente.sin_family=AF_INET;
	cliente.sin_port=htons(port);
	cliente.sin_addr=*(struct in_addr *)cvs_host->h_addr;
	
	//now we connect to the server
	addr_size=sizeof(cliente);
	if (connect(login_socket,(struct sockaddr *)&cliente,addr_size)<0) {
		return;
	}
	
	mensaje=g_strdup("BEGIN VERIFICATION REQUEST\n");
	send(login_socket,mensaje,strlen(mensaje),0);
	g_free(mensaje);

	send(login_socket,root,strlen(root),0);
	send(login_socket,"\n",1,0);

	send(login_socket,user,strlen(user),0);
	send(login_socket,"\n",1,0);
	
	send(login_socket,passwd,strlen(passwd),0);
	send(login_socket,"\n",1,0);

	mensaje=g_strdup("END VERIFICATION REQUEST\n");
	send(login_socket,mensaje,strlen(mensaje),0);
	g_free(mensaje);

	tmp=NULL;
	fin_comunicacion=FALSE;
	while (!fin_comunicacion) {
		n=recv(login_socket,&caracter,1,0);
		if (n<=0) {
			fin_comunicacion=TRUE;
		}
		if (tmp==NULL) {
			cadena=g_strdup_printf("%c",caracter);
		} else {
			cadena=g_strdup_printf("%s%c",tmp,caracter);
		}
		g_free(tmp);
		tmp=cadena;
		if ((caracter=='\n') || ((cadena!=NULL) && (n<=0))) {
			if (!strcmp(cadena,"I LOVE YOU\n")) {
				cvs_crear_cvspass(passwd);
			}
			if (!strcmp(cadena,"I HATE YOU\n")) {
				cvs_comando=cvs_comando | CVS_LOGIN;
			}
			result=g_utf8_validate(cadena,-1,&punto_malo);
			if (!result) {
				tmp=cadena;
				g_get_charset(&locale);
				cadena=g_convert(tmp,strlen(tmp),"UTF-8",locale,&bytes_read,&bytes_written,&error);
				g_free(tmp);
			}
			g_print(cadena);
			tmp=NULL;
			g_free(cadena);
			cadena=NULL;
		}
	}
	
	shutdown(login_socket,SHUT_RDWR);
	
	g_free(cvsroot);
	g_free(host);
	g_free(user);
	g_free(passwd);
	g_free(a_port);
}

gchar *cvs_encript_password(gchar *password)
{
	gchar *encripted;
	gint cont;
	static unsigned char shifts[]={
										  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,  
										 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,  
										114,120, 53, 79, 96,109, 72,108, 70, 64, 76, 67,116, 74, 68, 87,  
										111, 52, 75,119, 49, 34, 82, 81, 95, 65,112, 86,118,110,122,105,  
										 41, 57, 83, 43, 46,102, 40, 89, 38,103, 45, 50, 42,123, 91, 35,  
										125, 55, 54, 66,124,126, 59, 47, 92, 71,115, 78, 88,107,106, 56,  
										 36,121,117,104,101,100, 69, 73, 99, 63, 94, 93, 39, 37, 61, 48,  
										 58,113, 32, 90, 44, 98, 60, 51, 33, 97, 62, 77, 84, 80, 85,223,  
										225,216,187,166,229,189,222,188,141,249,148,200,184,136,248,190,  
										199,170,181,204,138,232,218,183,255,234,220,247,213,203,226,193,  
										174,172,228,252,217,201,131,230,197,211,145,238,161,179,160,212,  
										207,221,254,173,202,146,224,151,140,196,205,130,135,133,143,246,  
										192,159,244,239,185,168,215,144,139,165,180,157,147,186,214,176,  
										227,231,219,169,175,156,206,198,129,164,150,210,154,177,134,127,  
										182,128,158,208,162,132,167,209,149,241,153,251,237,236,171,195,  
										243,233,253,240,194,250,191,155,142,137,245,235,163,242,178,152 };
	
	encripted=g_strdup_printf("A%s",password);
	
	for (cont=1;encripted[cont]!=0;cont++) {
		encripted[cont]=shifts[(unsigned char)(encripted[cont])];
	}

	return encripted;
}

void cvs_crear_cvspass(gchar *password)
{
	gchar *cvsroot;
	gint cont1,cont2;
	gchar *cvsrootport;
	gchar *tmp;
	FILE *archivo;
	gchar *cvspass;
	gchar *linea;
	struct passwd *info;
	
	cvsroot=pro_cvsroot();
	
	for (cont1=0;cvsroot[cont1]!='/';cont1++);
	for (cont2=cont1;cvsroot[cont2]!=':';cont2--);
	cont2++;
	if (cont1==cont2) {
		tmp=g_strndup(cvsroot,cont1);
		cvsrootport=g_strdup_printf("%s2401%s",tmp,cvsroot+cont1);
		g_free(tmp);
	} else {
		cvsrootport=g_strdup(cvsroot);
	}
	linea=g_strdup_printf("/1 %s %s\n",cvsrootport,password);

	info=getpwuid(getuid());
	cvspass=g_strdup_printf("%s/.cvspass",info->pw_dir);
	archivo=fopen(cvspass,"a+");
	fwrite(linea,1,strlen(linea),archivo);
	fclose(archivo);

	g_free(cvsroot);
	g_free(cvsrootport);
	g_free(linea);
	g_free(cvspass);
}
