/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

void edit_inicializar(void)
{
	raiz_lista_archivos=NULL;
	edit_actual=NULL;
	edit_abriendo_llave=FALSE;
	edit_total_pestanas=1;
	edit_historico_funciones=NULL;
	edit_congelar_historico=TRUE;
	edit_marcador=0;

	c_fondo.red=65535;
	c_fondo.green=65535;
	c_fondo.blue=65535;

	c_nada.red=0;
	c_nada.green=0;
	c_nada.blue=0;

	c_comentario.red=40000;
	c_comentario.green=40000;
	c_comentario.blue=40000;

	c_directiva.red=1000;
	c_directiva.green=45000;
	c_directiva.blue=1000;

	c_cadena_cs.red=65535;
	c_cadena_cs.green=40000;
	c_cadena_cs.blue=0;

	c_cadena_cd.red=65535;
	c_cadena_cd.green=20000;
	c_cadena_cd.blue=0;

	c_etiqueta.red=1000;
	c_etiqueta.green=1000;
	c_etiqueta.blue=50000;

	c_entero.red=50000;
	c_entero.green=1000;
	c_entero.blue=1000;

	c_real.red=40000;
	c_real.green=50000;
	c_real.blue=0;

	c_hexadecimal.red=60000;
	c_hexadecimal.green=0;
	c_hexadecimal.blue=60000;

	c_octal.red=50000;
	c_octal.green=40000;
	c_octal.blue=30000;
	
	c_prelight.red=0;
	c_prelight.green=0;
	c_prelight.blue=0;
}

void edit_cerrar(void)
{
	struct s_lista_archivos *nodo;
	GList *lista;

	lista=cefv_lista_combo;
	while (lista!=NULL) {
		g_free(lista->data);
		lista=lista->next;
	}
	g_list_free(cefv_lista_combo);
	cefv_lista_combo=NULL;

	if (raiz_lista_archivos!=NULL) {
		nodo=raiz_lista_archivos;
		while (nodo->siguiente!=NULL) {
			nodo=nodo->siguiente;
		}
		while (nodo->anterior!=NULL) {
			cefv_eliminar_archivo(nodo->nombre);
			arch_eliminar(nodo->nombre);
			g_free(nodo->nombre);
			g_free(nodo->datos);
			nodo=nodo->anterior;
			g_free(nodo->siguiente);
		}
		cefv_eliminar_archivo(nodo->nombre);
		arch_eliminar(nodo->nombre);
		g_free(nodo->nombre);
		g_free(nodo->datos);
		g_free(nodo);
		raiz_lista_archivos=NULL;
	}
}

void edit_anadir(gchar *nombre,GtkTreeIter *nodo_arbol)
{
	struct s_lista_archivos *nodo_lista;
	guint cont;
	gint tipo;
	G_CONST_RETURN char *locale;
	GError *error;
	gchar *nombre_locale;
	gsize read, written;
			
	DEBUG_MSG(->edit_anadir);
	if (raiz_lista_archivos==NULL) {
		raiz_lista_archivos=g_malloc(sizeof(struct s_lista_archivos));
		nodo_lista=raiz_lista_archivos;
		nodo_lista->anterior=NULL;
	} else {
		nodo_lista=raiz_lista_archivos;
		while (nodo_lista->siguiente!=NULL) {
			nodo_lista=nodo_lista->siguiente;
		}
		nodo_lista->siguiente=g_malloc(sizeof(struct s_lista_archivos));
		nodo_lista->siguiente->anterior=nodo_lista;
		nodo_lista=nodo_lista->siguiente;
	}
	nodo_lista->siguiente=NULL;
//	nodo_lista->nodo_arbol=nodo_arbol;
	memcpy(&(nodo_lista->nodo_arbol),nodo_arbol,sizeof(GtkTreeIter));
	for (cont=0;nombre[cont]!=0;cont++);
	for (;nombre[cont]!='/';cont--);
	nodo_lista->nombre=g_strdup(&(nombre[cont+1]));
	nodo_lista->posicion=NULL;
	nodo_lista->editor=NULL;
	nodo_lista->pestana=-1;
	nodo_lista->datos=gtk_source_buffer_new(NULL);
	tipo=gen_tipo_archivo(nodo_lista->nombre);
	if ((tipo==1) || (tipo==2)) {
		edit_aplicar_reglas_coloreado(nodo_lista->datos);
	} else {
		gtk_source_buffer_set_highlight(nodo_lista->datos,FALSE);
	}
	
	g_get_charset(&locale);
	gtk_source_buffer_set_undo_levels(nodo_lista->datos,100);
	gtk_source_buffer_begin_not_undoable_action(nodo_lista->datos);
	nombre_locale = g_locale_from_utf8(nombre, -1, &read, &written, &error);
	gtk_source_buffer_load_with_character_encoding(nodo_lista->datos,nombre_locale,locale,&error);
	g_free(nombre_locale);
	g_signal_connect_after(G_OBJECT(nodo_lista->datos),"insert_text",G_CALLBACK(on_editor_texto_insert_text),NULL);
	g_signal_connect(G_OBJECT(nodo_lista->datos),"mark_set",G_CALLBACK(on_source_buffer_mark_set),NULL);
	g_signal_connect_after(G_OBJECT(nodo_lista->datos),"changed",G_CALLBACK(on_source_buffer_changed),NULL);
	gtk_source_buffer_end_not_undoable_action(nodo_lista->datos);
	cefv_analizar_archivo(nodo_lista->nombre);
	nodo_lista->analizado=TRUE;
	DEBUG_MSG(<-edit_anadir);
}

void edit_guardar_todo(void)
{
	struct s_lista_archivos *nodo,*actual;
	gchar *nombre;
	G_CONST_RETURN char *locale;
	GError *error;
	
	DEBUG_MSG(->edit_guardar_todo);
	actual=edit_actual;
	edit_actual=raiz_lista_archivos;
	while (edit_actual!=NULL) {
		if (edit_actual->pestana!=-1) {
			edit_actualizar();
		}
		edit_actual=edit_actual->siguiente;
	} 
	edit_actual=actual;
	nodo=raiz_lista_archivos;
	while (nodo!=NULL) {
		if (gtk_text_buffer_get_modified(GTK_TEXT_BUFFER(nodo->datos))) {
			nombre=pro_nombre_completo_archivo(nodo->nombre,FALSE, LOCALE);
			g_get_charset(&locale);
			gtk_source_buffer_save_with_character_encoding(nodo->datos,nombre,locale,&error);
			gtk_text_buffer_set_modified(GTK_TEXT_BUFFER(nodo->datos),FALSE);
			g_free(nombre);
		}
		nodo=nodo->siguiente;
	}
	DEBUG_MSG(<-edit_guardar_todo);
}

void edit_ver(gchar *nombre)
{
	GtkLabel *etiqueta;
	struct s_lista_archivos *nodo;
	GtkTextIter posicion;

	DEBUG_MSG(->edit_ver);
	if ((edit_actual!=NULL) && (edit_marcador!=0)) {
		gtk_source_buffer_line_remove_marker(edit_actual->datos,edit_marcador,"marcador");
		edit_marcador=0;
	}
	nodo=raiz_lista_archivos;
	while (g_strcasecmp(nodo->nombre,nombre)) {
		nodo=nodo->siguiente;
	}
	if (nodo->pestana!=-1) {
		if (nodo->posicion!=NULL) {
			DEBUG_MSG(haciendo scroll);
			gtk_text_view_scroll_to_mark(GTK_TEXT_VIEW(nodo->editor),nodo->posicion,0,TRUE,0,0);
			gtk_text_buffer_get_iter_at_mark(GTK_TEXT_BUFFER(nodo->datos),&posicion,nodo->posicion);
			gtk_text_buffer_place_cursor(GTK_TEXT_BUFFER(nodo->datos),&posicion);
			DEBUG_MSG(->delete_mark_edit_ver<-);
			gtk_text_buffer_delete_mark(GTK_TEXT_BUFFER(nodo->datos),nodo->posicion);
			nodo->posicion=NULL;
		}
		edit_actual=nodo;
		DEBUG_MSG(<-edit_ver 1);
		return;
	}
	if (nodo->editor==NULL) {
		edit_actual=raiz_lista_archivos;
		while (edit_actual!=NULL && edit_actual->pestana!=0) {
			edit_actual=edit_actual->siguiente;
		}
		if (edit_actual!=NULL) {
//			editor->selection_end_pos=editor->selection_start_pos;
			edit_actualizar();
			edit_actual->editor=NULL;
			edit_actual->pestana=-1;
			if (!edit_actual->analizado) {
				cefv_analizar_archivo(edit_actual->nombre);
				edit_actual->analizado=TRUE;
			}
		}
		nodo->pestana=0;
		nodo->editor=edit_editor;
	}
	gtk_text_view_set_buffer(GTK_TEXT_VIEW(nodo->editor),GTK_TEXT_BUFFER(nodo->datos));
	gtk_text_view_set_editable(GTK_TEXT_VIEW(nodo->editor),TRUE);
	if (nodo->posicion!=NULL) {
		DEBUG_MSG(haciendo scroll);
		gtk_text_view_scroll_to_mark(GTK_TEXT_VIEW(nodo->editor),nodo->posicion,0,TRUE,0,0);
		gtk_text_buffer_get_iter_at_mark(GTK_TEXT_BUFFER(nodo->datos),&posicion,nodo->posicion);
		gtk_text_buffer_place_cursor(GTK_TEXT_BUFFER(nodo->datos),&posicion);
		DEBUG_MSG(->delete_mark_edit_ver2<-);
		gtk_text_buffer_delete_mark(GTK_TEXT_BUFFER(nodo->datos),nodo->posicion);
		nodo->posicion=NULL;
	}
	edit_actual=nodo;

	etiqueta=GTK_LABEL(glade_xml_get_widget(david_ventana,"editor_etiqueta"));
	gtk_label_set(etiqueta,nombre);
	edit_actualizar_fila();
	buscar_indice=0;
	buscar_terminado=FALSE;
	edit_abriendo_llave=FALSE;
	edit_mensaje("");
	DEBUG_MSG(<-edit_ver);
}

void edit_borrar_seleccion(void)
{
	GtkTextBuffer *buffer;
	GtkTextIter comienzo,fin;

	if (edit_actual!=NULL) {
		buffer=GTK_TEXT_BUFFER(edit_actual->datos);
		if (gtk_text_buffer_get_selection_bounds(buffer,&comienzo,&fin)) {
			gtk_text_buffer_delete(buffer,&comienzo,&fin);
		}
	}
}

void edit_copiar_seleccion(void)
{
	GtkTextBuffer *buffer;

	if (edit_actual!=NULL) {
		buffer=GTK_TEXT_BUFFER(edit_actual->datos);
		gtk_text_buffer_copy_clipboard(buffer,gen_clipboard);
	}
}

void edit_cortar_seleccion(void)
{
	GtkTextBuffer *buffer;

	if (edit_actual!=NULL) {
		buffer=GTK_TEXT_BUFFER(edit_actual->datos);
		gtk_text_buffer_cut_clipboard(buffer,gen_clipboard,TRUE);
	}
}

void edit_pegar_seleccion(void)
{
	GtkTextBuffer *buffer;

	if (edit_actual!=NULL) {
		buffer=GTK_TEXT_BUFFER(edit_actual->datos);
		gtk_text_buffer_paste_clipboard(buffer,gen_clipboard,NULL,TRUE);
	}
}

void edit_guardar(void)
{
	struct s_lista_archivos *nodo;
	gchar *nombre;
	G_CONST_RETURN char *locale;
	GError *error;
	
	DEBUG_MSG(->edit_guardar);
	if (edit_actual!=NULL) {
		edit_actualizar();
		nodo=edit_actual;
		if (gtk_text_buffer_get_modified(GTK_TEXT_BUFFER(nodo->datos))) {
			DEBUG_MSG(guardando archivo);
			nombre=pro_nombre_completo_archivo(nodo->nombre,FALSE, LOCALE);
			g_get_charset(&locale);
			gtk_source_buffer_save_with_character_encoding(nodo->datos,nombre,locale,&error);
			gtk_text_buffer_set_modified(GTK_TEXT_BUFFER(nodo->datos),FALSE);
			g_free(nombre);
		} else {
			DEBUG_MSG(el archivo actual no ha sido modificado);
		}
	} else {
		DEBUG_MSG(no hay archivo seleccionado);
	}
	DEBUG_MSG(<-edit_guardar);
}

void edit_eliminar(gchar *nombre)
{
	GtkTextView *editor;
	GtkLabel *etiqueta;
	struct s_lista_archivos *nodo;
	GtkWidget *notebook;
	gint pestana_actual;

	nodo=edit_conseguir_nodo(nombre);
	editor=GTK_TEXT_VIEW(nodo->editor);
	gtk_text_view_set_buffer(editor,GTK_TEXT_BUFFER(empty_buffer));
	if (nodo->pestana==0) {
		etiqueta=GTK_LABEL(glade_xml_get_widget(david_ventana,"editor_etiqueta"));
		gtk_label_set(etiqueta,_("Files"));
	} else {
		pestana_actual=edit_actual->pestana;
		notebook=glade_xml_get_widget(david_ventana,"archivos_notebook");
		edit_actual->editor=NULL;
		edit_actual->pestana=-1;
		gtk_notebook_set_page(GTK_NOTEBOOK(notebook),0);
		gtk_notebook_remove_page(GTK_NOTEBOOK(notebook),pestana_actual);
		edit_total_pestanas--;
		edit_actual=raiz_lista_archivos;
		while (edit_actual!=NULL) {
			if (edit_actual->pestana>pestana_actual) {
				edit_actual->pestana--;
			}
			edit_actual=edit_actual->siguiente;
		}
		edit_actual=raiz_lista_archivos;
		while (edit_actual!=NULL && edit_actual->pestana!=0) {
			edit_actual=edit_actual->siguiente;
		}
	}
	edit_actualizar_fila();

	if (nodo->siguiente!=NULL) {
		nodo->siguiente->anterior=nodo->anterior;
	}
	if (nodo->anterior!=NULL) {
		nodo->anterior->siguiente=nodo->siguiente;
	} else {
		raiz_lista_archivos=nodo->siguiente;
	}

	if (nodo==edit_actual) {
		edit_actual=NULL;
	}
	g_object_unref(G_OBJECT(nodo->datos));
	g_free(nodo->nombre);
	g_free(nodo);
}

void edit_actualizar (void)
{
/*	GtkSourceView *editor;
	guint cont;
	GtkTextIter start,end;

	DEBUG_MSG(->edit_actualizar);
	if (edit_actual!=NULL) {
		editor=edit_actual->editor;
		g_free(edit_actual->datos);
		gtk_text_buffer_get_bounds(GTK_TEXT_BUFFER(editor),&start,&end);
		edit_actual->datos=gtk_text_buffer_get_text(GTK_TEXT_BUFFER(editor),&start,&end,FALSE);
//		edit_actual->size=gtk_text_buffer_get_char_count(GTK_TEXT_BUFFER(editor));
//		edit_actual->posicion=gtk_editable_get_position(GTK_EDITABLE(editor));
//		edit_actual->ajuste=editor->vadj->value;
//		edit_actual->limite_ajuste=editor->vadj->upper;
		edit_actual->filas=1;
		for (cont=0;cont<edit_actual->size;cont++) {
			if ((edit_actual->datos)[cont]=='\n') {
				(edit_actual->filas)++;
			}
		}
	}
	DEBUG_MSG(<-edit_actualizar); */
}

void edit_actualizar_fila(void)
{
	GtkLabel *etiqueta;
	gchar *texto;

	if (edit_actual!=NULL) return;
	etiqueta=GTK_LABEL(glade_xml_get_widget(david_ventana,"fila_etiqueta"));
	texto=g_strdup_printf(_("Row: 0  Colum: 0"));
	gtk_label_set(etiqueta,texto);
	g_free(texto);

}

void edit_auto_formato(GtkTextBuffer *buffer,const gchar *texto,guint longitud,GtkTextIter *posicion)
{
	GtkTextIter cont,cont2;
	guint tabuladores;
	gchar *cadena,*tab1,*tab2;
	GtkTextIter nueva_posicion;
	gint llaves;
	GtkTextIter borrar1,borrar2;	
	GtkTextMark *referencia;

	DEBUG_MSG(->edit_auto_formato);	
	referencia=gtk_text_buffer_create_mark(buffer,NULL,posicion,TRUE);
	if ((texto[0]=='\n') && (longitud==1) && (gtk_text_iter_get_offset(posicion)!=1)) {
		edit_actualizar();
		memcpy(&cont,posicion,sizeof(GtkTextIter));
		gtk_text_iter_backward_chars(&cont,2);
		while ((gtk_text_iter_get_char(&cont)!=g_utf8_get_char("\n")) && (gtk_text_iter_get_offset(&cont)!=0)) {
			gtk_text_iter_backward_char(&cont);
		}
		tabuladores=0;
		gtk_text_iter_forward_char(&cont);
		while (gtk_text_iter_get_char(&cont)==g_utf8_get_char("\t")) {
			tabuladores++;
			gtk_text_iter_forward_char(&cont);
		}
		memcpy(&cont,posicion,sizeof(GtkTextIter));
		gtk_text_iter_backward_chars(&cont,2);
		if ((gtk_text_iter_get_char(&cont)==g_utf8_get_char("{")) && (edit_abriendo_llave) && (preferencias.completar_llaves)) {		
			memcpy(&nueva_posicion,posicion,sizeof(GtkTextIter));
			if (tabuladores) {
				tab1=g_strnfill(tabuladores+1,'\t');
				tab2=g_strnfill(tabuladores,'\t');
				cadena=g_strdup_printf("%s\n%s}",tab1,tab2);
				gtk_text_buffer_insert(buffer,posicion,cadena,-1);				
				gtk_text_buffer_get_iter_at_mark(buffer,&nueva_posicion,referencia);
				gtk_text_iter_forward_chars(&nueva_posicion,tabuladores+1);				
				gtk_text_buffer_place_cursor(buffer,&nueva_posicion);
				g_free(tab1);
				g_free(tab2);
				g_free(cadena);
			} else {
				tab1=g_strnfill(1,'\t');
				cadena=g_strdup_printf("%s\n}",tab1);
				gtk_text_buffer_insert(buffer,posicion,cadena,-1);
				gtk_text_buffer_get_iter_at_mark(buffer,&nueva_posicion,referencia);
				gtk_text_iter_forward_char(&nueva_posicion);
				gtk_text_buffer_place_cursor(buffer,&nueva_posicion);
				g_free(tab1);
				g_free(cadena);
			}
		} else {
			if ((gtk_text_iter_get_char(&cont)==g_utf8_get_char("{")) && (preferencias.super_indentacion)) {
				tabuladores++;
			}
			if ((gtk_text_iter_get_char(&cont)==g_utf8_get_char(":")) && (preferencias.super_indentacion)) {
				tabuladores++;
			}
			if ((tabuladores) && (preferencias.auto_indentacion)) {
				cadena=g_strnfill(tabuladores,'\t');
				gtk_text_buffer_insert(buffer,posicion,cadena,tabuladores);
				g_free(cadena);
			}
		}
	} else {
		if ((texto[0]=='}') && (longitud==1) && (preferencias.super_indentacion)) {
			edit_actualizar();
			memcpy(&cont,posicion,sizeof(GtkTextIter));
			tabuladores=0;
			if (gtk_text_iter_get_offset(&cont)>1) {
				gtk_text_iter_backward_chars(&cont,2);
				while ((gtk_text_iter_get_offset(&cont)!=0) && (gtk_text_iter_get_char(&cont)==g_utf8_get_char("\t"))) {
					gtk_text_iter_backward_char(&cont);
					tabuladores++;
				}
				if (gtk_text_iter_get_char(&cont)!=g_utf8_get_char("\t")) gtk_text_iter_forward_char(&cont);
			}
			memcpy(&cont2,&cont,sizeof(GtkTextIter));
			gtk_text_iter_backward_char(&cont2);
			if ((gtk_text_iter_get_offset(&cont)==0) || (gtk_text_iter_get_char(&cont2)==g_utf8_get_char("\n"))) {
				memcpy(&borrar1,&cont,sizeof(GtkTextIter));
				memcpy(&borrar2,&cont,sizeof(GtkTextIter));
				gtk_text_iter_forward_chars(&borrar2,tabuladores);
				llaves=1;
				gtk_text_iter_backward_char(&cont);
				while ((gtk_text_iter_get_offset(&cont)>=0) && (llaves!=0)) {
					if (gtk_text_iter_get_char(&cont)==g_utf8_get_char("{")) llaves--;
					if (gtk_text_iter_get_char(&cont)==g_utf8_get_char("}")) llaves++;
					gtk_text_iter_backward_char(&cont);
				}
				if (llaves==0) {
					edit_actualizar();
					while ((gtk_text_iter_get_offset(&cont)!=0) && (gtk_text_iter_get_char(&cont)!=g_utf8_get_char("\n"))) {
						gtk_text_iter_backward_char(&cont);
					}
					if (gtk_text_iter_get_char(&cont)==g_utf8_get_char("\n")) gtk_text_iter_forward_char(&cont);
					tabuladores=0;
					while (gtk_text_iter_get_char(&cont)==g_utf8_get_char("\t")) {
						tabuladores++;
						gtk_text_iter_forward_char(&cont);
					}
					tab1=NULL;
					cadena=NULL;
					gtk_text_buffer_delete(buffer,&borrar1,&borrar2);
					gtk_text_buffer_get_iter_at_mark(buffer,posicion,referencia);
					gtk_text_iter_backward_char(posicion);
					if (tabuladores>0) {
						tab1=g_strnfill(tabuladores,9);
						cadena=g_strdup_printf("%s",tab1);
						gtk_text_buffer_insert(buffer,posicion,cadena,tabuladores);
					}
					g_free(tab1);
					g_free(cadena);
				}
			}
		}
	}
	gtk_text_buffer_delete_mark(buffer,referencia);
	edit_abriendo_llave=FALSE;
	if ((texto[0]=='{') && (longitud==1)) {
		edit_abriendo_llave=TRUE;
	}
	DEBUG_MSG(<-edit_auto_formato);
}

gboolean edit_comprobar_perdida_datos(void)
{
	struct s_lista_archivos *nodo;
	gboolean resultado;
	
	nodo=raiz_lista_archivos;
	resultado=FALSE;
	
	if (nodo!=NULL) {
		do {
			if (gtk_text_buffer_get_modified(GTK_TEXT_BUFFER(nodo->datos))) {
				resultado=TRUE;
			}
			nodo=nodo->siguiente;
		} while (nodo!=NULL);
	}
	return resultado;
}

void edit_mensaje(gchar *mensaje)
{
	GtkLabel *etiqueta;
	
	etiqueta=GTK_LABEL(glade_xml_get_widget(david_ventana,"mensajes_etiqueta"));
	gtk_label_set(etiqueta,mensaje);
}

void edit_ir_a_posicion(guint posicion)
{
/*	gfloat superior;
	gfloat ajuste;
	guint fila;
	guint cont;
	
	fila=1;
	for (cont=0;cont<posicion;cont++) {
		if ((edit_actual->datos)[cont]==10) {
			fila++;
		}
	}
	if (fila>3) {
		fila-=2;
	} else {
		fila=1;
	}
//	superior=edit_editor->vadj->upper;
	ajuste=(((gfloat)fila)/((gfloat)filas))*superior;
//	edit_editor->vadj->value=ajuste;
//	gtk_adjustment_value_changed(edit_editor->vadj); */
}

gboolean edit_repetido(gchar *nombre)
{
	struct s_lista_archivos *nodo;
	gboolean repe;
	
	repe=FALSE;
	nodo=raiz_lista_archivos;
	while (nodo!=NULL) {
		if (!strcmp(nodo->nombre,nombre)) {
			repe=TRUE;
		}
		nodo=nodo->siguiente;
	}
	return repe;
}

void edit_anadir_tabulacion(void)
{
	GtkTextBuffer *buffer;
	gchar *texto,*resultado;
	GtkTextIter posicion;
	gchar **lineas;
	gchar *casi;
	gchar saltotab[3];
	gchar tab[2];
	GtkTextMark *marca;
	
	saltotab[0]='\n';
	saltotab[1]=9;
	saltotab[2]=0;
	tab[0]=9;
	tab[1]=0;
	if (edit_actual!=NULL) {
		buffer=GTK_TEXT_BUFFER(edit_actual->datos);
		texto=edit_tabulacion(&posicion);
		if (texto != NULL) {
			marca=gtk_text_buffer_create_mark(buffer,NULL,&posicion,TRUE);
			lineas=g_strsplit(texto,"\n",0);
			casi=g_strjoinv(saltotab,lineas);
			resultado=g_strdup_printf("%s%s",tab,casi);
			gtk_text_buffer_insert_at_cursor(buffer,resultado,-1);
			gtk_text_buffer_get_iter_at_mark(buffer,&posicion,marca);
			gtk_text_buffer_delete_mark(buffer,marca);
			marca=gtk_text_buffer_get_mark(buffer,"selection_bound");
			gtk_text_buffer_move_mark(buffer,marca,&posicion);
			g_free(texto);
			g_strfreev(lineas);
			g_free(resultado);
			g_free(casi);
		} //fin del if (texto != NULL)
	} 
}

void edit_eliminar_tabulacion(void)
{
	GtkTextBuffer *buffer;
	gchar *texto,*resultado;
	GtkTextIter posicion;
	gchar **lineas;
	guint cont;
	gboolean reemplazar;
	GtkTextMark *marca;
	
	if (edit_actual!=NULL) {
		buffer=GTK_TEXT_BUFFER(edit_actual->datos);
		texto=edit_tabulacion(&posicion);
		if (texto != NULL) {
			lineas=g_strsplit(texto,"\n",0);
	
			reemplazar=TRUE;
			cont=0;
			while (lineas[cont]!=NULL) {
				if (lineas[cont][0]==9) {
					resultado=g_strdup(lineas[cont]+1);
					g_free(lineas[cont]);
					lineas[cont]=resultado;
				} else {
					reemplazar=FALSE;
				}
				cont++;
			}
			marca=gtk_text_buffer_create_mark(buffer,NULL,&posicion,TRUE);
			if (reemplazar) {
				resultado=g_strjoinv("\n",lineas);
				gtk_text_buffer_insert_at_cursor(buffer,resultado,-1);
				g_free(resultado);
			} else {
				gtk_text_buffer_insert_at_cursor(buffer,texto,-1);
			}
			gtk_text_buffer_get_iter_at_mark(buffer,&posicion,marca);
			gtk_text_buffer_delete_mark(buffer,marca);
			marca=gtk_text_buffer_get_mark(buffer,"selection_bound");
			gtk_text_buffer_move_mark(buffer,marca,&posicion);
			g_free(texto);
			g_strfreev(lineas);
		} //fin del if (texto != NULL)
	} //fin del if (edit_actual != NULL)
}

// El GtkTextIter que se pasa como parametro tiene que estar previamente alojado. Una vez que se finalice
// con el uso de la cadena devuelta hay que liberarla.
gchar *edit_tabulacion(GtkTextIter *posicion)
{
	GtkTextBuffer *buffer;
	gchar *seleccion;
	GtkTextIter inicio,fin;
	gint fila;

	DEBUG_MSG(->edit_tabulacion);
	buffer=GTK_TEXT_BUFFER(edit_actual->datos);
	if (gtk_text_buffer_get_selection_bounds(buffer,&inicio,&fin)) {
		fila=gtk_text_iter_get_line(&inicio);
		gtk_text_iter_set_line(&inicio,fila);
		if (gtk_text_iter_get_line_offset(&fin)==0) {
			gtk_text_iter_backward_line(&fin);
			gtk_text_buffer_move_mark_by_name(buffer,"insert",&fin);
		}
		fila=gtk_text_iter_get_line(&fin);
		gtk_text_iter_forward_to_line_end(&fin);
		if (fila!=gtk_text_iter_get_line(&fin)) {
			gtk_text_iter_backward_line(&fin);
			gtk_text_iter_forward_to_line_end(&fin);
		}
		seleccion=gtk_text_iter_get_text(&inicio,&fin);
		gtk_text_buffer_delete(buffer,&inicio,&fin);
		gtk_text_buffer_get_iter_at_mark(buffer,posicion,gtk_text_buffer_get_insert(buffer));
	
		DEBUG_MSG(<-edit_tabulacion);
		return seleccion;
	} else {
		//no habia texto seleccionado, asi que devolvemos null y salimos
		DEBUG_MSG(<-edit_tabulacion NULL);
		return NULL;
	}
}

void edit_ir_a_fila(guint fila,GtkTextIter *posicion)
{
	GtkTextMark *marca;

	DEBUG_MSG(->edit_ir_a_fila);
	gtk_text_buffer_get_iter_at_line(GTK_TEXT_BUFFER(edit_actual->datos),posicion,fila-1);
	DEBUG_MSG(->create_mark_edit_ir_a_fila<-);
	marca=gtk_text_buffer_create_mark(GTK_TEXT_BUFFER(edit_actual->datos),NULL,posicion,TRUE);
	gtk_text_view_scroll_to_mark(GTK_TEXT_VIEW(edit_actual->editor),marca,0,TRUE,0,0.5);
	DEBUG_MSG(->delete_mark_edit_ir_a_fila<-);
	gtk_text_buffer_delete_mark(GTK_TEXT_BUFFER(edit_actual->datos),marca);
	gtk_text_buffer_place_cursor(GTK_TEXT_BUFFER(edit_actual->datos),posicion);
	DEBUG_MSG(<-edit_ir_a_fila);
}

struct s_lista_archivos *edit_conseguir_nodo(gchar *nombre)
{
	struct s_lista_archivos *nodo;
	
	nodo=raiz_lista_archivos;
	while ((nodo!=NULL) && (strcmp(nodo->nombre,nombre))) {
		nodo=nodo->siguiente;
	}
	return nodo;
}

GList *edit_cambiar_reglas_coloreado(void)
{
	GList *list;
	gchar *libs;
	gchar *lenguaje;
	GtkTextTag *tag;

	DEBUG_MSG(->edit_cambiar_reglas_coloreado);
	libs=pro_librerias_lincado();
	lenguaje=pro_lenguaje();

	list=NULL;
	tag = gtk_pattern_tag_new("directivas","^#[ \t]*\\(include\\|if\\|ifdef\\|ifndef\\|else\\|elif\\|define\\|endif\\|pragma\\)\\b");
	g_object_set(G_OBJECT(tag),"foreground-gdk",&c_directiva,NULL);
	if (preferencias.negrita_directiva) {
		g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_BOLD,NULL);
	} else {
		g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_NORMAL,NULL);
	}
	if (preferencias.cursiba_directiva) {
		g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_ITALIC,NULL);
	} else {
		g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_NORMAL,NULL);
	}
	list=g_list_append(list,(gpointer)tag);
	tag = gtk_pattern_tag_new("hexadecimal","\\b\\(0[xX][a-fA-F0-9][a-fA-F0-9]*\\)\\b");
	g_object_set(G_OBJECT(tag),"foreground-gdk",&c_hexadecimal,NULL);
	if (preferencias.negrita_hexadecimal) {
		g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_BOLD,NULL);
	} else {
		g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_NORMAL,NULL);
	}
	if (preferencias.cursiba_hexadecimal) {
		g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_ITALIC,NULL);
	} else {
		g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_NORMAL,NULL);
	}
	list=g_list_append(list,(gpointer)tag);
	tag = gtk_pattern_tag_new("real","\\b\\([0-9][0-9]*\\.[0-9][0-9]*\\)\\b");
	g_object_set(G_OBJECT(tag),"foreground-gdk",&c_real,NULL);
	if (preferencias.negrita_real) {
		g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_BOLD,NULL);
	} else {
		g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_NORMAL,NULL);
	}
	if (preferencias.cursiba_real) {
		g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_ITALIC,NULL);
	} else {
		g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_NORMAL,NULL);
	}
	list=g_list_append(list,(gpointer)tag);
	tag = gtk_pattern_tag_new("octal","\\b\\(0[0-7][0-7]*[1-7][0-7]*\\)\\b");
	g_object_set(G_OBJECT(tag),"foreground-gdk",&c_octal,NULL);
	if (preferencias.negrita_octal) {
		g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_BOLD,NULL);
	} else {
		g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_NORMAL,NULL);
	}
	if (preferencias.cursiba_octal) {
		g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_ITALIC,NULL);
	} else {
		g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_NORMAL,NULL);
	}
	list=g_list_append(list,(gpointer)tag);
	tag = gtk_pattern_tag_new("entero","\\b\\([0-9][0-9]*\\)\\b");
	g_object_set(G_OBJECT(tag),"foreground-gdk",&c_entero,NULL);
	if (preferencias.negrita_entero) {
		g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_BOLD,NULL);
	} else {
		g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_NORMAL,NULL);
	}
	if (preferencias.cursiba_entero) {
		g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_ITALIC,NULL);
	} else {
		g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_NORMAL,NULL);
	}
	list=g_list_append(list,(gpointer)tag);
	if ((libs!=NULL) && (libs[LGLIB2]=='1')) {
		tag = gtk_pattern_tag_new("tipos_glib","\\b\\(gint\\|gchar\\|gpointer\\|guint\\|guchar\\|gboolean\\|glong\\|gshort\\|gulong\\|gushort\\|gfloat\\|gdouble\\|gldouble\\|gint8\\|guint8\\|gint16\\|guint16\\|gint32\\|guint32\\)\\b");
		g_object_set(G_OBJECT(tag),"foreground-gdk",&c_etiqueta,NULL);
		if (preferencias.negrita_etiqueta) {
			g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_BOLD,NULL);
		} else {
			g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_NORMAL,NULL);
		}
		if (preferencias.cursiba_etiqueta) {
			g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_ITALIC,NULL);
		} else {
			g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_NORMAL,NULL);
		}
		list=g_list_append(list,(gpointer)tag);
	}
	tag = gtk_pattern_tag_new("palabras_reservadas","\\b\\(void\\|char\\|short\\|int\\|long\\|float\\|double\\|unsigned\\|signed\\|typedef\\|enum\\|struct\\|const\\|switch\\|case\\|break\\|default\\|if\\|else\\|do\\|while\\|for\\|return\\|sizeof\\|static\\|inline\\|auto\\|continue\\|extern\\|goto\\|register\\|union\\|volatile\\)\\b");
	g_object_set(G_OBJECT(tag),"foreground-gdk",&c_etiqueta,NULL);
	if (preferencias.negrita_etiqueta) {
		g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_BOLD,NULL);
	} else {
		g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_NORMAL,NULL);
	}
	if (preferencias.cursiba_etiqueta) {
		g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_ITALIC,NULL);
	} else {
		g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_NORMAL,NULL);
	}
	list=g_list_append(list,(gpointer)tag);
	if ((lenguaje!=NULL) && (lenguaje[0]=='1')) {
		tag = gtk_pattern_tag_new("palabras_reservadas_cpp","\\b\\(and\\|and_eq\\|asm\\|auto\\|bitand\\|bitor\\|bool\\|catch\\|class\\|compl\\|const_cast\\|continue\\|delete\\|dynamic_cast\\|explicit\\|false\\|friend\\|mutable\\|namespace\\|new\\|not\\|not_eq\\|operator\\|or\\|or_eq\\|pribate\\|protected\\|public\\|reinterpret_cast\\|static_cast\\|template\\|this\\|trow\\|true\\|try\\|typeid\\|typename\\|using\\|virtual\\|wchar_t\\|xor\\|xor_eq\\)\\b");
		g_object_set(G_OBJECT(tag),"foreground-gdk",&c_etiqueta,NULL);
		if (preferencias.negrita_etiqueta) {
			g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_BOLD,NULL);
		} else {
			g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_NORMAL,NULL);
		}
		if (preferencias.cursiba_etiqueta) {
			g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_ITALIC,NULL);
		} else {
			g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_NORMAL,NULL);
		}
		list=g_list_append(list,(gpointer)tag);
	}

	g_free(lenguaje);
	g_free(libs);

	tag = gtk_syntax_tag_new("cadena_cd","\"","\"");
	g_object_set(G_OBJECT(tag),"foreground-gdk",&c_cadena_cd,NULL);
	if (preferencias.negrita_cadena_cd) {
		g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_BOLD,NULL);
	} else {
		g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_NORMAL,NULL);
	}
	if (preferencias.cursiba_cadena_cd) {
		g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_ITALIC,NULL);
	} else {
		g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_NORMAL,NULL);
	}
	list=g_list_append(list,(gpointer)tag);
	tag = gtk_pattern_tag_new("cadena_cs","\\(['][^\\'][']\\)\\|\\(['][\\][\\'0abcfnrtv][']\\)");
	g_object_set(G_OBJECT(tag),"foreground-gdk",&c_cadena_cs,NULL);
	if (preferencias.negrita_cadena_cs) {
		g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_BOLD,NULL);
	} else {
		g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_NORMAL,NULL);
	}
	if (preferencias.cursiba_cadena_cs) {
		g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_ITALIC,NULL);
	} else {
		g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_NORMAL,NULL);
	}
	list=g_list_append(list,(gpointer)tag);
	tag = gtk_syntax_tag_new("cadena_cs2","'\"","'");
	g_object_set(G_OBJECT(tag),"foreground-gdk",&c_cadena_cs,NULL);
	if (preferencias.negrita_cadena_cs) {
		g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_BOLD,NULL);
	} else {
		g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_NORMAL,NULL);
	}
	if (preferencias.cursiba_cadena_cs) {
		g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_ITALIC,NULL);
	} else {
		g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_NORMAL,NULL);
	}
	list=g_list_append(list,(gpointer)tag);
	tag = gtk_syntax_tag_new("comentario","//","\n");
	g_object_set(G_OBJECT(tag),"foreground-gdk",&c_comentario,NULL);
	if (preferencias.negrita_comentario) {
		g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_BOLD,NULL);
	} else {
		g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_NORMAL,NULL);
	}
	if (preferencias.cursiba_comentario) {
		g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_ITALIC,NULL);
	} else {
		g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_NORMAL,NULL);
	}
	list=g_list_append(list,(gpointer)tag); 
	tag = gtk_syntax_tag_new("comentario_multilinea","/\\*","\\*/");
	g_object_set(G_OBJECT(tag),"foreground-gdk",&c_comentario,NULL);
	if (preferencias.negrita_comentario) {
		g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_BOLD,NULL);
	} else {
		g_object_set(G_OBJECT(tag),"weight",PANGO_WEIGHT_NORMAL,NULL);
	}
	if (preferencias.cursiba_comentario) {
		g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_ITALIC,NULL);
	} else {
		g_object_set(G_OBJECT(tag),"style",PANGO_STYLE_NORMAL,NULL);
	}
	list=g_list_append(list,(gpointer)tag);

	DEBUG_MSG(<-edit_cambiar_reglas_coloreado);

	return list;
}

void edit_aplicar_reglas_coloreado(GtkSourceBuffer *buffer)
{
	GList *tabla_syntax;
	DEBUG_MSG(->edit_aplicar_reglas_coloreado);

	tabla_syntax=edit_cambiar_reglas_coloreado();
	gtk_source_buffer_purge_regex_tags(buffer);
	gtk_source_buffer_install_regex_tags(buffer,tabla_syntax);
	gtk_source_buffer_set_highlight(buffer,TRUE);
	g_list_free(tabla_syntax);
	
	DEBUG_MSG(<-edit_aplicar_reglas_coloreado);
}

void edit_recargar_archivo(gchar *nombre)
{
	struct s_lista_archivos *nodo;
	gchar *nombre_completo;
	G_CONST_RETURN char *locale;
	GError *error;
	
	nodo=edit_conseguir_nodo(nombre);
	if (nodo==NULL) {
		return;
	}
	nombre_completo=pro_nombre_completo_archivo(nombre,FALSE, LOCALE);

	//the load function appends the text to the end of the buffer, so we must delete the buffer contents first
	gtk_text_buffer_set_text (GTK_TEXT_BUFFER(nodo->datos),"",-1);
	g_get_charset(&locale);
	gtk_source_buffer_load_with_character_encoding(nodo->datos,nombre_completo,locale,&error);
//	nodo->posicion=0;

	cefv_analizar_archivo(nodo->nombre);
	nodo->analizado=TRUE;
	g_free(nombre_completo);
/*	if (nodo->pestana!=-1) {
		//Ponemos edit_actual a NULL para que no ejecute el codigo de la callback on_editor_texto_changed al ejecutar
		//la funcion edit_colorear
		edit_actual_tmp = edit_actual;
		edit_actual=NULL;
		edit_colorear(nodo);
		edit_actual = edit_actual_tmp;
	} */
}

/************************************************************************************************************************************************
 * Muestra una funcion en la pestaa de funciones                                                                                                             *
 * El parametro actualziar_historico tiene que ser TRUE, excepto si se le llama dentro del callback del historico o del notebook   *
 ************************************************************************************************************************************************/
void edit_ver_funcion(gchar *funcion, gboolean actualizar_historico)
{
	GtkTextIter inicio,fin,tmp;
	gint cont;
	gchar *copia_funcion;
	GtkTextIter temp_iter;
	struct s_lista_cefv *nodo;
	struct s_lista_archivos *archivo;
	gboolean salir;
	GtkNotebook *notebook;
	GtkWidget *historico_funciones;
	GList *nodo_historico;
	gunichar abrir,cerrar,espacio,tabulador,enter,caracter;
	gboolean inicio_encontrado,solo_espacios;

	DEBUG_MSG(->edit_ver_funcion);
	//buscamos la funcion en el arbol cefv
	nodo=lista_cefv;
	salir=FALSE;
	while ((!salir) && (nodo!=NULL)) {
		if (strcasecmp(nodo->rama,funcion)!=0) {
			nodo=nodo->siguiente;
		} else {
			salir=TRUE;
		}
	};
	if (nodo==NULL) return;
	// ya tenemos el nodo del arbol correspondiente a la funcion buscada
	// ahora necesitamos el nodo de la lista de archivos
	archivo=edit_conseguir_nodo(nodo->archivo);
	if (archivo->pestana!=-1) {
		edit_actual=archivo;
		edit_actualizar();
	}
	edit_actual=NULL;
	if (!buscar_cadena_forward(GTK_TEXT_BUFFER(archivo->datos),NULL,NULL,nodo->definicion,&inicio,&fin,0)) return;
	
	abrir=g_utf8_get_char("{");
	cerrar=g_utf8_get_char("}");
	espacio=g_utf8_get_char(" ");
	tabulador=g_utf8_get_char("\t");
	enter=g_utf8_get_char("\n");

	// ya tenemos el comienzo de la funcion.
	// ahora vamos a retroceder por si el retorno de la funcin esta definido en la linea anterios, o por si la funcion
	// tienen algun comentario justo antes de la definicin
	inicio_encontrado=FALSE;
	solo_espacios=FALSE;
	tmp=inicio;
	while (!inicio_encontrado) {
		if (gtk_text_iter_backward_char(&tmp)) {
			caracter=gtk_text_iter_get_char(&tmp);
			if (caracter==enter) {
				if (solo_espacios) {
					inicio_encontrado=TRUE;
				} else {
					inicio=tmp;
					solo_espacios=TRUE;
				}
			} else {
				if ((caracter!=espacio) && (caracter!=tabulador)) {
					solo_espacios=FALSE;
				}
			}
		} else {
			inicio_encontrado=TRUE;
			inicio=tmp;
		}
	}
	caracter=gtk_text_iter_get_char(&inicio);
	if (caracter==enter) {
		gtk_text_iter_forward_char(&inicio);
	}
	
	// Ahora a buscar el final;
	cont=0;
	// buscamos la primera llave
	buscar_cadena_forward(GTK_TEXT_BUFFER(archivo->datos),&fin,NULL,"{",&fin,&temp_iter,0);
	cont++;
	while (cont!=0) {
		gtk_text_iter_forward_chars(&fin,1);
		caracter=gtk_text_iter_get_char(&fin);
		if (caracter==abrir) cont++;
		if (caracter==cerrar) cont--;
	}
	gtk_text_iter_forward_chars(&fin,1);
	
	// ya tenemos el final de la funcion, ahora escribirlo en el widget
	copia_funcion=gtk_text_iter_get_text(&inicio,&fin);
	gtk_text_view_set_editable(GTK_TEXT_VIEW(edit_funciones),TRUE);
	gtk_text_buffer_set_text(GTK_TEXT_BUFFER(edit_funciones_buffer),copia_funcion,-1);
	gtk_text_view_set_editable(GTK_TEXT_VIEW(edit_funciones),FALSE);

	if (actualizar_historico) {
		// actualizamos el historico	
		copia_funcion=g_strdup(funcion);
		edit_historico_funciones=g_list_prepend(edit_historico_funciones,copia_funcion);
		if (g_list_length(edit_historico_funciones)>10) {
			nodo_historico=g_list_last(edit_historico_funciones);
			g_free(nodo_historico->data);
			edit_historico_funciones=g_list_remove_link(edit_historico_funciones,nodo_historico);
			g_list_free_1(nodo_historico);
		}
		edit_congelar_historico=TRUE;
		historico_funciones=glade_xml_get_widget(david_ventana,"historico_funciones_combo");
		gtk_combo_set_popdown_strings(GTK_COMBO(historico_funciones),edit_historico_funciones);
		edit_congelar_historico=FALSE;
		
		notebook=GTK_NOTEBOOK(glade_xml_get_widget(david_ventana,"archivos_notebook"));
		g_signal_handlers_block_by_func(G_OBJECT(notebook),on_archivos_notebook_switch_page,NULL);
		gtk_notebook_set_page(notebook,1);
		g_signal_handlers_unblock_by_func(G_OBJECT(notebook),on_archivos_notebook_switch_page,NULL);
	} //fin del if(actualizar_historico)
	DEBUG_MSG(<-edit_ver_funcion);
}
