import re
import urllib
from dosage.modules.helpers import BasicComicModule as bcm

class Zapiro(bcm.BasicComicModule, bcm.IndirectLatestMixin):
    baseUrl = 'http://www.mg.co.za/zapiro/default.aspx'
    imageUrl = 'http://www.mg.co.za/zapiro/imagePage.aspx?YearId=%s|MonthId=%s|DayId=%s'
    imageSearch = re.compile(r'<img src=(http://www.mg.co.za/ContentImages/2561/\d{2}-...\d{2}x\.gif) border=0 />')
    prevSearch = re.compile(r'href="(/zapiro/imagePage.aspx\?YearId=\d{4}\|MonthId=\d{1,2}\|DayId=\d{1,2})"')
    latestSearch = re.compile(r'<a href="(imagePage.aspx\?YearId=\d{4}\|MonthId=\d{1,2}\|DayId=\d{1,2})">')
    help = 'Index format: yyyy-mm-dd'

    def setStrip(self, index):
        self.currentUrl = self.imageUrl % tuple(map(int, index.split('-')))

    def getFilename(self, imageUrl, pageUrl):
        values = [a.split('=') for a in urllib.splitquery(pageUrl)[-1].split('|')]
        d = dict([(name, int(value)) for name, value in values])
        return 'zapiro-%(YearId)02d%(MonthId)02d%(DayId)02d' % d

