%define name       drivel
%define version    1.2.4
%define release    1
%define prefix     /usr
%define sysconfdir /etc
%define gettext_package drivel

Summary:    A LiveJournal client
Name:       %{name}
Version:    %{version}
Release:    %{release}
Epoch:      1
License:    GPL
Group:      Applications
Vendor:     Dropline Systems
Url:        http://www.dropline.net/drivel
Source:     %{name}-%{version}.tar.bz2
Packager:   Todd Kulesza <todd@dropline.net>
BuildRoot:  /var/tmp/%{name}-%{version}-root
BuildRequires: scrollkeeper >= 0.3.5
Requires:   glib2 >= 2.4.0
Requires:   gtk2 >= 2.4.0
Prefix:     %{prefix}


%description
Drivel is an advanced LiveJournal client for the GNOME desktop.  While 
maintaining a full set of features, it had been designed with usability 
in mind, and presents an elegant user interface.

%prep
%setup -q

%build
%configure --disable-schemas-install --disable-mime-update --disable-desktop-update
make

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -rf $RPM_BUILD_ROOT

# Clean out files that should not be part of the rpm.
# This is the recommended way of dealing with it for RH8
rm -rf $RPM_BUILD_ROOT/var/scrollkeeper/*

%post
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
SCHEMAS="drivel.schemas"
for S in $SCHEMAS; do
  gconftool-2 --makefile-install-rule %{_sysconfdir}/gconf/schemas/$S > /dev/null
done
if (update-mime-database -v &> /dev/null); then
  update-mime-database "%{_datadir}/mime" > /dev/null
fi
if which scrollkeeper-update > /dev/null 2>&1; then 
  scrollkeeper-update -q -o %{_datadir}/omf/drivel
fi
if (update-desktop-database -v &> /dev/null); then
  update-desktop-database > /dev/null
fi

%postun
if (update-mime-database -v &> /dev/null); then
  update-mime-database "%{_datadir}/mime" > /dev/null
fi
if which scrollkeeper-update > /dev/null 2>&1; then
	scrollkeeper-update -q
fi
if (update-desktop-database -v &> /dev/null); then
  update-desktop-database > /dev/null
fi
/bin/true ## for rpmlint, -p requires absolute path and is just dumb

%files
%defattr(-, root, root)
%doc AUTHORS COPYING COPYING-DOCS ChangeLog NEWS README TODO
%{_bindir}/drivel
%{_datadir}/applications/drivel.desktop
%{_datadir}/application-registry/drivel.applications
%{_datadir}/drivel/glade/drivel.glade
%{_datadir}/drivel/languages/livejournal.lang
%{_datadir}/gnome/help/drivel/*
%{_datadir}/icons/gnome/48x48/mimetypes/gnome-mime-application-x-drivel.png
%{_datadir}/locale/*
%{_datadir}/mime/packages/drivel.xml
%{_datadir}/mime-info/drivel.keys
%{_datadir}/mime-info/drivel.mime
%{_datadir}/omf/drivel/drivel-C.omf
%{_datadir}/pixmaps/livejournal.png
%{_datadir}/pixmaps/drivel/*.png
%{_datadir}/pixmaps/drivel/*.xpm
%config %{_sysconfdir}/gconf/schemas/*

%changelog

* Sun Jan 23 2005 Todd Kulesza <todd@dropline.net>
- Don't run ldconfig after install, Drivel doesn't include libraries.
- Use the new --disable-mime-update and --disable-desktop-update parameters.
- Run update-desktop-database after installation.
- Renamed the MIME icon.

* Thu Nov 25 2004 Todd Kulesza <todd@dropline.net>
- Fixed up the scrollkeeper install/uninstall code.

* Sat Aug 28 2004 Todd Kulesza <todd@dropline.net>
- Add a user manual.

* Sat Jul 31 2004 Todd Kulesza <todd@dropline.net>
- Add Shared MIME Database support.
