/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Copyright 2002-2003 Todd Kulesza
 *
 * Authors:
 * 		Todd Kulesza <todd@dropline.net>
 */

#include <gnome.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <string.h>

#include <config.h>

#include "about.h"

void
about_show (DrivelClient *dc)
{
	GdkPixbuf *logo;
	static GtkWidget *dialog = NULL;
	static const gchar *authors[] = 	
	{
		"Todd Kulesza <todd@dropline.net>",
		"Davyd Madeley <davyd@ucc.asn.au>",
		"",
		N_("With help from:"),
		"Grahame Bowland <grahame@angrygoats.net>",
		"Geoff King <0glk@qlink.queensu.ca>",
		"Evan Martin <evan@livejournal.com>",
		"Ari Pollak <compwiz@aripollak.com>",
		"",
		N_("And many others--thank you, all!"),
		NULL
	};
	static const gchar *documentors[] = 
	{
		NULL
	};
	static const gchar *translators = _("translator_credits");
	
	if (dialog)
	{
		gtk_window_present (GTK_WINDOW (dialog));
		return;
	}
	
	logo = gdk_pixbuf_new_from_file (
		DATADIR G_DIR_SEPARATOR_S "pixmaps" G_DIR_SEPARATOR_S "livejournal.png",
		NULL);
	
	dialog = gnome_about_new ("Drivel", VERSION,
				"Copyright \xc2\xa9 2002-2004 Todd Kulesza",
				_("A LiveJournal client for the GNOME desktop."),
				authors,
				documentors,
				strcmp (translators, "translator_credits") 
					!= 0 ? translators : NULL,
				logo);
	gtk_window_set_transient_for (GTK_WINDOW (dialog), GTK_WINDOW (dc->current_window));
	
	g_object_add_weak_pointer (G_OBJECT (dialog), (void **)&dialog);
	
	gtk_widget_show_all (dialog);
	
	return;
}
