
#include <string.h>
#include "csm.h"
#include "err.h"
#include "deftbl.h"
#include "pdl_gen.h"

char *filename, *basefilename, *cfilename, *hfilename, *dbfilename,
     *reqsymfilename;

void uiinit ()
{
    char *dot, save;
    int len;

    extern DefTableKey InputFileName;
    extern DefTableKey BaseFileName;

    /* Get the actual filename and base file name */
    filename = StringTable (GetClpValue (InputFileName, 0));
    if (BaseFileName == NoKey) {
       /* Default to first component of filename */
       dot = strchr (filename, '.');
       save = *dot; /* Note: not necessarily a dot */
       *dot = '\0';       
       if ((basefilename = (char *) malloc (strlen (filename) + 1)) == NULL)
          message (DEADLY, "Can't malloc basefilename", 0, &curpos);
       strcpy (basefilename, filename);
       *dot = save;
    } else    
       basefilename = StringTable (GetClpValue (BaseFileName, 0));

    /* Make the output filenames */
    len = strlen (basefilename);
    if ((cfilename = (char *) malloc (len + 9)) == NULL)
        message (DEADLY, "Can't malloc cfilename", 0, &curpos);
    sprintf (cfilename, "%s_dapto.c", basefilename);
    if ((hfilename = (char *) malloc (len + 9)) == NULL)
        message (DEADLY, "Can't malloc hfilename", 0, &curpos);
    sprintf (hfilename, "%s_dapto.h", basefilename);
    if ((dbfilename = (char *) malloc (len + 10)) == NULL)
        message (DEADLY, "Can't malloc dbfilename", 0, &curpos);
    sprintf (dbfilename, "%s_dapto.db", basefilename);
    if ((reqsymfilename = (char *) malloc (len + 14)) == NULL)
        message (DEADLY, "Can't malloc reqsymfilename", 0, &curpos);
    sprintf (reqsymfilename, "%s_dapto.reqsym", basefilename);
}
