#include <stdio.h>
#include <stdlib.h>

#include "ptg_gen.h"
#include "obstack.h"

/* -------------------------------------------------------- */
/*                      Memory Management                   */
/* -------------------------------------------------------- */

static Obstack _PTGObstack;
static void *_PTGFirstObj = NULL;

static void _PTGInit()
{
	if (_PTGFirstObj)
		return;
	obstack_init(&_PTGObstack);
	_PTGFirstObj = obstack_alloc(&_PTGObstack, 0);
}

void PTGFree()
{
	obstack_free(&_PTGObstack, _PTGFirstObj);
	_PTGFirstObj = obstack_alloc(&_PTGObstack, 0);
}


#if defined(__STDC__) || defined(__cplusplus)
static void *MALLOC(int size)
#else
static void *MALLOC(size) int size;
#endif
{
	if (! _PTGFirstObj)
		_PTGInit();
	return (obstack_alloc(&_PTGObstack, size));
}

/* -------------------------------------------------------- */
/*                       Output-functions                   */
/* -------------------------------------------------------- */

static PTG_OUTPUT_FILE f;
static char buffer[40];

#if PTG_OUTPUT_DEFAULT
#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOut (PTGNode r)
#else
PTGNode PTGOut (r)
	PTGNode r;
#endif
{
	f = stdout;
	if (r) {
		(* (r->_print)) (r);
	}
	return (r);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOutFile (char *fn, PTGNode r)
#else
PTGNode PTGOutFile (fn, r)
	char * fn; PTGNode r;
#endif
{
	if ((f = fopen(fn, "w"))  == (FILE *)NULL)
	{
		fprintf(stderr, "ERROR: PTGOutFile: output file '%s' can't be opened.\n",fn);
		exit(1);
	}
	if (r)
		(* (r->_print)) (r);
	fclose(f);
	return (r);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOutFPtr(FILE *fptr, PTGNode r)
#else
PTGNode PTGOutFPtr(fptr, r)
	FILE *fptr; PTGNode r;
#endif
{
	if ((f = fptr) == (FILE *)NULL)
	{
		fprintf(stderr, "ERROR: PTGOutFPtr: output file not open.\n");
		exit(1);
	}
	if (r)
		(* (r->_print)) (r);
	return (r);
}

#endif

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGProcess(PTG_OUTPUT_FILE file, PTGNode r)
#else
PTGNode PTGProcess(file, r)
	PTG_OUTPUT_FILE file; PTGNode r;
#endif
{
	f = file;
	if (r)
		(* (r->_print)) (r);
	return (r);
}
/* -------------------------------------------------------- */
/*                            PTGNULL                       */
/* -------------------------------------------------------- */

/* Define PTGNULL as a PTGNode that prints nothing. */

#if defined(__STDC__) || defined(__cplusplus)
static void _PrPTGNULL(_PPTG0 n)
#else
static void _PrPTGNULL(n)
_PPTG0 n;
#endif
{(void)n; /* function printing nothing */}

struct _SPTG0   _PTGNULL = { (_PTGProc) _PrPTGNULL };

/* -------------------------------------------------------- */
/*          Node-Construction and Print-functions           */
/* -------------------------------------------------------- */


/* Implementation of Pattern Str */

typedef struct _SPTGStr{
	_PTGProc _print;
	char * p1;
} * _PPTGStr;

#ifdef PROTO_OK
static void _PrPTGStr(_PPTGStr n)
#else
static void _PrPTGStr(n)
	_PPTGStr n;
#endif
{
	PTG_OUTPUT_STRING(f, n->p1);
}

#ifdef PROTO_OK
PTGNode PTGStr(char * p1)
#else
PTGNode PTGStr(p1)
char * p1;
#endif
{
	_PPTGStr n;

	n = (_PPTGStr)MALLOC(sizeof(struct _SPTGStr));
	n->_print = (_PTGProc)_PrPTGStr;
	n->p1 = p1;
	return (PTGNode)n;
}

/* Implementation of Pattern Symbol */

typedef struct _SPTGSymbol{
	_PTGProc _print;
	PTGNode p1;
} * _PPTGSymbol;

#ifdef PROTO_OK
static void _PrPTGSymbol(_PPTGSymbol n)
#else
static void _PrPTGSymbol(n)
	_PPTGSymbol n;
#endif
{
	n->p1->_print(n->p1);
	PTG_OUTPUT_STRING(f, " .");
}

#ifdef PROTO_OK
PTGNode PTGSymbol(PTGNode p1)
#else
PTGNode PTGSymbol(p1)
PTGNode p1;
#endif
{
	_PPTGSymbol n;

	n = (_PPTGSymbol)MALLOC(sizeof(struct _SPTGSymbol));
	n->_print = (_PTGProc)_PrPTGSymbol;
	n->p1 = p1;
	return (PTGNode)n;
}

/* Implementation of Pattern SpcSeq */

typedef struct _SPTGSpcSeq{
	_PTGProc _print;
	PTGNode p1;
	PTGNode p2;
} * _PPTGSpcSeq;

#ifdef PROTO_OK
static void _PrPTGSpcSeq(_PPTGSpcSeq n)
#else
static void _PrPTGSpcSeq(n)
	_PPTGSpcSeq n;
#endif
{
	n->p1->_print(n->p1);
	PTG_OUTPUT_STRING(f, " ");
	n->p2->_print(n->p2);
}

#ifdef PROTO_OK
PTGNode PTGSpcSeq(PTGNode p1, PTGNode p2)
#else
PTGNode PTGSpcSeq(p1, p2)
PTGNode p1;
PTGNode p2;
#endif
{
	_PPTGSpcSeq n;

	n = (_PPTGSpcSeq)MALLOC(sizeof(struct _SPTGSpcSeq));
	n->_print = (_PTGProc)_PrPTGSpcSeq;
	n->p1 = p1;
	n->p2 = p2;
	return (PTGNode)n;
}

/* Implementation of Pattern Seq */

typedef struct _SPTGSeq{
	_PTGProc _print;
	PTGNode p1;
	PTGNode p2;
} * _PPTGSeq;

#ifdef PROTO_OK
static void _PrPTGSeq(_PPTGSeq n)
#else
static void _PrPTGSeq(n)
	_PPTGSeq n;
#endif
{
	n->p1->_print(n->p1);
	n->p2->_print(n->p2);
}

#ifdef PROTO_OK
PTGNode PTGSeq(PTGNode p1, PTGNode p2)
#else
PTGNode PTGSeq(p1, p2)
PTGNode p1;
PTGNode p2;
#endif
{
	_PPTGSeq n;

	n = (_PPTGSeq)MALLOC(sizeof(struct _SPTGSeq));
	if(p1 == PTGNULL && p2 == PTGNULL)
		return PTGNULL;

	n->_print = (_PTGProc)_PrPTGSeq;
	n->p1 = p1;
	n->p2 = p2;
	return (PTGNode)n;
}

/* Implementation of Pattern Line */

typedef struct _SPTGLine{
	_PTGProc _print;
	PTGNode p1;
} * _PPTGLine;

#ifdef PROTO_OK
static void _PrPTGLine(_PPTGLine n)
#else
static void _PrPTGLine(n)
	_PPTGLine n;
#endif
{
	n->p1->_print(n->p1);
	PTG_OUTPUT_STRING(f, "\n");
}

#ifdef PROTO_OK
PTGNode PTGLine(PTGNode p1)
#else
PTGNode PTGLine(p1)
PTGNode p1;
#endif
{
	_PPTGLine n;

	n = (_PPTGLine)MALLOC(sizeof(struct _SPTGLine));
	n->_print = (_PTGProc)_PrPTGLine;
	n->p1 = p1;
	return (PTGNode)n;
}

/* Implementation of Pattern Output */

typedef struct _SPTGOutput{
	_PTGProc _print;
	PTGNode p1;
	PTGNode p2;
	PTGNode p3;
} * _PPTGOutput;

#ifdef PROTO_OK
static void _PrPTGOutput(_PPTGOutput n)
#else
static void _PrPTGOutput(n)
	_PPTGOutput n;
#endif
{
	PTG_OUTPUT_STRING(f, "$SEPA\n");
	n->p1->_print(n->p1);
	PTG_OUTPUT_STRING(f, "$BRACKET\n");
	n->p2->_print(n->p2);
	PTG_OUTPUT_STRING(f, "$SKIP\n");
	n->p3->_print(n->p3);
}

#ifdef PROTO_OK
PTGNode PTGOutput(PTGNode p1, PTGNode p2, PTGNode p3)
#else
PTGNode PTGOutput(p1, p2, p3)
PTGNode p1;
PTGNode p2;
PTGNode p3;
#endif
{
	_PPTGOutput n;

	n = (_PPTGOutput)MALLOC(sizeof(struct _SPTGOutput));
	n->_print = (_PTGProc)_PrPTGOutput;
	n->p1 = p1;
	n->p2 = p2;
	n->p3 = p3;
	return (PTGNode)n;
}


/* -------------------------------------------------------- */
/*                  Default Output Functions                */
/* -------------------------------------------------------- */


#ifdef PROTO_OK
void _PTGPrintInt(PTG_OUTPUT_FILE file, int param)
#else
void _PTGPrintInt(file, param)
	PTG_OUTPUT_FILE file; int param;
#endif
{    /* used for short and int */
	sprintf(buffer,"%d",param);
	PTG_OUTPUT_STRING(file,buffer);
}

#ifdef PROTO_OK
void _PTGPrintLong(PTG_OUTPUT_FILE file, long param)
#else
void _PTGPrintLong(file, param)
	PTG_OUTPUT_FILE file; long param;
#endif
{
	sprintf(buffer,"%ld",param);
	PTG_OUTPUT_STRING(file,buffer);
}

#ifdef PROTO_OK
void _PTGPrintDouble(PTG_OUTPUT_FILE file, double param)
#else
void _PTGPrintDouble(file, param)
	PTG_OUTPUT_FILE file; double param;
#endif
{    /* used for float and double */
	sprintf(buffer,"%g",param);
	PTG_OUTPUT_STRING(file,buffer);
}

#ifdef PROTO_OK
void _PTGPrintChar(PTG_OUTPUT_FILE file, char param)
#else
void _PTGPrintChar(file, param)
	PTG_OUTPUT_FILE file; char param;
#endif
{
	buffer[0] = param;
	buffer[1] = 0;
	PTG_OUTPUT_STRING(file,buffer);
}

