/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libbsd.so
 *
 *   File: segments.h
 */

#ifndef _BSD_SEGMENTS_H_
#define _BSD_SEGMENTS_H_


int             bsd_can_set_volume( DISKSEG *seg, boolean flag );

int             bsd_can_delete( DISKSEG *seg );

int             bsd_discover( list_anchor_t input_objects, list_anchor_t output_objects, boolean final_call);

int             bsd_can_unassign( LOGICALDISK *ld );

int             bsd_unassign( LOGICALDISK *ld );

int             bsd_destroy( DISKSEG * seg, list_anchor_t child_objects );
int				bsd_discard(list_anchor_t objects);

int             bsd_add_sectors_to_kill_list( DISKSEG       *seg,
                                              lsn_t          lsn,
                                              sector_count_t count);

int             bsd_commit_changes( DISKSEG *seg, uint commit_phase );

int             bsd_backup_metadata( DISKSEG *seg );

int             bsd_read( DISKSEG *seg, lsn_t lsn, sector_count_t count, void *buffer );

int             bsd_write( DISKSEG *seg, lsn_t lsn, sector_count_t count, void *buffer );

int             bsd_get_info( DISKSEG *seg, char * name, extended_info_array_t  ** info_array );

void            delete_all_bsd_segment_private_data(void);

#endif

