/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *
 *   Module: libgpt.so
 *
 *   File: checks.h
 *
 */

#ifndef GPT_CHECKS_HEADER
#define GPT_CHECKS_HEADER



static inline boolean isa_unused_gpt_partition_record( gpt_partition *p)
{
        int          i;
        u_int32_t   *uip = (u_int32_t *) p;

        for (i=0; i<(sizeof(guid_t)/4); i++) {
                if (*uip!=0x00) return FALSE;
        }

        return TRUE;
}

static inline boolean matching_guids( guid_t *g1, guid_t *g2)
{
        if ( (DISK_TO_CPU32(g1->time_low)  == g2->time_low) &&
             (DISK_TO_CPU16(g1->time_mid)  == g2->time_mid) &&
             (DISK_TO_CPU16(g1->time_high) == g2->time_high) &&
             (g1->clock_seq_high           == g2->clock_seq_high) &&
             (g1->clock_seq_low            == g2->clock_seq_low) ) {

                return TRUE;

        }

        return FALSE;
}

static inline boolean isa_basic_data_gpt_partition_record( gpt_partition *p)
{
        return( matching_guids( &p->type, &BASIC_DATA_PARTITION) );
}
static inline boolean isa_legacy_mbr_gpt_partition_record( gpt_partition *p)
{
        return( matching_guids( &p->type, &LEGACY_MBR_PARTITION) );
}
static inline boolean isa_esp_gpt_partition_record( gpt_partition *p)
{
        return( matching_guids( &p->type, &EFI_SYSTEM_PARTITION) );
}
static inline boolean isa_gpt_swap_partition_record( gpt_partition *p)
{
        return( matching_guids( &p->type, &GPT_SWAP_PARTITION) );
}
static inline boolean isa_gpt_ms_reserved_partition_record( gpt_partition *p)
{
        return( matching_guids( &p->type, &MS_RESERVED_PARTITION) );
}
static inline boolean isa_gpt_ms_ldm_data_partition_record( gpt_partition *p)
{
        return( matching_guids( &p->type, &MS_LDM_DATA_PARTITION) );
}
static inline boolean isa_gpt_ms_ldm_metadata_partition_record( gpt_partition *p)
{
        return( matching_guids( &p->type, &MS_LDM_METADATA_PARTITION) );
}



static inline boolean isa_null_partition_record( msdos_partition *p)
{

        if ( NR_SECTS(p) == 0 )
                return TRUE;
        else
                return FALSE;

}

static inline boolean isa_ebr_partition_record( msdos_partition *p)
{
        if ( (SYS_IND(p) == DOS_EXTENDED_PARTITION) ||
             (SYS_IND(p) == WIN98_EXTENDED_PARTITION) ||
             (SYS_IND(p) == LINUX_EXTENDED_PARTITION) ) {
                return TRUE;
        }

        return FALSE;
}

static inline boolean isa_linux_swap_partition_record( msdos_partition *p )
{
        if ( SYS_IND(p) == LINUX_SWAP_PARTITION ) {  // actually Solaris uses the same IND
                return TRUE;
        }
        else {
                return FALSE;
        }
}

static inline boolean isa_msdos_data_partition_record( msdos_partition *p )
{

        if ( (isa_null_partition_record(p) == FALSE) &&
             (isa_ebr_partition_record(p)  == FALSE)) {
                return TRUE;
        }

        return FALSE;
}

// Test if disk has a GUID Partition Table by testing for a protective MBR.
// A protective MBR has a single partition record of type 0xEE.
static inline boolean has_guid_partition_table( master_boot_record *mbr )
{
        int      i;
        int      pcount=0;
        boolean  found_gpt_partition=FALSE;

        for (i=0; i<4; i++) {

                // test size field to see if partition record is valid
                if ( DISK_TO_CPU32(NR_SECTS(((msdos_partition *)&mbr->partition_table[i]))) != 0 ) {

                        // test type field to see if it is a GPT record
                        if ( SYS_IND(((msdos_partition *)&mbr->partition_table[i]) )==GPT_PARTITION) {
                                found_gpt_partition = TRUE;
                        }

                        // inc partition counter
                        ++pcount;
                }
        }

        // if 1 and only 1 partition record and its a GPT record then this disk
        // has a protective MBR and is using a GUID Partition Table.
        if (pcount==1 && found_gpt_partition==TRUE) {
                return TRUE;
        }
        else {
                return FALSE;
        }

}

// Signature is found on AIX IPL Records which are always the 1st sector
// of an AIX physical volume.
#define AIX_IPL_REC_ID  0xc9c2d4c1  // Value is EBCIDIC 'IBMA'

static inline boolean has_msdos_signature( master_boot_record *mbr )
{

        if ( ( (*( (unsigned int *) mbr )) != AIX_IPL_REC_ID ) &&
             ( DISK_TO_CPU16(mbr->signature) == MSDOS_DISKMAGIC )) {
                return TRUE;
        }
        else {
                return FALSE;
        }

}

#endif
