/***************************************************************************
                          FLTableDB.cpp  -  description
                             -------------------
    begin                : Sun Jul 1 2001
    copyright            : (C) 2001,2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "FLTableDB.h"
#include "../../flbase/FLDataTable.h"
#include "../../flbase/FLSqlCursor.h"
#include "../../flbase/FLTableMetaData.h"
#include "../../flbase/FLFieldMetaData.h"
#include "../../flbase/FLFormSearchDB.h"
#include "../../flbase/FLManager.h"

FLTableDB::FLTableDB (QWidget * parent, const char *name):
FLWidgetTableDB (parent, name),
tableName_ (QString::null),
foreignField_ (QString::null),
fieldRelation_ (QString::null),
cursor_ (0),
cursorAux (0),
topWidget (0),
showed (false),
filter (QString::null),
readonly_ (false),
sortField_(0)
{
  QObject *obj = this;

  do
	{
	  obj = obj->parent ();
	  if (!obj)
		break;
	}
  while (!((QWidget *) obj)->inherits ("FLFormDB"));

  topWidget = (QWidget *) obj;

  if (!topWidget)
	{
	  qWarning (tr ("FLTableDB : Uno de los padres o antecesores de FLTableDB deber ser de la clase FLFormDB o heredar de ella"));
     return;
	}
  else
	{
	  cursor_ = ((FLFormDB *) topWidget)->cursor ();
	  setFont (qApp->font ());
	}

  if (!name)
	setName ("FLTableDB");

  if (cursor_)
	{
	  if (voidTable)
		delete voidTable;

	  tableRecords = new FLDataTable (this, "tableRecords");
	  tableRecords->setFocusPolicy (QTable::StrongFocus);
	  setFocusProxy (tableRecords);
	  FLWidgetTableDBLayout->addWidget (tableRecords);
         setTabOrder (tableRecords, lineEditSearch);
         setTabOrder (lineEditSearch, comboBoxFieldToSearch);
	}

    connect (tableRecords->horizontalHeader(), SIGNAL(sizeChange(int,int,int)),SLOT(sizeChanged(int,int,int)));
    connect (topWidget, SIGNAL (closed()), SLOT (disconnectSignalSlots()));
}

FLTableDB::~FLTableDB ()
{
  if (cursor_)
	{
            QSettings config;
            QString keybase("/facturalux/" VERSION "/");
            if (!columnsWidths.isEmpty())
                columnsWidths.clear();
            for (int i = 0; i < tableRecords->numCols (); i++)
                columnsWidths << QString::number ( tableRecords->columnWidth( i ) );

            config.writeEntry( keybase + tableName_ +"CW", columnsWidths, ',' );

	     if (cursorAux)
		    delete cursor_;
    }
}

void
FLTableDB::putFirstCol (int c)
{
  if (!tableRecords || !lineEditSearch || !comboBoxFieldToSearch || !cursor_)
	return;

  QHeader *horizHeader = tableRecords->horizontalHeader ();

  FLTableMetaData *tMD = cursor_->metadata ();

  if (!tMD)
	return;

  tableRecords->setColumn (0, tMD->fieldAliasToName (horizHeader->label (c)), tMD->fieldAliasToName (horizHeader->label (c)));

  tableRecords->setColumn (c, tMD->fieldAliasToName (horizHeader->label (0)), tMD->fieldAliasToName (horizHeader->label (0)));

  QString l = comboBoxFieldToSearch->text (0);

  comboBoxFieldToSearch->changeItem (comboBoxFieldToSearch->text (c), 0);
  comboBoxFieldToSearch->changeItem (l, c);
  comboBoxFieldToSearch->setCurrentItem (0);

  lineEditSearch->setText ("");

  refresh ();
}

void
FLTableDB::refresh ()
{ 
  if (!tableRecords || !lineEditSearch || !comboBoxFieldToSearch || !cursor_)
	return;

  FLTableMetaData *tMD = cursor_->metadata ();

  if (!tMD)
	return;

  if (tableName_.isEmpty ())
       tableName_ = cursor_->metadata()->name();

  int pos = cursor_->at ();

  QString filterOrig = cursor_->filter ();

  if (filter.isEmpty ())
	tableRecords->setFilter (filterOrig);
  else
	{
	  if (filterOrig.isEmpty ())
		tableRecords->setFilter (filter);
         else
	        tableRecords->setFilter (filterOrig + " AND " + filter);
	}

  if (!columnsWidths.isEmpty())
    {
        int i=0;
        for (QStringList::Iterator it = columnsWidths.begin (); it != columnsWidths.end (); ++it, i++)
            tableRecords->setColumnWidth( i , ( *it ).toInt() );
    }

  tableRecords->refresh (QDataTable::RefreshAll);

  QHeader *horizHeader = tableRecords->horizontalHeader ();
    
  QStringList s = QStringList () << horizHeader->label (0);
  tableRecords->setSort (s);
    
  FLFieldMetaData * field;
  horizHeader->hide();
  for (int i = 0; i < tableRecords->numCols (); i++)
	{
           field = tMD->field(horizHeader->label (i));
           if (!field)
                continue;
           if (i==0)
            sortField_ = field;
	    if (!field->visible())
            {
                horizHeader->removeLabel(i);
                tableRecords->removeColumn(i);
                continue;
            }
          if (comboBoxFieldToSearch->count()==i)
            comboBoxFieldToSearch->insertItem (field->alias());
	   horizHeader->setLabel (i, field->alias());
	}
  horizHeader->show();    
  tableRecords->refresh ();
  
  if (pos < 0)
    {
	 pos = 0;
        tableRecords->setCurrentCell(0,0);
     }
  if (pos > tableRecords->numRows ())
	pos = tableRecords->numRows () - 1;
  cursor_->setFilter (filterOrig);
  cursor_->seek (pos);
  if (cursor_->size()==1)
    tableRecords->setCurrentCell(0,0);
}

void
FLTableDB::filterRecords (const QString & p)
{
  if (!tableRecords || !lineEditSearch || !comboBoxFieldToSearch || !sortField_ || !cursor_)
	return;

  filter = "upper(" + sortField_->name() + ") LIKE " + FLManager::formatValueLike (sortField_, QVariant (p.upper ()));
  refresh ();
}

QCString
FLTableDB::tableName () const
{
  return (const char *)tableName_;
}

QCString
FLTableDB::foreignField () const
{
  return (const char *)foreignField_;
}

QCString
FLTableDB::fieldRelation () const
{
  return (const char *)fieldRelation_;
}

void
FLTableDB::setTableName (const QCString & fT)
{
  tableName_ = fT;
}

void
FLTableDB::setForeignField (const QCString & fN)
{
  foreignField_ = fN;
  initCursor ();
}

void
FLTableDB::setFieldRelation (const QCString & fN)
{
  fieldRelation_ = fN;
  initCursor ();
}

void
FLTableDB::deleteRecord ()
{
  if (!cursor_ || readonly_)
	return;
  cursor_->deleteRecord ();
}

void
FLTableDB::browseRecord ()
{
  if (!cursor_)
	return;

  cursor_->browseRecord ();
}

void
FLTableDB::editRecord ()
{
  if (!cursor_ || readonly_)
	return;

  cursor_->editRecord ();
}

void
FLTableDB::insertRecord ()
{
  if (!cursor_ || readonly_)
	return;

 cursor_->insertRecord ();
}

void
FLTableDB::initCursor ()
{
  if (!topWidget || !cursor_)
	return;

  if (tableName ().isEmpty () || foreignField ().isEmpty () || fieldRelation ().isEmpty () || cursorAux)
	return;

  FLTableMetaData *tMD = FLManager::metadata (tableName ());

  if (!tMD)
	return;

  disconnectSignalSlots();
  cursorAux = cursor_;
  cursor_ = new FLSqlCursor (tableName (), true, 0, cursorAux, tMD->relation (fieldRelation (), foreignField ()));
  if (!cursor_)
	{
	  cursor_ = cursorAux;
	  cursorAux = 0;
	}

  tableRecords->setFLSqlCursor (cursor_);

  if (cursorAux && topWidget->isA ("FLFormSearchDB"))
	{
	  topWidget->setCaption (cursor_->metadata ()->alias ());
	  ((FLFormSearchDB *) topWidget)->setCursor (cursor_);
	}

  connect (cursor_, SIGNAL (cursorUpdated ()), this, SLOT (refresh ()));
  connect (tableRecords, SIGNAL (recordChoosed ()), cursor_, SLOT (chooseRecord ()));
}

void
FLTableDB::show ()
{
  if (!cursor_)
    {
        QWidget::show ();
        return;
    }

  if (!cursorAux && !showed)
	{
	  tableRecords->setFLSqlCursor (cursor_);
	  connect (cursor_, SIGNAL (cursorUpdated ()), this, SLOT (refresh ()));
	  connect (tableRecords, SIGNAL (recordChoosed ()), cursor_, SLOT (chooseRecord ()));
         tableRecords->setFocus();
	  cursor_->refresh ();
	  showed = true;
	}

  if (cursorAux)
	{
	  if (topWidget->isA ("FLFormRecordDB") && cursorAux->modeAccess () == FLSqlCursor::BROWSE)
		{
		  cursor_->setEdition (false);
		  readonly_ = true;
          tableRecords->setReadOnly();
		}
         if (topWidget->isA ("FLFormSearchDB"))
            tableRecords->setFocus();
	  cursor_->refresh ();
	}
  else
	if (topWidget->isA ("FLFormRecordDB") && cursor_->modeAccess () == FLSqlCursor::BROWSE)
	  {
		cursor_->setEdition (false);
		readonly_ = true;
              tableRecords->setReadOnly();
	  }

  QWidget::show ();
  QSettings config;
  QString keybase("/facturalux/" VERSION "/");

  columnsWidths=config.readListEntry( keybase + tableName_ +"CW", ',' );
  if (!columnsWidths.isEmpty())
    {
        int i=0;
        for (QStringList::Iterator it = columnsWidths.begin (); it != columnsWidths.end (); ++it, i++)
                if (i < tableRecords->numCols() )
                        tableRecords->setColumnWidth( i , ( *it ).toInt() );
    }
  refresh();
  tableRecords->setCurrentCell(0,0);
}

void
FLTableDB::sizeChanged(int i, int , int newSize)
{
   (*columnsWidths.at(i))=QString::number(newSize);
}

void
FLTableDB::disconnectSignalSlots()
{   
    disconnect (cursor_, SIGNAL (cursorUpdated ()), this, SLOT (refresh ()));
    disconnect (tableRecords, 0, 0, 0);
}
