/*
   fbgetty : a getty for framebuffer 
   Copyright (C) 2001 Yann Droneaud <ydroneaud@meuh.eu.org>. 

   fbgetty is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   fbgetty is distributed in the hope that it will be useful, but 
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

 */

/*
 * Here is code for default signal handling
 */

#include <fbgetty/global.h>

#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <syslog.h>

#include <string.h>
#include <errno.h>


#include <fbgetty/options.h>
#include <fbgetty/errors.h>


static RETSIGTYPE 
leave (int sig)
{
  /* close file, free memory, restore signal */
  fgexit (EXIT_FAILURE);
}

int install_signal(void)
{
  struct sigaction sa_signal;

#ifdef FB_GETTY_DEBUG
  error("installing signal handlers");
#endif

  sa_signal.sa_handler = leave;
  sigemptyset(&sa_signal.sa_mask);
  sa_signal.sa_flags = 0;

  if (sigaction(SIGINT, &sa_signal, NULL) == -1)
    error("Can't set handler for SIGINT: %m");

  if (sigaction(SIGQUIT, &sa_signal, NULL) == -1)
    error("Can't set handler for SIGQUIT: %m");

  if (sigaction(SIGHUP, &sa_signal, NULL) == -1)
    error("Can't set handler for SIGHUP: %m");

  if (sigaction(SIGTERM, &sa_signal, NULL) == -1)
    error("Can't set handler for SIGTERM: %m");

  return(0);
}


int do_vhangup(void)
{
  struct sigaction sa_signal, sa_old;

  sa_signal.sa_handler = SIG_IGN;
  sigemptyset(&sa_signal.sa_mask);
  sa_signal.sa_flags = 0;

  if (sigaction(SIGHUP, &sa_signal, &sa_old) == -1)
    error("Can't set handler for SIGHUP: %m");

  if (vhangup() == -1)
    error("vhangup() failed: %s", strerror(errno));

  if (sigaction(SIGHUP, &sa_old, NULL) == -1)
    error("Can't restore handler for SIGHUP: %m");
  
  return(0);
}
