from ConfigWidget import ConfigWidget

import gtk

class ConfigString(ConfigWidget):

    def __init__(self, attrs, getter, setter):

        ConfigWidget.__init__(self, attrs, getter, setter)
        is_passwd = attrs.get("password", "")
        label = attrs.get("label", "")

        lbl = gtk.Label(label)
        lbl.show()
        entry = gtk.Entry()
        entry.set_width_chars(15)
        entry.show()
        align = gtk.Alignment(0.0, 0.0, 0.0, 0.0)
        align.show()
        align.add(lbl)

        if (is_passwd.lower() == "true"):
            entry.set_visibility(False)
            entry.set_invisible_char(unichr(0x2022))

        #self.__tooltips.set_tip(entry, help)

        value = self._get_config()
	if (not value): entry.set_text("")
        else: entry.set_text(value)
        entry.connect("focus-out-event", self.__on_change)

        self.__widgets = (align, entry)


    def get_widgets(self): return self.__widgets


    def __on_change(self, src, event):

        value = src.get_text()
        value = value.replace("\"", "\\\"")
        self._set_config("\"" + value + "\"")
