/*
Copyright (C) 2003 by Sean David Fleming

sean@power.curtin.edu.au

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

The GNU GPL can also be found at http://www.gnu.org
*/

/* spacing */
#define PANEL_SPACING 4
/* sub windows */
#define W_BORDER 5
#define H_BORDER 5
/* graphics window defs */
#define START_WIDTH 640
#define START_HEIGHT 600
#define MIN_WIDTH 200
#define MIN_HEIGHT 200
/* use GTKGL_ as GL_ are often reserved by OpenGL */
#define GTKGL_DIM 600
#define GTKGL_LINE_WIDTH 1.5
/* angle drawing */
#define MIN_ARC_RAD 15

#define PIX2SCALE 0.005

/* main operation modes */
enum 
{
FREE, XLAT, ROLL, YAW, PITCH, QUIT,
SELECT_FRAGMENT,
CREATE_RIBBON,
ATOM_ADD, ATOM_MOVE, ATOM_DELETE, ATOM_CHANGE_TYPE,
BOND_NORMAL, BOND_SPLIT, BOND_MERGED,
BOND_DELETE, BOND_SINGLE, BOND_DOUBLE, BOND_TRIPLE, BOND_HBOND, BOND_ZEOLITE,
MOL_MOVE, MOL_DELETE, DELETE_VECTOR, DELETE_PLANE,
BOND_INFO, DIST_INFO, ANGLE_INFO, DIHEDRAL_INFO,
DEFINE_RIBBON, DEFINE_VECTOR, DEFINE_PLANE,
ANIMATING, RECORD
};

/* widget & file/package types */
/* including dialog request types */
enum 
{
GDIS, SGINFO, SYMMETRY, CDD, GPERIODIC, ELEM_EDIT, POVRAY, GENSURF,
ABOUT, ANIM, SURF, DISPLAY, GEOMETRY, SPATIAL, TASKMAN, 
FILE_SELECT, FILE_LOAD, FILE_SAVE, FILE_SAVE_AS,
NODATA, DATA, BABEL, BIOSYM, CIF, FDF, GULP, MARVIN, MORPH, XML, XTL, XYZ,
AUTO, NONBABEL, CSSR, FDAT, GAMOUT, MOPAC_OUT, PDB,
MDI, CREATOR, MVNOUT, GULPOUT, GULP_TRJ, SIESTA_OUT,
OPENGL, OPENGL_OPTIONS, GAMESS, GAMESS_OUT, DIFFAX, DIFFAX_INP,
ABINIT, ABINIT_OUT, NWCHEM, NWCHEM_OUT, CASTEP, CASTEP_OUT, GAUSS, GAUSS_OUT,
HIRSHFELD, CONNECT, ENERGETICS, RDF, LIQUIDS, VACF, MD_ANALYSIS,
PICTURE, RIETICA,
LAST
};

/* model display features */
enum 
{
PLANE_LABELS, ASYM_TOGGLE,
ATOM_LABELS, FRAME, MESH, SHELLS, AXES_TYPE, 
PBC_CONFINE_NONE, PBC_CONFINE_ATOMS, PBC_CONFINE_MOLS, UNFRAGMENT_MOLS
};

/* switch_view() call modes */
enum {CANVAS_INIT, CANVAS_SINGLE, CANVAS_VSPLIT, CANVAS_HSPLIT, CANVAS_HVSPLIT,
      PREV_MODEL, NEXT_MODEL};

/* view actions */
enum {ROTATION, UPDATE_X, UPDATE_Y, UPDATE_Z};

/* prototypes */

/* main */
void connect_events(void);
gint motion_notify_event(GtkWidget *, GdkEventMotion *);
gint button_press_event(GtkWidget *, GdkEventButton *);
gint button_release_event(GtkWidget *, GdkEventButton *);

/* display control */
void switch_mode(gint);
void gtk_switch_mode(GtkWidget *, gint);
void show_text(gint, gchar *);
void pick_model(struct model_pak *);
void refresh_view(void);
void canvas_shuffle(void);
void reset_view(void);
void event_pick_model(GtkWidget *, struct model_pak *);

/* model tree */
void tree_select_delete(void);
void tree_select_active(void);
void tree_select_model(struct model_pak *);
void tree_model_add(struct model_pak *);
void tree_model_refresh(struct model_pak *);
void tree_init(GtkWidget *);

void font_init(gpointer *);

void rotframe_toggle(void);

void atom_properties_box(GtkWidget *);

void diffract_dialog(void);
void diffract_select_peak(gint, gint, struct model_pak *);

void gamess_widget(GtkWidget *, struct model_pak *);
void gulp_widget(GtkWidget *, struct model_pak *);

void name_entry_changed(GtkWidget *, struct model_pak *);

void run_gulp(GtkWidget *, struct model_pak *);
void run_gamess(GtkWidget *, struct model_pak *);
void connect_refresh(void);

void hfs_dialog(void);

void med_interface(void);
void md_dialog(void);

void analysis_export_dialog(void);

void image_export_dialog(void);
void image_import_dialog(void);

void property_widget_redraw(void);
void symmetry_widget_redraw(void);

