LObject * l_quote(LObject * a1)
{
  LObject *val = LEvalFunc("quote",
			   LLOBJECT, a1,
			   LEND);
  LObject * retval;
  LFROMOBJ(LLOBJECT)(val, &retval);
  LFree(val);
  return retval;
}

void l_if(LObject * a1, LObject * a2, LObject * a3)
{
  LObject *val = LEvalFunc("if",
			   LLOBJECT, a1,
			   LLOBJECT, a2,
			   LLOBJECT, a3,
			   LEND);
  LFree(val);
}

int l_greater(LObject * a1, LObject * a2)
{
  LObject *val = LEvalFunc(">",
			   LLOBJECT, a1,
			   LLOBJECT, a2,
			   LEND);
  int retval;
  LFROMOBJ(LINT)(val, &retval);
  LFree(val);
  return retval;
}

int l_less(LObject * a1, LObject * a2)
{
  LObject *val = LEvalFunc("<",
			   LLOBJECT, a1,
			   LLOBJECT, a2,
			   LEND);
  int retval;
  LFROMOBJ(LINT)(val, &retval);
  LFree(val);
  return retval;
}

int l_equal(LObject * a1, LObject * a2)
{
  LObject *val = LEvalFunc("=",
			   LLOBJECT, a1,
			   LLOBJECT, a2,
			   LEND);
  int retval;
  LFROMOBJ(LINT)(val, &retval);
  LFree(val);
  return retval;
}

int l_sgi()
{
  LObject *val = LEvalFunc("sgi",
			   LEND);
  int retval;
  LFROMOBJ(LINT)(val, &retval);
  LFree(val);
  return retval;
}

int l_NeXT()
{
  LObject *val = LEvalFunc("NeXT",
			   LEND);
  int retval;
  LFROMOBJ(LINT)(val, &retval);
  LFree(val);
  return retval;
}

LObject * l_progn(LList * a1)
{
  LObject *val = LEvalFunc("progn",
			   LREST, a1,
			   LEND);
  LObject * retval;
  LFROMOBJ(LLOBJECT)(val, &retval);
  LFree(val);
  return retval;
}

LObject * l_car(LList  * a1)
{
  LObject *val = LEvalFunc("car",
			   LLIST, a1,
			   LEND);
  LObject * retval;
  LFROMOBJ(LLOBJECT)(val, &retval);
  LFree(val);
  return retval;
}

LObject * l_cdr(LList  * a1)
{
  LObject *val = LEvalFunc("cdr",
			   LLIST, a1,
			   LEND);
  LObject * retval;
  LFROMOBJ(LLOBJECT)(val, &retval);
  LFree(val);
  return retval;
}

void l_interest(LList  * a1)
{
  LObject *val = LEvalFunc("interest",
			   LLIST, a1,
			   LEND);
  LFree(val);
}

void l_uninterest(LList  * a1)
{
  LObject *val = LEvalFunc("uninterest",
			   LLIST, a1,
			   LEND);
  LFree(val);
}

void l_time_interests(float a1, char * a2, char * a3, char * a4)
{
  LObject *val = LEvalFunc("time-interests",
			   LFLOAT, a1,
			   LSTRING, a2,
			   LSTRING, a3,
			   LSTRING, a4,
			   LEND);
  LFree(val);
}

void l_regtable()
{
  LObject *val = LEvalFunc("regtable",
			   LEND);
  LFree(val);
}

void l_help(char * a1)
{
  LObject *val = LEvalFunc("help",
			   LSTRING, a1,
			   LEND);
  LFree(val);
}

void l_morehelp(char * a1)
{
  LObject *val = LEvalFunc("morehelp",
			   LSTRING, a1,
			   LEND);
  LFree(val);
}


extern LObject *Lquote(Lake *, LList *);
extern LObject *Lif(Lake *, LList *);
extern LObject *Lgreater(Lake *, LList *);
extern LObject *Lless(Lake *, LList *);
extern LObject *Lequal(Lake *, LList *);
extern LObject *Lsgi(Lake *, LList *);
extern LObject *LNeXT(Lake *, LList *);
extern LObject *Lprogn(Lake *, LList *);
extern LObject *Lcar(Lake *, LList *);
extern LObject *Lcdr(Lake *, LList *);
extern LObject *Linterest(Lake *, LList *);
extern LObject *Luninterest(Lake *, LList *);
extern LObject *Ltime_interests(Lake *, LList *);
extern LObject *Lregtable(Lake *, LList *);
extern LObject *Lhelp(Lake *, LList *);
extern LObject *Lmorehelp(Lake *, LList *);

extern char Hquote[];
extern char Hif[];
extern char Hgreater[];
extern char Hless[];
extern char Hequal[];
extern char Hsgi[];
extern char HNeXT[];
extern char Hprogn[];
extern char Hcar[];
extern char Hcdr[];
extern char Hinterest[];
extern char Huninterest[];
extern char Htime_interests[];
extern char Hregtable[];
extern char Hhelp[];
extern char Hmorehelp[];


void clisp_init()
{
  LDefun("quote", Lquote, Hquote);
  LDefun("if", Lif, Hif);
  LDefun(">", Lgreater, Hgreater);
  LDefun("<", Lless, Hless);
  LDefun("=", Lequal, Hequal);
  LDefun("sgi", Lsgi, Hsgi);
  LDefun("NeXT", LNeXT, HNeXT);
  LDefun("progn", Lprogn, Hprogn);
  LDefun("car", Lcar, Hcar);
  LDefun("cdr", Lcdr, Hcdr);
  LDefun("interest", Linterest, Hinterest);
  LDefun("uninterest", Luninterest, Huninterest);
  LDefun("time-interests", Ltime_interests, Htime_interests);
  LDefun("regtable", Lregtable, Hregtable);
  LDefun("help", Lhelp, Hhelp);
  LDefun("morehelp", Lmorehelp, Hmorehelp);
}

