/*  ComboboxEntry Example
 *
 *  This example creates a comboboxentry with a single list of text strings that can
 *  be edited. It uses Gtk::ComboBoxEntry and creates the model itself. Alternatively,
 *  it could use the convenience class Gtk::ComboBoxEntryText which creates the model
 *  for you. A more advanced combobox example can be found in the <tests/combobox> 
 *  subdirectory which shows you how to add images and use the new combobox grid mode.
 */

#include "comboboxentry.hh"
#include <gfc/gtk/box.hh>
#include <iostream>

ComboBoxEntry::ComboBoxEntry()
{
        Pointer<Gtk::ListStore> store = new Gtk::ListStore(1, G_TYPE_STRING);
	set_model(*store);
	set_text_column(0);
	
	for (int i = 0; i < 6; i++)
	{
		String s = String::format("Item Number %i", i);
		append_text(s);       
	}
	set_active(3);
}

Window::Window()
: Gtk::WidgetSignals(this)
{
	set_title("ComboBoxEntry Example");	
	set_border_width(10);
	Gtk::VBox *vbox = new Gtk::VBox;
        add(*vbox);

	// Gtk::ComboBoxEntry
        combobox = new ComboBoxEntry;
	vbox->add(*combobox);
	vbox->show_all();
}

Window::~Window()
{
}

bool 
Window::on_delete_event(const Gdk::EventAny&)
{
	std::cout << "You entered: " << combobox->get_text() << std::endl;
	return false;
}

int main (int argc, char *argv[])
{
	using namespace Main;

	init(&argc, &argv);

	Window window;
	window.sig_destroy().connect(sigc::ptr_fun(&GFC::Main::quit));
	window.show();

	run();
	return 0;
}

