/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  entry.cc - GtkEntry C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "entry.hh"
#include "private/entryclass.hh"
#include "private/marshal.hh"
#include "entrycompletion.hh"
#include "menu.hh"
#include "../pango/layout.hh"

using namespace GFC;

/*  Gtk::Entry
 */

Gtk::Entry::Entry(GtkEntry *entry, bool owns_reference)
: Widget((GtkWidget*)entry, owns_reference)
{
}

Gtk::Entry::Entry() 
: Widget((GtkWidget*)EntryClass::create())
{
}

Gtk::Entry::Entry(int max_length) 
: Widget((GtkWidget*)EntryClass::create())
{
	set_max_length(max_length);
}

Gtk::Entry::~Entry()
{
}

String
Gtk::Entry::get_text() const
{
	return gtk_entry_get_text(gtk_entry());
}

G::Unichar
Gtk::Entry::get_invisible_char() const
{
	return gtk_entry_get_invisible_char(gtk_entry());
}

Pango::Layout*
Gtk::Entry::get_layout() const
{
	return G::Object::wrap<Pango::Layout>(gtk_entry_get_layout(gtk_entry()));
}

Gtk::EntryCompletion*
Gtk::Entry::get_completion() const
{
	GtkEntryCompletion *completion = gtk_entry_get_completion(gtk_entry());
	return completion ? G::Object::wrap<EntryCompletion>(completion) : 0;
}

void
Gtk::Entry::set_invisible_char(G::Unichar ch)
{
	gtk_entry_set_invisible_char(gtk_entry(), ch);
}

void
Gtk::Entry::set_text(const String& text)
{
	gtk_entry_set_text(gtk_entry(), text.c_str());
}

void
Gtk::Entry::set_completion(EntryCompletion *completion)
{
	gtk_entry_set_completion(gtk_entry(), *completion);
}

/*  Gtk::Entry Signals
 */

const Gtk::Entry::PopulatePopupSignalType Gtk::Entry::populate_popup_signal("populate_popup", (GCallback)&Marshal::void_menu_callback);

const Gtk::Entry::ActviateSignalType Gtk::Entry::activate_signal("activate", (GCallback)&G::Marshal::void_callback);

const Gtk::Entry::InsertAtCursorSignalType Gtk::Entry::insert_at_cursor_signal("insert_at_cursor", (GCallback)&Marshal::void_string_callback);

