/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  container.inl - Gtk::Container inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GtkContainer*
GFC::Gtk::Container::gtk_container() const
{
	return reinterpret_cast<GtkContainer*>(instance_);
}

inline GFC::Gtk::Container::operator GtkContainer* () const
{
	return this ? gtk_container() : 0;
}

inline GType
GFC::Gtk::Container::child_type() const
{
	return gtk_container_child_type(gtk_container());
}

inline unsigned int
GFC::Gtk::Container::get_border_width() const
{
	return gtk_container_get_border_width(gtk_container());
}

inline GFC::Gtk::ResizeMode
GFC::Gtk::Container::get_resize_mode() const
{
	return (ResizeMode)gtk_container_get_resize_mode(gtk_container());
}

inline void
GFC::Gtk::Container::check_resize()
{
	gtk_container_check_resize(gtk_container());
}

inline void
GFC::Gtk::Container::set_border_width(unsigned int border_width)
{
	gtk_container_set_border_width(gtk_container(), border_width);
}

inline void
GFC::Gtk::Container::set_resize_mode(ResizeMode resize_mode)
{
	gtk_container_set_resize_mode(gtk_container(), (GtkResizeMode)resize_mode);
}

inline void
GFC::Gtk::Container::set_reallocate_redraws(bool needs_redraws)
{
	gtk_container_set_reallocate_redraws(gtk_container(), needs_redraws);
}

inline void
GFC::Gtk::Container::resize_children()
{
	gtk_container_resize_children(gtk_container());
}

inline void
GFC::Gtk::Container::unset_focus_chain()
{
	gtk_container_unset_focus_chain(gtk_container());
}

inline const GFC::Gtk::Container::AddSignalProxy
GFC::Gtk::Container::sig_add()
{
	return AddSignalProxy(this, &add_signal);
}

inline const GFC::Gtk::Container::RemoveSignalProxy
GFC::Gtk::Container::sig_remove()
{
	return RemoveSignalProxy(this, &remove_signal);
}

inline const GFC::Gtk::Container::CheckResizeSignalProxy
GFC::Gtk::Container::sig_check_resize()
{
	return CheckResizeSignalProxy(this, &check_resize_signal);
}

inline const GFC::Gtk::Container::SetFocusChildSignalProxy
GFC::Gtk::Container::sig_set_focus_child()
{
	return SetFocusChildSignalProxy(this, &set_focus_child_signal);
}

