/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  toolbarclass.hh - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GFC_GTK_TOOLBAR_CLASS_HH
#define GFC_GTK_TOOLBAR_CLASS_HH

namespace GFC {

namespace Gtk {

class ToolbarClass
{
public:
	static void init(GtkToolbarClass *g_class);

	static GtkToolbarClass* get_parent_class(void *instance);

	static GType get_type();

	static void* create();

	static void orientation_changed_proxy(GtkToolbar *toolbar, GtkOrientation orientation);

	static void style_changed_proxy(GtkToolbar *toolbar, GtkToolbarStyle style);

	static gboolean popup_context_menu_proxy(GtkToolbar *toolbar, gint x, gint y, gint button_number);
};

} // namespace Gtk

} // namespace GFC

#endif // GFC_GTK_TOOLBAR_CLASS_HH

