package body Iir_Chains is
   function Get_Chain_Length (First : Iir) return Natural
   is
      Res : Natural := 0;
      El : Iir := First;
   begin
      while El /= Null_Iir loop
         Res := Res + 1;
         El := Get_Chain (El);
      end loop;
      return Res;
   end Get_Chain_Length;

   procedure Sub_Chain_Init (First, Last : out Iir) is
   begin
      First := Null_Iir;
      Last := Null_Iir;
   end Sub_Chain_Init;

   procedure Sub_Chain_Append (First, Last : in out Iir; El : Iir) is
   begin
      if First = Null_Iir then
         First := El;
      else
         Set_Chain (Last, El);
      end if;
      Last := El;
   end Sub_Chain_Append;

   function Is_Chain_Length_One (Chain : Iir) return Boolean is
   begin
      return Chain /= Null_Iir and then Get_Chain (Chain) = Null_Iir;
   end Is_Chain_Length_One;

   procedure Insert (Last : Iir; El : Iir) is
   begin
      Set_Chain (El, Get_Chain (Last));
      Set_Chain (Last, El);
   end Insert;

   procedure Insert_Incr (Last : in out Iir; El : Iir) is
   begin
      Set_Chain (El, Get_Chain (Last));
      Set_Chain (Last, El);
      Last := El;
   end Insert_Incr;
end Iir_Chains;
