// FACTORY.CPP

// Copyright (C) 2001 Tommi Hassinen, Geoffrey Hutchison.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "factory.h"

#include "utility.h"

#include <fstream>
using namespace std;

/*################################################################################################*/

console_class_factory * console_class_factory::instance = NULL;
singleton_cleaner<console_class_factory> console_class_factory_cleaner(console_class_factory::GetInstance());

console_class_factory::console_class_factory(void) : class_factory()
{
}

console_class_factory::~console_class_factory(void)
{
}

console_class_factory * console_class_factory::GetInstance(void)
{
	if (instance != NULL) return instance;
	else return (instance = new console_class_factory());
}

err_util * console_class_factory::ProduceErrUtil(void)
{
	return new console_err_util();
}

prefs * console_class_factory::ProducePrefs(void)
{
	return new console_prefs();
}

/*################################################################################################*/

// eof
