/* gnobog_arborescence.h
 *
 * Copyright (C) 2000 Frdric LESPEZ & Renaud CHAILLAT
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GNOBOG_ARBORESCENCE_H
#define GNOBOG_ARBORESCENCE_H

#include <gnome.h>
#include "gnobog_bookmarks.h"

#define GNOBOG_TYPE_ARBORESCENCE             (gnobog_arborescence_get_type ())
#define GNOBOG_ARBORESCENCE(obj)             (GTK_CHECK_CAST ((obj), GNOBOG_TYPE_ARBORESCENCE, GnobogArborescence))
#define GNOBOG_ARBORESCENCE_CLASS(klass)     (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_ARBORESCENCE, GnobogArborescenceClass))
#define GNOBOG_IS_ARBORESCENCE(obj)          (GTK_CHECK_TYPE ((obj), GNOBOG_TYPE_ARBORESCENCE))
#define GNOBOG_IS_ARBORESCENCE_CLASS(klass)  (GTK_CHECK_CLASS_TYPE ((klass), GNOBOG_TYPE_ARBORESCENCE))


typedef         GtkCTreeNode*            GnobogArborescenceNode;
typedef struct _GnobogArborescence       GnobogArborescence;
typedef struct _GnobogArborescenceClass  GnobogArborescenceClass;

/* Selection modes */
enum _GnobogArborescenceSelectionMode {
  WINDOWS_MODE,
  DND_TIMER_ONLY_MODE,
  RINO_MODE
};
typedef enum _GnobogArborescenceSelectionMode  GnobogArborescenceSelectionMode;


/* Instance structure */
/* TODO : put some members into a private structure */
struct _GnobogArborescence {
  GtkCTree                        ctree;
  
  /* Bookmarks watched */
  GnobogBookmarks*                bookmarks_watched;
  /* Remember mouse information on 'button-press-event' signal */
  gint                            button_pressed;
  guint32                         button_pressed_time;  /* in milliseconds */
  gint                            button_pressed_x;
  gint                            button_pressed_y;
  /* Remember mouse information on 'button-release-event' signal.
   * Used to unselect a row if it was already selected on button-press */
  gint                            button_released;
  gint                            button_released_x;
  gint                            button_released_y;
  /* For selection */
  GnobogArborescenceSelectionMode selection_mode;
  gboolean                        row_was_selected;
  gint                            anchor_row;           /* pivot for extended selection */
  gint                            previous_row;         /* used while dragging to select rows */
  /* Dnd settings (arguments) */
  guint32                         dnd_timer;            /* in milliseconds */
  guint                           dnd_threshold;
  /* DND hint (TODO: use bit field ?) */
  gboolean                        timer_expired;
  gboolean                        in_extended_selection;
  gboolean                        perform_drag;
  /* Dnd auto-scrolling */
  gint                            drag_scroll_timer_id; /* ID for scrolling timer callback */
  gint                            drag_motion_y;        /* To store y motion position */
  /* Dnd cursor information */
  GtkCListDestInfo                dest_info;
  /* columns visibility */
  gint                            columns;
  gint                            visible_columns_count;
  gboolean*                       columns_visibility;
  gboolean                        titles_visibility;
  /* For later use */
  gpointer                        private;
};

/* Class structure */
struct _GnobogArborescenceClass {
  GtkCTreeClass       parent_class;
  
  /* 'bring popup menu' signal */
  void (*popup_menu)  (GnobogArborescence *arborescence, GdkEventButton *event);
  /* 'open_row' signal (double-click on a row) */
  void (*open_row)    (GnobogArborescence *arborescence, gint row );
};



/*********************
 * Public methods
 *********************/

/* Gtk+ standard functions */
GtkType                 gnobog_arborescence_get_type 
                                           (void);
GtkWidget*              gnobog_arborescence_new_with_titles 
                                           (GnobogBookmarks* bookmarks_watched, 
                                            int columns, 
                                            char **titles);

/* Settings */
void                    gnobog_arborescence_set_defaults 
                                           (GnobogArborescence* arborescence);
void                    gnobog_arborescence_set_dnd_timer 
                                           (GnobogArborescence* arborescence, 
                                            guint32 dnd_timer);
guint32                 gnobog_arborescence_get_dnd_timer 
                                           (GnobogArborescence* arborescence);
void                    gnobog_arborescence_set_dnd_threshold 
                                           (GnobogArborescence* arborescence, 
                                            gint dnd_threshold);
gint                    gnobog_arborescence_get_dnd_threshold 
                                           (GnobogArborescence* arborescence);
void                    gnobog_arborescence_set_selection_mode 
                                           (GnobogArborescence* arborescence, 
                                            gint selection_mode);
gint                    gnobog_arborescence_get_selection_mode 
                                           (GnobogArborescence* arborescence);

/* 'dynamic' settings */
void                    gnobog_arborescence_set_titles_visibility
                                           (GnobogArborescence* arborescence,
					    gboolean visibility);
gboolean                gnobog_arborescence_get_titles_visibility
                                           (GnobogArborescence* arborescence);
void                    gnobog_arborescence_set_column_visibility 
                                           (GnobogArborescence* arborescence, 
                                            gint column,
					    gboolean visibility);
gboolean                gnobog_arborescence_get_column_visibility 
                                           (GnobogArborescence* arborescence,
					    gint column);


/* Calbacks to connect to GnobogBookmarks signals with gtk_signal_connect_object */
void                    gnobog_arborescence_list_insert 
                                           (GnobogArborescence* arborescence, 
                                            GnobogBookmarksNode anchor_node, 
                                            GnobogBookmarksInsertMode mode, 
                                            GList* list, 
                                            gpointer data);
void                    gnobog_arborescence_list_delete 
                                           (GnobogArborescence* arborescence, 
                                            GList* list, 
                                            gpointer data);
void                    gnobog_arborescence_list_modify 
                                           (GnobogArborescence* arborescence, 
                                            GList* list, 
                                            gpointer data);
void                    gnobog_arborescence_clear 
                                           (GnobogArborescence* arborescence, 
                                            gpointer data);

/* 'Visual feedback' functions */
void                    gnobog_arborescence_highlight_row   
                                           (GnobogArborescence* arborescence, 
                                            gint row);
void                    gnobog_arborescence_unhighlight_row 
                                           (GnobogArborescence* arborescence, 
                                            gint row);
void                    gnobog_arborescence_highlight_node  
                                           (GnobogArborescence* arborescence, 
                                            GnobogArborescenceNode arborescence_node);
void                    gnobog_arborescence_unhighlight_node
                                           (GnobogArborescence* arborescence, 
                                            GnobogArborescenceNode arborescence_node);
void                    gnobog_arborescence_set_focus_row       
                                           (GnobogArborescence* arborescence, 
                                            gint row);
void                    gnobog_arborescence_reset_focus_row 
                                           (GnobogArborescence* arborescence);

/* Node functions */
GnobogArborescenceNode  gnobog_arborescence_get_node_from_cursor_coords 
                                           (GnobogArborescence* arborescence, 
                                            gint x, 
                                            gint y);
GnobogArborescenceNode  gnobog_arborescence_get_node_from_row 
                                           (GnobogArborescence* arborescence, 
                                            gint row);
GnobogArborescenceNode  gnobog_arborescence_get_arborescence_node_from_bookmarks_node 
                                           (GnobogArborescence* arborescence, 
                                            GnobogBookmarksNode bookmarks_node);
GnobogBookmarksNode     gnobog_arborescence_get_bookmarks_node_from_cusor_coords 
                                           (GnobogArborescence* arborescence, 
                                            gint x, 
                                            gint y);
GnobogBookmarksNode     gnobog_arborescence_get_bookmarks_node_from_row 
                                           (GnobogArborescence* arborescence, 
                                            gint row);
GnobogBookmarksNode     gnobog_arborescence_get_bookmarks_node_from_arborescence_node 
                                           (GnobogArborescence* arborescence, 
                                            GnobogArborescenceNode arborescence_node);

/* Row functions */
gint                    gnobog_arborescence_get_row_from_cursor_coords 
                                           (GnobogArborescence* arborescence, 
                                            gint x, 
                                            gint y);
gint                    gnobog_arborescence_get_row_from_bookmarks_node
                                           (GnobogArborescence* arborescence, 
                                            GnobogBookmarksNode bookmarks_node);
gint                    gnobog_arborescence_get_row_from_arborescence_node
                                           (GnobogArborescence* arborescence, 
                                            GnobogArborescenceNode arborescence_node);

/* Selection functions */
gboolean                gnobog_arborescence_selection_exists
                                           (GnobogArborescence* arborescence);
void                    gnobog_arborescence_select_all 
                                           (GnobogArborescence* arborescence);
void                    gnobog_arborescence_unselect_all        
                                           (GnobogArborescence* arborescence);
void                    gnobog_arborescence_select_row          
                                           (GnobogArborescence* arborescence, 
                                            gint row);
void                    gnobog_arborescence_unselect_row        
                                           (GnobogArborescence* arborescence, 
                                            gint row);
void                    gnobog_arborescence_list_select         
                                           (GnobogArborescence* arborescence, 
                                            GList* list);
void                    gnobog_arborescence_node_select         
                                           (GnobogArborescence* arborescence, 
                                            GnobogArborescenceNode arborescence_node);
void                    gnobog_arborescence_bookmarks_node_select               
                                           (GnobogArborescence* arborescence, 
                                            GnobogBookmarksNode bookmarks_node);
GList*                  gnobog_arborescence_get_sorted_node_selection 
                                           (GnobogArborescence* arborescence);
GList*                  gnobog_arborescence_get_sorted_bookmarks_node_selection 
                                           (GnobogArborescence* arborescence);
gboolean                gnobog_arborescence_is_row_selected 
                                           (GnobogArborescence* arborescence, 
                                            gint row);
gboolean                gnobog_arborescence_is_node_selected 
                                           (GnobogArborescenceNode arborescence_node);
gboolean                gnobog_arborescence_is_bookmarks_node_selected 
                                           (GnobogArborescence* arborescence, 
                                            GnobogBookmarksNode bookmarks_node);


#endif /* GNOBOG_ARBORESCENCE_H */
