/******************************************************************************\
 gnofin/ui-record-list.h   $Revision: 1.8 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef UI_RECORD_LIST_H
#define UI_RECORD_LIST_H

#include "ui-types.h"
#include "data-types.h"
#include <gtk/gtkeventbox.h>
#include <gtk/gtkwindow.h>

GNOFIN_API_BEGIN

#define UI_RECORD_LIST(obj)		(GTK_CHECK_CAST ((obj), ui_record_list_get_type (), UI_RecordList))
#define UI_RECORD_LIST_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), ui_record_list_get_type (), UI_RecordListClass))
#define UI_IS_RECORD_LIST(obj)		(GTK_CHECK_TYPE ((obj), ui_record_list_get_type ())
#define UI_IS_RECORD_LIST_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), ui_record_list_get_type ())

typedef struct _UI_RecordListClass   UI_RecordListClass;

typedef struct
{
  guint  field;	 /* RECORD_FIELD_XXX  */ 
  gchar *label;	 /* text shown in column title */
  guint  width;	 /* width of column */
  guint  align;  /* justification of column */

} UI_RecordListColumnInfo;

struct _UI_RecordList
{
  GtkEventBox  eventbox;

  Account     *account;
  Record      *selected_record;  // NULL if no record selected

  /* private */
  guint        select_row_id;  
  guint        unselect_row_id;  
};

struct _UI_RecordListClass
{
  GtkEventBoxClass parent_class;

  void (* selection_changed) (UI_RecordList *list);
};

GtkType    ui_record_list_get_type        (void);
GtkWidget *ui_record_list_new             (void);
void       ui_record_list_set_account     (UI_RecordList *, Account *);
void       ui_record_list_refresh         (UI_RecordList *, guint start_from);
void       ui_record_list_refresh_record  (UI_RecordList *, const Record *record, guint last_index, guint mask);
void       ui_record_list_insert_record   (UI_RecordList *, guint index, gboolean select);
void       ui_record_list_remove_record   (UI_RecordList *, guint index);
void       ui_record_list_select_record   (UI_RecordList *, guint index);

guint      ui_record_list_get_column_info (UI_RecordListColumnInfo **cinfo); // return by reference
void       ui_record_list_set_column_info (UI_RecordListColumnInfo *cinfo, guint num);

GNOFIN_API_END

#endif
