/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2003 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#ifndef __GNOME_CMD_FTP_SERVER_FUNCS_H__
#define __GNOME_CMD_FTP_SERVER_FUNCS_H__

#include "gnome-cmd-types.h"
#include "gnome-cmd-ftp-server-types.h"

GnomeCmdFtpServer*
gnome_cmd_ftp_server_new                 (void);

GnomeCmdFtpServer*
gnome_cmd_ftp_server_new_with_values     (const gchar *alias,
										  const gchar *host_name, 
										  gint host_port,
										  const gchar *user_name,
										  const gchar *pw);

void
gnome_cmd_ftp_server_free                (GnomeCmdFtpServer *fs);

void
gnome_cmd_ftp_server_set_alias           (GnomeCmdFtpServer *fs,
										  const gchar *alias);

void
gnome_cmd_ftp_server_set_host_name       (GnomeCmdFtpServer *fs,
										  const gchar *host_name);

void
gnome_cmd_ftp_server_set_host_port       (GnomeCmdFtpServer *fs,
										  gint host_port);

void
gnome_cmd_ftp_server_set_user_name       (GnomeCmdFtpServer *fs,
										  const gchar *user_name);

void
gnome_cmd_ftp_server_set_pw              (GnomeCmdFtpServer *fs,
										  const gchar *pw);

const gchar*
gnome_cmd_ftp_server_get_alias           (GnomeCmdFtpServer *fs); 

const gchar*
gnome_cmd_ftp_server_get_host_name       (GnomeCmdFtpServer *fs);

gint
gnome_cmd_ftp_server_get_host_port       (GnomeCmdFtpServer *fs);

const gchar*
gnome_cmd_ftp_server_get_user_name       (GnomeCmdFtpServer *fs);

const gchar*
gnome_cmd_ftp_server_get_pw              (GnomeCmdFtpServer *fs);

void
gnome_cmd_ftp_server_set_bookmarks       (GnomeCmdFtpServer *fs,
										  GnomeCmdBookmarkGroup *group);

GnomeCmdBookmarkGroup *
gnome_cmd_ftp_server_get_bookmarks       (GnomeCmdFtpServer *fs);


#endif //__GNOME_CMD_FTP_SERVER_FUNCS_H__
