#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2005 Free Software Foundation
#
# FILE:
# Container.py
#
# DESCRIPTION:
#
# NOTES:
#


import math
import curses
##try:
## from curses import panel
##except ImportError:
##  raise "The use of curses requires at least Python 2.1"

from constants import *
import sio
from utility import _paintBorder
from GraphicObject import GraphicObject

class Container(GraphicObject):
  """
  Screen Container
  """

  def __init__(self, **properties):
    """
    Zero Controls list and Metrics dictionary.  Chainload GraphicObject
    parent class.  Event initialization.
    """
    SIOInstance = sio.sio()

    self.Controls = []  # Stack of control objects
    self.Panels = []
    self.Metrics  = {}  # ditionary of dimensions, keyed by control obj
    self.VISIBLE = 1

    GraphicObject.__init__(self, SIOInstance, **properties)

    self.STARTPOINT = 0
    self.breakUp = 0
    self.SetColor(SIOInstance.colors.C_BACKGROUND)
    self.nextCtl = None
    self.eventX = -1
    self.eventY = -1
    self._CurrentFocus = None
    self._CurrentFrame = self
    self.R1 = 0
    self.C1 = 0
    self._ChildOffsetX = 0
    self._ChildOffsetY = 0


  def SetProperty(self, PropertyName, PropertyValue):
    """
    """
    GraphicObject.SetProperty(self, PropertyName, PropertyValue)
    if self.IsPropertyInherited(PropertyName):
      for i in xrange(0, len(self.Controls)):
        self.Controls[i].SetProperty(PropertyName, PropertyValue)

  def AddPanel(self, panel):
    self.Panels.append(panel)

  def AddControl(self, control):
    """
    Add a control to the screen container.  Control object is 'setup' and
    appened to the Controls list, ABSOLUTE corners are registered in a
    4 member tuple (Y,X,H,W) in Metrics, keyed by control name.
    """

    control.InheritProperties(self)
    self.Controls.append(control)
    self.Metrics[control] = (
        control.Y, control.X,
        control.Y+ control.H,
        control.X+ control.W)

    return control

  def DelControl(self,control = None):
    """Delete a control from the Control stack, and it's dimension
    properties from the Metrics dict."""
    if  self.Controls.count(control) != 0:
      del self.Metrics[control]
      self.Controls.remove(control)

  def Screen(self):
    """Return SCREEN to caller."""
    return self.SCREEN

  def Paint(self, captureRefresh = 1):
    """
    Paint EVERY Control registered in this Container
    instance.  Effectively repainting the entire container iteratively.
    """
    if not self.VISIBLE:
      return

    if captureRefresh:
      self.SCREEN.AutoRefresh = 0

    for Control in self.Controls:
      Control.ExecMethod("SYSPAINT", None, None, None)

    if captureRefresh:
      self.SCREEN.AutoRefresh = 1
      self.SCREEN.Refresh()


  def FindControlByName(self, ControlName):
    "Return control object from self.Controls based on label 'NAME'."
    for c in self.Controls:
      if c.NAME== ControlName:
        return c
    return None


  def printAt(x, y, text):
    pass

  def __PaintBorder(self, caption=None):
    DialogWidth = self.Width()
    DialogHeight = self.Height()
    _paintBorder( self, 0,0, DialogHeight, DialogWidth, caption=caption)

