indexing

	description:

		"Interface for character output streams with the notion of lines"

	library: "Gobo Eiffel Kernel Library"
	copyright: "Copyright (c) 2001, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/02/07 12:49:50 $"
	revision: "$Revision: 1.5 $"

deferred class KI_TEXT_OUTPUT_STREAM

inherit

	KI_CHARACTER_OUTPUT_STREAM

feature -- Output

	put_line (a_string: STRING) is
			-- Write `a_string' to output stream
			-- followed by a line separator.
		require
			is_open_write: is_open_write
			a_string_not_void: a_string /= Void
		do
			put_string (a_string)
			put_new_line
		end

	put_new_line is
			-- Write a line separator to output stream.
		require
			is_open_write: is_open_write
		do
			put_string (eol)
		end

feature -- Access

	eol: STRING is
			-- Line separator
		deferred
		ensure
			eol_not_void: Result /= Void
			eol_not_empty: Result.count > 0
		end

end
