indexing

	description:

		"Eiffel types followed by a comma"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 2002, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/06/01 17:11:44 $"
	revision: "$Revision: 1.9 $"

class ET_TYPE_COMMA

inherit

	ET_TYPE_ITEM

creation

	make

feature {NONE} -- Initialization

	make (a_type: like type; a_comma: like comma) is
			-- Create a new type-comma.
		require
			a_type_not_void: a_type /= Void
			a_comma_not_void: a_comma /= Void
		do
			type := a_type
			comma := a_comma
		ensure
			type_set: type = a_type
			comma_set: comma = a_comma
		end

feature -- Access

	type: ET_TYPE
			-- Type in comma-separated list

	comma: ET_SYMBOL
			-- Comma separator

	position: ET_POSITION is
			-- Position of first character of
			-- current node in source code
		do
			Result := type.position
		end

	break: ET_BREAK is
			-- Break which appears just after current node
		do
			Result := comma.break
		end

feature -- Type processing

	resolved_formal_parameters (a_parameters: ET_ACTUAL_PARAMETER_LIST): ET_TYPE_COMMA is
			-- Version of current type where the formal generic
			-- parameter types have been replaced by their actual
			-- counterparts in `a_parameters'
		local
			a_type: ET_TYPE
		do
			a_type := type.resolved_formal_parameters (a_parameters)
			if a_type /= type then
				create Result.make (a_type, comma)
			else
				Result := Current
			end
		end

feature -- Processing

	process (a_processor: ET_AST_PROCESSOR) is
			-- Process current node.
		do
			a_processor.process_type_comma (Current)
		end

invariant

	comma_not_void: comma /= Void

end
