#!/bin/sh
#
# chkconfig: 345 80 20
# description: Start and stop remote system info polling tool
#
# patch contributed by Tim Powers (timp at redhat.com)
#

# Source function library
. /etc/rc.d/init.d/functions

# Source configuration
. /etc/sysconfig/network


case $1 in
  start)
    echo -n "Starting rgpsp: "
    daemon /usr/bin/rgpsp_linux
    RETVAL=$?
    [ $RETVAL -eq 0 ] && touch /var/lock/subsys/rgpsp_linux
    echo
    ;;
  stop)
    echo -n "Stopping rgpsp: "
    killproc rgpsp_linux
    RETVAL=$?
    if [ $RETVAL -eq 0 ]; then
      rm -f /var/lock/subsys/rgpsp_linux
      echo rgpsp_linux
    else
      echo
    fi
    ;;
  status)
    status rgpsp_linux
    RETVAL=$?
    ;;
  restart)
    $0 stop
    $0 start
    RETVAL=$?
    ;;
  *)
    echo "Usage: $0 {start|stop|status|restart}"
    ;;

esac
exit $RETVAL


