/* $Id: treeview.cc,v 1.10 2002/03/10 18:37:10 bergo Exp $ */

/*

    GPS - Graphical Process Statistics
    Copyright (C) 1999-2002 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include <errno.h>
#include <gtk/gtk.h>
#include "transient.h"
#include "details.h"
#include "diefast.h"
#include "gps.h"
#include "polling.h"
#include "netpolling.h"
#include "treeview.h"
#include "msgbox.h"

#include "importglobals.h"

#include "pixmaps/treehost.xpm"

GtkWidget *twnd=NULL;
GdkPixmap *hostpix=NULL;
GdkBitmap *hostmask=NULL;

GtkWidget *ptree,*psw;

GList *tnodes=NULL; // process nodes (ProcessLeaf *)
GList *hnodes=NULL; // host nodes    (GtkWidget *)

GtkWidget *tv_action_menu=NULL;
GtkTreeItem *tv_selection=NULL;

gint eoc=0; // default state 0=expanded 1=collapsed

void pop_treeview(GtkWidget *gw,gpointer data) {
  GtkWidget *v1,*db,*sw,*chb,*vbb;
  GtkWidget *ea,*ca,*rb;
  GtkWidget *mb,*mai,*ma,*mo[5],*msub[3],*mti;
  char title[512],bu[256];
  int i,j;

  if (netcritical)
    return;
  
  if (twnd!=NULL)
    return;

  twnd=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_default_size(GTK_WINDOW(twnd),350,400);
  gtk_window_set_position(GTK_WINDOW(twnd),GTK_WIN_POS_CENTER);
  gtk_widget_realize(twnd);
  gtk_window_set_policy(GTK_WINDOW(twnd),TRUE,TRUE,TRUE);
  gethostname(bu,256);
  snprintf(title,512,"gPS: Process Tree (%s)",bu);
  title[511]=0;
  gtk_window_set_title(GTK_WINDOW(twnd),title);
  gtk_container_set_border_width(GTK_CONTAINER(twnd),0);

  load_pix();

  v1=gtk_vbox_new(FALSE,2);
  gtk_container_add(GTK_CONTAINER(twnd),v1);  

  /* menu */

  ma=gtk_menu_new();
  mo[0]=gtk_menu_item_new_with_label("Send signal to process");
  mo[1]=gtk_menu_item_new_with_label("Send signal to process and its children");
  mo[2]=gtk_menu_item_new_with_label("Send signal to process' children only");
  mo[3]=gtk_menu_item_new();
  mo[4]=gtk_menu_item_new_with_label("Details...");
  
  for(j=0;j<3;j++)
    msub[j]=gtk_menu_new();
  for(i=0;i<POSIXSIG;i++) {
    snprintf(bu,256,"%s (%d)",posixnames[i],posixvalues[i]);
    bu[255]=0;
    for(j=0;j<3;j++) {
      mti=gtk_menu_item_new_with_label(bu);
      gtk_menu_append(GTK_MENU(msub[j]),mti);
      switch(j) {
      case 0:
	gtk_signal_connect(GTK_OBJECT(mti),"activate",
			   GTK_SIGNAL_FUNC(PosixKillOne),
			   &posixvalues[i]);
	break;
      case 1:
	gtk_signal_connect(GTK_OBJECT(mti),"activate",
			   GTK_SIGNAL_FUNC(PosixKillFamily),
			   &posixvalues[i]);
	break;
      case 2:
	gtk_signal_connect(GTK_OBJECT(mti),"activate",
			   GTK_SIGNAL_FUNC(PosixKillChildren),
			   &posixvalues[i]);
	break;
      }
      gtk_widget_show(mti);
    }
  }

  for(j=0;j<3;j++) {
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(mo[j]),msub[j]);
    gtk_menu_item_configure(GTK_MENU_ITEM(mo[j]),FALSE,TRUE);
  }

  for(i=0;i<5;i++)
    gtk_menu_append(GTK_MENU(ma),mo[i]);
  for(i=0;i<5;i++)
    gtk_widget_show(mo[i]);

  gtk_signal_connect(GTK_OBJECT(mo[4]),"activate",
		     GTK_SIGNAL_FUNC(tv_details),
		     NULL);

  /* put together */
  mb=gtk_menu_bar_new();
  gtk_box_pack_start(GTK_BOX(v1),mb,FALSE,TRUE,0);
  gtk_widget_show(mb);

  mai=gtk_menu_item_new_with_label("Action");
  tv_action_menu=mai;
  gtk_widget_show(mai);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(mai),ma);

  gtk_menu_bar_append(GTK_MENU_BAR(mb),mai);
  gtk_widget_show(ma);
  gtk_widget_set_sensitive(mai,FALSE);

  /* end menu */

  chb=gtk_hbox_new(FALSE,4);
  gtk_container_set_border_width(GTK_CONTAINER(chb),4);  
  gtk_box_pack_start(GTK_BOX(v1),chb,TRUE,TRUE,0);

  vbb=gtk_vbox_new(FALSE,4);

  psw=sw=gtk_scrolled_window_new(NULL,NULL);
  gtk_box_pack_start(GTK_BOX(chb),sw,TRUE,TRUE,4);
  gtk_widget_show(sw);
  gtk_container_set_border_width(GTK_CONTAINER(sw),0);

  gtk_box_pack_start(GTK_BOX(chb),vbb,FALSE,TRUE,0);

  ptree=gtk_tree_new();
  update_ptree();

  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw),
				 GTK_POLICY_AUTOMATIC,
				 GTK_POLICY_ALWAYS);
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(sw),ptree);

  /* bottom */

  ea=gtk_button_new_with_label(" Expand All ");
  ca=gtk_button_new_with_label(" Collapse All ");
  rb=gtk_button_new_with_label("Refresh");

  gtk_box_pack_start(GTK_BOX(vbb),ea,FALSE,TRUE,4);
  gtk_box_pack_start(GTK_BOX(vbb),ca,FALSE,TRUE,4);
  gtk_box_pack_start(GTK_BOX(vbb),rb,FALSE,TRUE,4);

  db=gtk_button_new_with_label("Dismiss");
  GTK_WIDGET_SET_FLAGS(db,GTK_CAN_DEFAULT);

  gtk_box_pack_end(GTK_BOX(vbb),db,FALSE,TRUE,4);

  gtk_widget_grab_default(db);

  gtk_widget_show(db);
  gtk_widget_show(ea);
  gtk_widget_show(ca);
  gtk_widget_show(rb);
  gtk_widget_show(chb);
  gtk_widget_show(vbb);
  gtk_widget_show(ptree);
  gtk_widget_show(v1);
  gtk_widget_show(twnd);

  gtk_signal_connect(GTK_OBJECT(ea),"clicked",
		     GTK_SIGNAL_FUNC(expand_treeview_box),NULL);
  gtk_signal_connect(GTK_OBJECT(ca),"clicked",
		     GTK_SIGNAL_FUNC(collapse_treeview_box),NULL);
  gtk_signal_connect(GTK_OBJECT(rb),"clicked",
		     GTK_SIGNAL_FUNC(refresh_treeview),NULL);

  gtk_signal_connect(GTK_OBJECT(db),"clicked",
		     GTK_SIGNAL_FUNC(close_treeview_box),NULL);
  gtk_signal_connect (GTK_OBJECT (twnd), "destroy",
		      GTK_SIGNAL_FUNC (destroy_treeview_box), NULL);
}

void expand_treeview_box(GtkWidget *gw,gpointer data) {
  GList *pt;
  ProcessLeaf *pl;

  for(pt=tnodes;pt!=NULL;pt=g_list_next(pt)) {
    pl=(ProcessLeaf *)(pt->data);
    if ((pl->sonlist)!=NULL)
      gtk_tree_item_expand(GTK_TREE_ITEM(pl->treeitem));
  }
  for(pt=hnodes;pt!=NULL;pt=g_list_next(pt))
    gtk_tree_item_expand(GTK_TREE_ITEM(pt->data));
  gtk_widget_queue_resize(ptree);
  eoc=0;
}

void collapse_treeview_box(GtkWidget *gw,gpointer data) {
  GList *pt;
  ProcessLeaf *pl;

  for(pt=tnodes;pt!=NULL;pt=g_list_next(pt)) {
    pl=(ProcessLeaf *)(pt->data);
    if ((pl->sonlist)!=NULL)
      gtk_tree_item_collapse(GTK_TREE_ITEM(pl->treeitem));
  }
  for(pt=hnodes;pt!=NULL;pt=g_list_next(pt))
    gtk_tree_item_collapse(GTK_TREE_ITEM(pt->data));
  gtk_widget_queue_resize(ptree);
  eoc=1;
}

void close_treeview_box(GtkWidget *w, gpointer data) {
  gtk_widget_destroy(twnd);
  twnd=NULL;
}

void destroy_treeview_box(GtkWidget *w,gpointer data) {
  reset_tnodes();
  twnd=NULL;
}

void frobnicate_the_tree(GtkTreeItem *gti,gpointer data) {
  gtk_widget_queue_resize(ptree);
  gtk_widget_queue_draw(ptree);
}

void load_pix() {
  GtkStyle *style;

  if (hostpix!=NULL) return;

  style=gtk_widget_get_style(twnd);
  hostpix = gdk_pixmap_create_from_xpm_d (twnd->window, &hostmask,
				       &style->bg[GTK_STATE_NORMAL],
				       (gchar **) treehost_xpm);
}

GtkWidget *host_entry_new(char *hname) {
  GtkWidget *h,*p,*l;
  
  h=gtk_hbox_new(FALSE,2);
  p=gtk_pixmap_new(hostpix,hostmask);
  l=gtk_label_new(hname);

  gtk_box_pack_start(GTK_BOX(h),p,FALSE,FALSE,1);
  gtk_box_pack_start(GTK_BOX(h),l,FALSE,FALSE,1);

  gtk_widget_show(p);
  gtk_widget_show(l);
  return(h);
}

void update_ptree() {
  GtkWidget *me,*c,*them;
  char bu[256];
  GList *p1,*p2,*p3;
  NetworkListPoller *nlp;
  NetworkDetailsPoller *ndp;
  NetworkSystemInfoProvider *nsp;

  me=gtk_tree_item_new();
  gethostname(bu,256);
  c=host_entry_new(bu);
  gtk_container_add(GTK_CONTAINER(me),c);
  gtk_widget_show(c);
  gtk_widget_show(me);

  gtk_signal_connect(GTK_OBJECT(me),"expand",
		     GTK_SIGNAL_FUNC(frobnicate_the_tree),NULL);
  gtk_signal_connect(GTK_OBJECT(me),"collapse",
		     GTK_SIGNAL_FUNC(frobnicate_the_tree),NULL);

  gtk_tree_append(GTK_TREE(ptree),me);

  /* add processes */

  reset_tnodes();
  hnodes=g_list_append(hnodes,(gpointer)(me));
  update_local_subtree(me);

  if (!poll_local_only) {
    for(p1=listwatch,p2=detailswatch,p3=sysinfowatch;
	((p1!=NULL)&&(p2!=NULL)&&(p3!=NULL));
	p1=g_list_next(p1),p2=g_list_next(p2),p3=g_list_next(p3)) {
      nlp=(NetworkListPoller *)p1->data;
      ndp=(NetworkDetailsPoller *)p2->data;
      nsp=(NetworkSystemInfoProvider *)p3->data;

      them=gtk_tree_item_new();
      c=host_entry_new(nsp->getHostname());
      gtk_container_add(GTK_CONTAINER(them),c);
      gtk_widget_show(c);
      gtk_widget_show(them);

      gtk_signal_connect(GTK_OBJECT(them),"expand",
			 GTK_SIGNAL_FUNC(frobnicate_the_tree),NULL);
      gtk_signal_connect(GTK_OBJECT(them),"collapse",
			 GTK_SIGNAL_FUNC(frobnicate_the_tree),NULL);
		 
      gtk_tree_append(GTK_TREE(ptree),them);
      hnodes=g_list_append(hnodes,(gpointer)(them));
      update_remote_subtrees(them,nlp,ndp,nsp);
    }
  }
  if (eoc)
    collapse_treeview_box(NULL,NULL);
  else
    expand_treeview_box(NULL,NULL);
}

void update_local_subtree(GtkWidget *parent) {
  ProcessLeaf *pl,*pk;
  ProcessListItem *pli;
  GList *gl,*pt,*px;
  GtkWidget *local;

  list_poller->poll();

  gl=g_list_copy(list_poller->process_list);

  for(pt=gl;pt!=NULL;pt=g_list_next(pt)) {
    pl=new ProcessLeaf();
    pli=(ProcessListItem *)(pt->data);
    pl->poll_pid(atoi(pli->pid));
    tnodes=g_list_append(tnodes,(gpointer)(pl));
  }

  g_list_free(gl);

  local=gtk_tree_new();

  /* set structure */
  for(pt=tnodes;pt!=NULL;pt=g_list_next(pt)) {
    pl=(ProcessLeaf *)(pt->data);
    for(px=tnodes;px!=NULL;px=g_list_next(px)) {
      if (pt==px) continue;
      pk=(ProcessLeaf *)(px->data);
      if ((pl->pid)==(pk->ppid)) {
	pl->sonlist=g_list_append(pl->sonlist,(gpointer)pk);
	pk->father=pl;
      }
    }
  }

  /* build */
  for(pt=tnodes;pt!=NULL;pt=g_list_next(pt)) {
    pl=(ProcessLeaf *)(pt->data);
    if ((pl->father)==NULL) {
      pl->build_item(local);
      pl->recursive_compose_offspring();
    }
  }

  gtk_tree_item_set_subtree(GTK_TREE_ITEM(parent),local);
}

void update_remote_subtrees(GtkWidget *parent,
			    NetworkListPoller *nlp,
			    NetworkDetailsPoller *ndp,
			    NetworkSystemInfoProvider *nsp) {

  ProcessLeaf *pl,*pk;
  ProcessListItem *pli;
  GList *gl,*pt,*px;
  GtkWidget *remote;
  GList *heretn;

  nlp->poll();

  heretn=NULL;
  gl=g_list_copy(nlp->process_list);

  ndp->poll2buffer();
  for(pt=gl;pt!=NULL;pt=g_list_next(pt)) {
    pl=new ProcessLeaf();
    pli=(ProcessListItem *)(pt->data);
    pl->poll_net_pid(atoi(pli->pid),ndp,nsp);
    heretn=g_list_append(heretn,(gpointer)(pl));
  }

  g_list_free(gl);

  remote=gtk_tree_new();

  /* set structure */
  for(pt=heretn;pt!=NULL;pt=g_list_next(pt)) {
    pl=(ProcessLeaf *)(pt->data);
    for(px=heretn;px!=NULL;px=g_list_next(px)) {
      if (pt==px) continue;
      pk=(ProcessLeaf *)(px->data);
      if ((pl->pid)==(pk->ppid)) {
	pl->sonlist=g_list_append(pl->sonlist,(gpointer)pk);
	pk->father=pl;
      }
    }
  }

  /* build */
  for(pt=heretn;pt!=NULL;pt=g_list_next(pt)) {
    pl=(ProcessLeaf *)(pt->data);
    if ((pl->father)==NULL) {
      pl->build_item(remote);
      pl->recursive_compose_offspring();
    }
  }

  tnodes=g_list_concat(tnodes,heretn);

  gtk_tree_item_set_subtree(GTK_TREE_ITEM(parent),remote);

}

void reset_tnodes() {
  GList *pt;
  if (hnodes!=NULL) {
    g_list_free(hnodes);
    hnodes=NULL;
  }
  if (tnodes==NULL) return;
  for(pt=tnodes;pt!=NULL;pt=g_list_next(pt))
    delete( (ProcessLeaf *)(pt->data) );
  g_list_free(tnodes);
  tnodes=NULL;
}

/* ProcessLeaf class */

ProcessLeaf::~ProcessLeaf() {
  g_list_free(sonlist);  
}

void ProcessLeaf::recursive_compose_offspring() {
  GList *pt;
  ProcessLeaf *pl;

  if (sonlist==NULL) return;

  for(pt=sonlist;pt!=NULL;pt=g_list_next(pt)) {
    pl=(ProcessLeaf *)(pt->data);
    pl->build_item(thistree);
    pl->compose_item();
    pl->recursive_compose_offspring();
  }
}

void ProcessLeaf::build_item(GtkWidget *above) {
  if (treeitem!=NULL)
    return;
  treeitem=gtk_tree_item_new_with_label(get_tree_label());
  gtk_tree_append(GTK_TREE(above),treeitem);

  if (sonlist!=NULL) {
    thistree=gtk_tree_new();
    gtk_tree_item_set_subtree(GTK_TREE_ITEM(treeitem),thistree);
  }

  gtk_widget_show(treeitem);
  sigid[0]=gtk_signal_connect(GTK_OBJECT(treeitem),"expand",
		     GTK_SIGNAL_FUNC(frobnicate_the_tree),NULL);
  sigid[1]=gtk_signal_connect(GTK_OBJECT(treeitem),"collapse",
		     GTK_SIGNAL_FUNC(frobnicate_the_tree),NULL);
  sigid[2]=gtk_signal_connect(GTK_OBJECT(treeitem),"select",
		     GTK_SIGNAL_FUNC(tv_select_item),NULL);
  sigid[3]=gtk_signal_connect(GTK_OBJECT(treeitem),"deselect",
		     GTK_SIGNAL_FUNC(tv_deselect_item),NULL);
}

void ProcessLeaf::compose_item() {
  GList *pt;
  ProcessLeaf *pl;

  if (sonlist==NULL) return;

  for(pt=sonlist;pt!=NULL;pt=g_list_next(pt)) {
    pl=(ProcessLeaf *)(pt->data);
    pl->build_item(thistree);    
  }
}

char * ProcessLeaf::get_tree_label() {
  snprintf(local_buffer,512,"%d %s [%s]",
	  pid,process_title,owner);
  local_buffer[511]=0;
  return(local_buffer);
}

void ProcessLeaf::poll_pid(int n) {
  ProcessItem *pi;

  while(!enter_mutex()) usleep(13);
  details_poller->poll(n);
  pi=details_poller->item;

  if (pi!=NULL) {
	strcpy(process_title,pi->name);
	strcpy(owner,pi->owner);
	pid=atoi(pi->pid);
	ppid=atoi(pi->ppid);
  } else {
	strcpy(process_title,"<can't stat>");
	strcpy(owner,"???");
	pid=0;
	ppid=0;
  }

  exit_mutex();

  treeitem=NULL;
  sonlist=NULL;
  father=NULL;
  thistree=NULL;
  gethostname(machine,GPS_MAXHOSTNAME);
}

void ProcessLeaf::poll_net_pid(int n,
			       NetworkDetailsPoller *ndp,
			       NetworkSystemInfoProvider *nsp) {
  ProcessItem *pi;
  pid=ppid=0;
  process_title[0]=0;
  owner[0]=0;

  treeitem=NULL;
  sonlist=NULL;
  father=NULL;
  thistree=NULL;
  strcpy(machine,nsp->getHostname());

  ndp->queryBuffer(n);
  pi=ndp->item;

  if (pi==NULL) {
    strcpy(process_title,"<lost process soul>");
    pid=-1;
    ppid=0;
    strcpy(owner,"<none>");
    return;
  }

  if (pi->name!=NULL)
    strcpy(process_title,pi->name);
  if (pi->owner!=NULL)
    strcpy(owner,pi->owner);
  if (pi->pid!=NULL)
    pid=atoi(pi->pid);
  if (pi->ppid!=NULL)
    ppid=atoi(pi->ppid);
}

/* killa killa */

void PosixKillChildren(GtkWidget *gw,gpointer data) {
  int sig;
  ProcessLeaf *pl;
  GList *pt;

  sig=*((int *)data);
  pl=findNode(tv_selection);
  if (pl==NULL) {
    message_box(GTK_WINDOW(twnd),
		ERR_KILL_NOS2,
		"Cannot send signal",
		MSGBOX_OK,
		MSGBOX_ICON_ERROR);
    return;
  }

  if (strcmp(this_host,pl->machine)!=0) {
    message_box(GTK_WINDOW(twnd),
		ERR_NON_LOCAL,
		"Error",
		MSGBOX_OK,
		MSGBOX_ICON_ERROR);
    return;
  }  

  tv_kill_children(pl,sig);
  refresh_treeview(NULL,NULL);
}

void PosixKillFamily(GtkWidget *gw,gpointer data) {
  int sig;
  ProcessLeaf *pl;
  GList *pt;

  sig=*((int *)data);
  pl=findNode(tv_selection);
  if (pl==NULL) {
    message_box(GTK_WINDOW(twnd),
		ERR_KILL_NOS2,
		"Cannot send signal",
		MSGBOX_OK,
		MSGBOX_ICON_ERROR);
    return;
  }

  if (strcmp(this_host,pl->machine)!=0) {
    message_box(GTK_WINDOW(twnd),
		ERR_NON_LOCAL,
		"Error",
		MSGBOX_OK,
		MSGBOX_ICON_ERROR);
    return;
  }  

  tv_kill_family(pl,sig);
  refresh_treeview(NULL,NULL);
}

void PosixKillOne(GtkWidget *gw,gpointer data) {
  int sig;
  ProcessLeaf *pl;

  sig=*((int *)data);
  pl=findNode(tv_selection);
  if (pl==NULL) {
    message_box(GTK_WINDOW(twnd),
		ERR_KILL_NOS2,
		"Cannot send signal",
		MSGBOX_OK,
		MSGBOX_ICON_ERROR);
    return;
  }

  if (strcmp(this_host,pl->machine)!=0) {
    message_box(GTK_WINDOW(twnd),
		ERR_NON_LOCAL,
		"Error",
		MSGBOX_OK,
		MSGBOX_ICON_ERROR);
    return;
  }

  signal_it_friendly(pl->pid,sig);
  refresh_treeview(NULL,NULL);
}

void tv_kill_family(class ProcessLeaf *pl,int zignal) {
  GList *pt;

  for(pt=pl->sonlist;pt!=NULL;pt=g_list_next(pt))
    tv_kill_family( (ProcessLeaf *)(pt->data) , zignal );

  signal_it_friendly( pl->pid , zignal );
}

void tv_kill_children(class ProcessLeaf *pl,int zignal) {
  GList *pt;

  for(pt=pl->sonlist;pt!=NULL;pt=g_list_next(pt))
    tv_kill_family( (ProcessLeaf *)(pt->data) , zignal );
}

void signal_it_friendly(int pid,int zignal) {
  int r;
  char zbuf[256],*emsg;

  r=kill(pid,zignal);
  if (r==0)
    return;
  switch(errno) {
  case EINVAL:
    emsg=ERR_KILL_INS2;
    break;
  case ESRCH:
    emsg=ERR_KILL_NOS2;
    break;
  case EPERM:
    emsg=ERR_KILL_PER2;
    break;
  default:
    emsg=ERR_BAD_MAN_PAGES;
  }
  snprintf(zbuf,256,"Cannot send signal to PID %d",pid);
  zbuf[255]=0;
  message_box(GTK_WINDOW(twnd),
	      emsg,
	      zbuf,
	      MSGBOX_OK,
	      MSGBOX_ICON_ERROR);
}

class ProcessLeaf *findNode(GtkTreeItem *sti) {
  GList *pt;
  ProcessLeaf *pl;

  for(pt=tnodes;pt!=NULL;pt=g_list_next(pt)) {
    pl=(ProcessLeaf *)(pt->data);
    if (GTK_WIDGET(sti)==pl->treeitem)
      return(pl);
  }
  return NULL;
}

/* fresha fresha */

void refresh_treeview(GtkWidget *gw,gpointer data) {
  /* delete everything in the tree*/
  reset_tnodes();

  /* this is brute force, but GtkTree is behaving way too stupidly
     when I remove the old items, I can't afford it... */

  gtk_widget_destroy(ptree);
  ptree=gtk_tree_new();
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(psw),ptree);
  gtk_widget_show(ptree);
  update_ptree();
  gtk_widget_set_sensitive(tv_action_menu,FALSE);
}

/* selecta selecta */

void tv_select_item(GtkItem *gi,gpointer data) {
  gtk_widget_set_sensitive(tv_action_menu,TRUE);
  tv_selection=GTK_TREE_ITEM(gi);
}

void tv_deselect_item(GtkItem *gi,gpointer data) {
  gtk_widget_set_sensitive(tv_action_menu,FALSE);
  tv_selection=NULL;
}

void tv_details(GtkWidget *gw,gpointer data) {
  ProcessLeaf *pl;
  int pid;
  char *hsname;
  if (tv_selection==NULL) return;
  pl=findNode(tv_selection);
  if (pl==NULL) {
    pid=0;
    hsname=this_host;
  } else {
    pid=pl->pid;
    hsname=pl->machine;
  }
  open_details(pid,hsname);
}
