/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_MODRESULTSET_H)
#define __INC_MODRESULTSET_H

#include <vector>

#include <gql++/result-set.h>
#include <gql++/result-set-metadata.h>

namespace GQL
{

class ModResultSetMetaData : public ResultSetMetaData
{
  public:
    ModResultSetMetaData(int cols);
    virtual ~ModResultSetMetaData();
    
    virtual int column_count() const { return ncols_; }
    virtual std::string get_column_label(int i) const {
      return col_labels_[i].empty() ? col_names_[i] : col_labels_[i];
    }
    virtual std::string get_column_name(int i) const {
      return col_names_[i];
    }
    virtual const SQLType& get_column_type(int i) const {
      return col_types_[i];
    }
    
    void set_column_label(int i, const std::string& s);
    void set_column_name(int i, const std::string& s);
    void set_column_type(int i, const SQLType& type);
    void set_column_info(int i, const SQLType& type, 
                         const std::string& name,
                         const std::string& label = std::string());
  private:
    int ncols_;
    std::string *col_labels_;
    std::string *col_names_;
    SQLType *col_types_;
};
 
class ModResultSet : public ResultSet
{
  public:
    ModResultSet(Connection *conn, int cols);
    virtual ~ModResultSet();
    
    virtual bool next() throw(SQLException);
    
    virtual SQLObject *get(int col, SQLObject *obj) const throw(SQLException);
    virtual const ResultSetMetaData *get_meta_data() const;

    /** Append a tuple.
     * \param tuple An array of character pointers. The array must be 
     *   (at least of) as big as the column number. The character 
     *   pointers are treated as null-terminated strings and are copied. 
     *   If you want to append data that contains embeded nulls, 
     *   use the other append() method. A null pointer in the 
     *   array is treated as the SQL NULL value. */
    void append(const char *const*tuple);
    
    /** Append a tuple.
     * \param tuple An array of pointers to strings. The array size must be 
     *   the same as the column number. The strings must have been 
     *   allocated with operator new, and they will be deleted 
     *   in the ModResultSet destructor. */
    void append(std::string **tuple);
    void set_meta_data(ResultSetMetaData *metadata);
  private:
    int cols_;
    int rowno_;
    std::vector<std::string **> rows_;
    ResultSetMetaData *metadata_;
};

}

#endif
