/* config.h
 * Copyright (C) 2005 Sylvain Cresto <scresto@gmail.com>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://www.nongnu.org/graveman/
 *
 */
#ifndef _G_CONFIG_H
#define _G_CONFIG_H

extern TProgRequis Glisteprogrequis[];
extern void config_init();
extern void clean_config();
extern gboolean get_config_file(gint Lmode);
extern gboolean manage_config(Tgrave *Ag, gshort Aop, GError **Aerror);
extern gint Gfifosize;
extern gchar *conf_get_string(gchar *Anom);
extern gchar *conf_get_string_def(gchar *Anom, gchar *Adefault);
extern gint conf_get_int(gchar *Anom);
extern gboolean conf_get_boolean(gchar *Anom);
extern void restore_last_used_values(Tgrave *Ahash);
extern void conf_store_value(gchar *Aentry, gchar *Avalue);
extern void conf_store_int(gchar *Aentry, gint Avalue);
extern gboolean write_conf(GError **Aerror);
extern void maj_proprietes_prog(Tgrave *Ag);
extern void remplirecombo_full (GtkComboBox *Acombo, gchar *Abasename, Tmyentry *Aentry, gboolean Adoinit, gchar *Aselvalue, gint Afiltre);
extern void remplirecombograveur(GtkComboBox *Acombo, gint Aquoi, gchar *Aselvalue);
extern void remplirelistegraveur(GtkTreeView *Aliste);
extern gboolean read_config(GError **Aerror);
extern void restore_main_window_pos(GtkWidget *Awindow1);
extern void use_last_dir(GtkFileChooser *Awidget);
extern void save_last_dir(GtkFileChooser *Awidget);
extern gboolean test_version();
extern gboolean config_append_charset(gchar *Acode, gchar *Alabel);

#endif

/*
 * vim:et:ts=8:sts=2:sw=2
 */
