/* graveman.h
 * Copyright (C) 2004, 2005 Sylvain Cresto <scresto@gmail.com>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://www.nongnu.org/graveman/
 *
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <unistd.h>
#include <signal.h>
#include <dirent.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <ctype.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <fcntl.h>
#include <math.h>
#include <glib/gprintf.h>
#include <glade/glade.h>
#include "config.h"
#include "error.h"
#include "declare.h"
#include <gdk/gdkkeysyms.h>
/* gi18b-lib.h doit etre inclue APRES config.h ! */
#include <glib/gi18n-lib.h>
#include "gtk-mng-view.h"

#define _BOOLEAN_CONF(valeur) (valeur == TRUE ? "1" : "0")

/* convertire un texte en utf8 */
#define _UTF8(texte) g_locale_to_utf8(texte, -1, NULL, NULL, NULL)
#define _FILEUTF8(texte) g_filename_to_utf8(texte, -1, NULL, NULL, NULL)
/* recupere un nom de fichier de puis de l'utf8 */
#define _FILENAME(texte) g_filename_from_utf8(texte, -1, NULL, NULL, NULL)
/* message warning + affiche errno en utf8 */
#define _WARN(texte, ...) g_warning(texte, ## __VA_ARGS__); \
                          g_warning("%s\n", g_strerror(errno))

/* non null */
#define _NN(valeur) valeur ? valeur : ""

#define _hash() g_hash_table_new(g_str_hash, g_str_equal)
#define _hash_autodestroy() g_hash_table_new_full(g_str_hash, g_str_equal, NULL, g_free)

#define _SWAP_COMBO(key, value) strcpy(key+strlen(key)-strlen("combo"), value)
                          
/* message de debug en utf8 */
#ifdef DEBUG
#define _DEB(texte, ...)  g_log(NULL, G_LOG_LEVEL_DEBUG, texte, ## __VA_ARGS__)
#else
#define _DEB(texte, ...) /* debug */
#endif

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  gtk_widget_set_name(GTK_WIDGET(widget), name); \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  gtk_widget_set_name(GTK_WIDGET(widget), name); \
  g_object_set_data (G_OBJECT (component), name, widget)

#define MAX_SPEED 54

#define TYPE_ALLWRITER 1
#define TYPE_ALL 2
#define TYPE_ISO 4
#define TYPE_DVDWRITER 8

#define TYPE_CD    1
#define TYPE_DIR   2
#define TYPE_FILE  3
#define TYPE_MP3   4
#define TYPE_IMAGEBOOT 5

#define SEARCH_LECTEUR  1
#define SEARCH_PROG     2
#define WRITE_CONFIG    4
#define UPDATE_SIZE     8
#define UPDATE_SAVEONEXIT_VALUE 16
#define SEARCH_CHARSETS 32
#define CONF_INIT_DEFAULT    64

#define MENU_NEW        1
#define MENU_UPDATE     2
#define COMBO_UPDATE    4

/* gestion CD de boot */
#define CDBOOT_NONE     0
#define CDBOOT_IMAGE    1

#define _REMPLISSAGE_VALUE(Ag, Alist, Asize, Amaxsize, Aprogressbar) \
    { \
      gchar *Lprefix = (!strcmp(glade_get_widget_name(GTK_WIDGET(Alist)), "LISTEDATA") ? "data" : "dvddata"); \
      Asize = (guint64 *)sc_grave_get_datav (Ag, "%ssize", Lprefix); \
      Amaxsize = (guint64 *)sc_grave_get_datav (Ag, "%smaxsize", Lprefix); \
      Aprogressbar = GTK_PROGRESS_BAR(sc_grave_get_widgetv(Ag, "%ssizebar", Lprefix)); \
    }

#define remplirecombo(Acombo, Abasename, Aentry, Adoinit, Aselvalue) remplirecombo_full(Acombo, Abasename, Aentry, Adoinit, Aselvalue, -1)

#define POURCENT(total, val) (total != 0 ? ((1.0/total) * val) : (-1))

#ifdef ENABLE_MP3
  #define MP3 ".mp3"
#endif
#ifdef ENABLE_OGG
  #define OGG ".ogg"
#endif
#ifdef ENABLE_FLAC
  #define FLAC ".flac"
#endif
#define WAV ".wav"

#define PLS ".pls"
#define M3U ".m3u"

#define _BUF_SIZE 1024
#ifndef MAXPATHLEN
  #define MAXPATHLEN 2048
#endif

/* operation a faire sur une entre de la configuration */
#define CONF_SAVEALWAYS 0
#define CONF_SAVEONEXIT 1
#define CONF_COMBO      16
#define CONF_SPIN       32
#define CONF_CHECK      64
#define CONF_PERSIST    128
#define CONF_DEVICE     256

/* type des devices */
#define _OTHER_DEVICE 0
#define _READ_CDR     1
#define _WRITE_CDR    2
#define _WRITE_CDRW   4
#define _WRITE_DUMMY  8
#define _READ_DVD     16
#define _WRITE_DVD    32
#define _BURN_FREE    64
#define DRIVE_READER(drive) (drive && (drive->type & _READ_CDR))
#define DRIVE_WRITER(drive) (drive && (drive->type & _WRITE_CDR))
#define DRIVE_DVDREADER(drive) (drive && (drive->type & _READ_DVD))
#define DRIVE_DVDWRITER(drive) (drive && (drive->type & _WRITE_DVD))
#define DRIVE_BURN_FREE(drive) (drive && (drive->type & _BURN_FREE))

 #define DRIVE_CDRW_WRITER(drive) (drive && (drive->type & _WRITE_CDRW))
#define DRIVE_ICONE(drive)  (drive->type & _WRITE_DVD ? GDVDRWpetiteIcone : \
                            (drive->type & _WRITE_CDR ? GCDRWpetiteIcone : \
                            (drive->type & _READ_DVD ? GDVDpetiteIcone : GCDpetiteIcone)))

#define DRIVE_DEV(drive) ((gchar *)g_slist_nth_data(drive->dev, drive->actuperiph))
  
/* type des medias */
#define _MEDIA_NONE       0
#define _MEDIA_CD         1
#define _MEDIA_CDR        2
#define _MEDIA_CDRW       4
#define _MEDIA_DVD        8
#define _MEDIA_DVDR       16
#define _MEDIA_DVDRew     32
#define _MEDIA_DVDPRW     64
#define _MEDIA_DVDMRW     128
#define _MEDIA_BLANK      256
#define _MEDIA_NOBLANK    512
#define _MEDIA_APPENDABLE 1024
#define _MEDIA_BLANKORAPPENDABLE  2048
#define _MEDIA_IS_CD (_MEDIA_CD+_MEDIA_CDR+_MEDIA_CDRW)
#define _MEDIA_IS_DVD (_MEDIA_DVD+_MEDIA_DVDR+_MEDIA_DVDRew+_MEDIA_DVDPRW+_MEDIA_DVDMRW)
#define _MEDIA_CMP_CD(DE, A) (((DE & 1) && (A & 1)) || ((DE & 2) && (A & 2)) || ((DE & 4) && (A & 4))) 
#define _MEDIA_CMP_DVD(DE, A) (((DE & 8) && (A & 8)) || ((DE & 16) && (A & 16)) || ((DE & 32) && (A & 32)) || ((DE & 64) && (A & 64))) 
  
/* includes graveman ! */

#include "audio.h"
#include "callbacks.h"
#include "cdrdao.h"
#include "cdrecord.h"
#include "charset.h"
#include "config_file.h"
#include "data.h"
#include "declare.h"
#include "dvdrwformat.h"
#include "dvdrwmediainfo.h"
#include "error.h"
#include "flac.h"
#include "growisofs.h"
#include "images.h"
#include "interface.h"
#include "m3u.h"
#include "main.h"
#include "matos.h"
#include "mp3.h"
#include "mkisofs.h"
#include "ogg.h"
#include "param.h"
#include "pls.h"
#include "properties.h"
#include "readcd.h"
#include "sox.h"
#include "support.h"
#include "tools.h"
#include "wav.h"

/*
 * vim:et:ts=8:sts=2:sw=2
 */
