/* guile-simplesql.h: Guile SimpleSQL - the basic functions header file

   Copyright (C) 2002 David Lambert <d.j.lambert@sms.ed.ac.uk>
   Copyright (C) 1999 forcer <forcer@mindless.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
   USA  */
    

#ifndef GUILE_SIMPLESQL_H
#define GUILE_SIMPLESQL_H
    
/* Define to get strptime.  */
#define _GNU_SOURCE 

#include "config.h"
#include <libguile.h>

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#if ! HAVE_DECL_STRPTIME
extern char *strptime ();
#endif

#if ((SCM_MAJOR_VERSION == 1) && (SCM_MINOR_VERSION < 7))
#define SCM_VECTOR_SET(x, idx, val) (((SCM*)SCM_CELL_WORD_1 (x))[(idx)] = (val))
#define scm_i_mem2number(mem, len, radix) scm_istring2number(mem, len, radix)
#endif

typedef void *(*sql_open_func)(const char *, const char *, int, const char *,
			       const char *, const char *, SCM *);
typedef SCM (*sql_query_func)(void *db, const char *query, int querylen);
typedef void (*sql_close_func)(void *db);

int sql_register_api(const char *api, sql_open_func open,
                     sql_query_func query, sql_close_func close);

SCM sq_latin1_string(char *str, int len);
SCM sq_binary_vector(char *str, int len);

SCM sql_db_p(SCM obj);
SCM sql_open(SCM api, SCM dbname, SCM host, SCM user, SCM pass);
SCM sql_query(SCM db, SCM query);
SCM sql_close(SCM db);

SCM sql_escape(SCM str);

SCM _simplesql_filltime (struct tm *, int, char *);

#endif
