/*
 * happydigger - program for cataloging archaeological finds
 * Copyright (C) 2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <string.h>
#include <sqlite.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "preferences.h"

gboolean im1, im2;

extern GtkWidget *window;
extern sqlite *db;
extern gint max;
extern statestype state;

/* IMAGE BUTTONS */
void
on_image1button_clicked (GtkButton *button, gpointer user_data)
{
	GtkWidget *fileselection, *image1entry;
	gchar *image1;
	
	fileselection = create_fileselection ();

	im1 = TRUE;
	im2 = FALSE;

	image1entry = lookup_widget (window, "image1entry");
	image1 = gtk_editable_get_chars (GTK_EDITABLE(image1entry), 0, -1);	
	if (strlen (image1) > 0)
		gtk_file_selection_set_filename (GTK_FILE_SELECTION(fileselection), image1);
	else
		gtk_file_selection_set_filename (GTK_FILE_SELECTION(fileselection), state.loaddir);
	g_free (image1);

	gtk_widget_set_sensitive (window, 0);
	gtk_widget_show (fileselection);
}

void
on_image2button_clicked (GtkButton *button, gpointer user_data)
{
	GtkWidget *fileselection, *image2entry;
	gchar *image2;

	fileselection = create_fileselection ();

	im1 = FALSE;
	im2 = TRUE;

	image2entry = lookup_widget (window, "image2entry");
	image2 = gtk_editable_get_chars (GTK_EDITABLE(image2entry), 0, -1);
	if (strlen (image2) > 0)
		gtk_file_selection_set_filename (GTK_FILE_SELECTION(fileselection), image2);
	else
	{
		gtk_file_selection_set_filename (GTK_FILE_SELECTION(fileselection), state.loaddir);
	}
	g_free (image2);

	gtk_widget_set_sensitive (window, 0);
	gtk_widget_show (fileselection);
}

gboolean
exit_program                           (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	sqlite_close (db);
	savepreferences ();
	g_free (state.loaddir);
	gtk_main_quit ();
  return FALSE;
}


gboolean
on_listwindow_delete_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	gtk_widget_set_sensitive (window, 1);
	return FALSE;
}

