#ifndef _DBUTIL_H_
#define _DBUTIL_H_

#include <assert.h>
#include <stdarg.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#define BUF_SZ 1000

//output debug messages without invoking malloc()
void dbprintf(const char *fmt, ...) {
#ifdef DEBUG
	static int debug_log = open("debug.log", O_CREAT | O_TRUNC | O_WRONLY, S_IRUSR | S_IWUSR);
	if (debug_log < 0) {
		abort();
	}

	char buf[BUF_SZ];
	va_list ap;
	va_start(ap, fmt);

	int n = vsnprintf(buf, BUF_SZ, fmt, ap);
	if (n < 0 || n >= BUF_SZ) {
		abort();
	}

	write(debug_log, buf, n);
#endif
}

#undef assert
void __assert_fail (__const char *__assertion, __const char *__file,
					unsigned int __line, __const char *__function) throw() {
	dbprintf("ASSERTION FAILED!\n[%s:%d] in function %s:\n(%s) was false!\n", __file, __line, __function, __assertion);
	abort();
}
#define __ASSERT_FUNCTION __PRETTY_FUNCTION__
#define assert(expr) \
  (__ASSERT_VOID_CAST ((expr) ? 0 :					      \
		       (__assert_fail (__STRING(expr), __FILE__, __LINE__,    \
				       __ASSERT_FUNCTION), 0)))

#endif
