// histogram.c
// -----------
//		Copyright 1988 D.C. Lindsay at Carnegie Mellon University
//
// Implementation of class: see histogram.h for specs.

#include "machine.h"
#include "statistics.h"
#include "histogram.h"
#include <stdlib.h>
#include <stream.h>

histogramclass::histogramclass()
{
	eventcount = 0;		// table's type  has initter
}
/************************************/
void histogramclass::reset()
{
	for( int i = 0; i < HIST_LEN; i++ ) table[i].reset();
	eventcount = 0;
}
/************************************/
void histogramclass::note( int value, int index )
{
	if(( index < 0) || (index >= HIST_LEN )) {
		cout << "ERROR in histogram::note - out of range.\n";
		exit(1);
	}
	table[ index ].note( value );
	eventcount++;
}
/************************************/

void histogramclass::print( char *label )
{
	if( eventcount == 0 ) return;
	cout << label << " on " << eventcount << " events.\n";
	for( int i = 0; i < HIST_LEN; i++ ) {
		if( table[i].eventcount ) {
			cout << " bucket " << i;
			table[i].print( ": " );
			cout << "\n";
		}
	}	
}
