/* $Log: types.c,v $
/* Revision 1.1  2003/10/15 15:59:00  emery
/* Initial check-in.
/*
/* Revision 1.1  2001/08/23 17:20:26  emery
/* The big fig newton.
/*
/* Revision 1.1.1.1  2001/06/28 19:48:19  dgay
/* Initial import of RC tests
/*
 * Revision 1.14  1997/08/04 22:17:22  arda
 * Fix mudlle so that it compiles with g++
 *
 * Revision 1.13  1996/08/17 16:38:34  arda
 * .
 *
 * Revision 1.12  1996/07/04 00:31:22  arda
 * Simple stuff, mostly.
 *
 * Revision 1.11  1996/02/09 14:59:02  arda
 * Security holes
 *
 * Revision 1.10  1994/10/09  06:43:08  arda
 * Libraries
 * Type inference
 * Many minor improvements
 *
 * Revision 1.9  1994/08/29  13:17:35  arda
 * Contagious immutability.
 * Global array of values instead of variables.
 * Direct recursion.
 *
 * Revision 1.8  1994/02/11  09:59:21  dgay
 * Owl: -Wall
 *      new shared string handling
 *      configuration file
 *
 * Revision 1.7  1993/07/25  10:58:38  un_mec
 * Owl: General schema for private types defined.
 *
 * Revision 1.6  1993/04/22  18:58:57  un_autre
 * (MD) & Owl. Bug fixes. /player fixes. EVER_WHINER flag. saving_spells adjusted.
 *
 * Revision 1.5  1993/03/29  09:24:47  un_mec
 * Owl: Changed descriptor I/O
 *      New interpreter / compiler structure.
 *
 * Revision 1.4  1993/03/17  12:50:06  dgay
 * Fixed GC of help strings in code blocks.
 * Added security features.
 *
 * Revision 1.3  1993/03/14  16:15:11  dgay
 * Optimised stack & gc ops.
 *
 * Revision 1.3  1993/01/08  23:57:10  un_mec
 * Owl: Allow characters and objects to appear in mudlle.
 *
 * Revision 1.2  1992/12/30  14:10:58  un_mec
 * Owl:
 * Several changes:
 * - Variables don't have separate value & function cells, instead their are
 *   now 2 types: type_function & type_variable.
 * - print_value: New types (list, vector), printing rationalised.
 * - New type: list (Lisp style pair)
 * - lexer.l: Debug read_from_string
 * - debug_level & DEBUG macro provided to help debugging.
 *
 * Revision 1.1  1992/12/27  21:41:42  un_mec
 * Mudlle source, without any Mume extensions.
 *
 */

static char rcsid[] = "$Id: types.c,v 1.1 2003/10/15 15:59:00 emery Exp $";

#include <string.h>
#include "mudlle.h"
#include "types.h"
#include "alloc.h"

struct closure *unsafe_alloc_closure(ulong nb_variables)
{
  struct closure *newp = (struct closure *)unsafe_allocate_record(type_closure, nb_variables + 1);

  newp->o.flags |= OBJ_READONLY;

  return newp;
}

struct closure *alloc_closure0(struct code *code)
{
  struct closure *newp;
  struct gcpro gcpro1;

  GCCHECK(code);
  GCPRO1(code);
  newp = (struct closure *)allocate_record(type_closure, 1);
  newp->code = code;
  newp->o.flags |= OBJ_READONLY;
  UNGCPRO();

  return newp;
}

struct string *alloc_string(const char *s)
{
  struct string *newp;

  if (!s) s = "(null)";
  newp = (struct string *)allocate_string(type_string, strlen(s) + 1);

  strcpy(newp->str, s);

  return newp;
}

struct string *safe_alloc_string(const char *s)
{
  return alloc_string(s ? s : "");
}

struct variable *alloc_variable(value val)
{
  struct variable *newp;
  struct gcpro gcpro1;

  GCCHECK(val);
  GCPRO1(val);
  newp = (struct variable *)unsafe_allocate_record(type_variable, 1);
  newp->vvalue = val;
  UNGCPRO();

  return newp;
}

struct symbol *alloc_symbol(struct string *name, value data)
{
  struct gcpro gcpro1, gcpro2;
  struct symbol *newp;

  GCCHECK(name);
  GCCHECK(data);
  GCPRO2(name, data);
  newp = (struct symbol *)unsafe_allocate_record(type_symbol, 2);
  newp->name = name;
  newp->data = data;
  UNGCPRO();

  return newp;
}

struct vector *alloc_vector(ulong size)
{
  struct vector *newp = (struct vector *)allocate_record(type_vector, size);

  return newp;
}

struct list *alloc_list(value car, value cdr)
{
  struct gcpro gcpro1, gcpro2;
  struct list *newp;

  GCCHECK(car);
  GCCHECK(cdr);
  GCPRO2(car, cdr);
  newp = (struct list *)unsafe_allocate_record(type_pair, 2);
  newp->car = car;
  newp->cdr = cdr;
  UNGCPRO();

  return newp;
}

struct character *alloc_character(struct char_data *ch)
{
  return (struct character *)allocate_temp(type_character, ch);
}

struct object *alloc_object(struct obj_data *obj)
{
  return (struct object *)allocate_temp(type_object, obj);
}

struct primitive *alloc_primitive(ulong nb, struct primitive_ext *op)
{
  return (struct primitive *)allocate_permanent(type_primitive, nb, op);
}

struct primitive *alloc_secure(ulong nb, struct primitive_ext *op)
{
  return (struct primitive *)allocate_permanent(type_secure, nb, op);
}

struct grecord *alloc_private(int id, ulong size)
{
  struct grecord *p = allocate_record(type_private, size + 1);

  p->data[0] = makeint(id);
  return p;
}
