use strict;
use English;

my $numiterations = 6;

# Benchmarks and their parameters

my $gzipdir = "164.gzip";
my $gzip = "gzip_peak.none input.compressed 2";
my $vprdir = "175.vpr";
my $vpr = "vpr_peak.none net.in arch.in place.out dum.out -nodisp -place_only -init_t 5 -exit_t 0.005 -alpha_t 0.9412 -inner_num 2";
my $gccdir = "176.gcc";
my $gcc = "cc1_peak.none scilab.i -o /tmp/scilab.s";
my $mcfdir = "181.mcf";
my $mcf = "mcf_peak.none inp.in";
my $craftydir = "186.crafty";
my $crafty = "crafty_peak.none";
my $eondir = "252.eon";
my $eon = "eon_peak.none chair.control.kajiya chair.camera chair.surfaces chair.kajiya.ppm ppm pixels_out.kajiya";
my $perlbmkdir = "253.perlbmk";
my $perlbmk = "perlbmk_peak.none -I. -I./lib test.pl";

# Notice that perlbmk is *not* using perfect.pl! 

my $gapdir = "254.gap";
my $gap = "gap_peak.none -l ./ -q -m 64M";
my $vortexdir = "255.vortex";
my $vortex = "vortex_peak.none lendian.raw";
my $bzip2dir = "256.bzip2";
my $bzip2 = "bzip2_peak.none input.random 2";

my $espressodir = "espresso";
my $espresso = "espresso -t Input/largest.espresso";

my $cfracdir = "cfrac";
my $cfrac = "cfrac 41757646344123832613190542166099121";

my $roboopdir = "roboop";
my $roboop = "bench";


my $parserdir = "197.parser";
my $parser = "parser 2.1.dict -batch < test.in";

my $lindsaydir = "lindsay";
my $lindsay = "sim < Input/script.mine";

my $p2cdir = "p2c";
my $p2c = "p2c -v < Input/mf.p";

my $boxedsimdir = "boxed-sim";
my $boxedsim = "boxed -n 15 -s 1"; # Note: larger than in custom paper.

my $mudlledir = "mudlle";
my $mudlle = "mudlle < time.mud";

my @dirs = ($mudlledir);
my @benchmarks = ($mudlle);

#my @dirs = ($parserdir, $gzipdir, $vprdir, $gccdir, $mcfdir, $craftydir, $eondir, $perlbmkdir, $gapdir, $vortexdir, $bzip2dir, $espressodir, $cfracdir, $lindsaydir, $roboopdir, $p2cdir, $mudlledir, $boxedsimdir);
#my @benchmarks = ($parser, $gzip, $vpr, $gcc, $mcf, $crafty, $eon, $perlbmk, $gap, $vortex, $bzip2, $espresso, $cfrac, $lindsay, $roboop, $p2c, $mudlle, $boxedsim);

#my @dirs = ($espressodir, $cfracdir, $lindsaydir, $roboopdir, $p2cdir);
#my @benchmarks = ($espresso, $cfrac, $lindsay, $roboop, $p2c);

my $numbenchmarks = int @dirs;

my $bench;

my %ld_command;

$ld_command{"baseline"} = "";
$ld_command{"ptmalloc"} = "setenv LD_PRELOAD /usr/fit/tmp2/emery/heaplayers/allocators/ptmalloc/libptmalloc.so:/usr/lib/libdl.so";
$ld_command{"ptmalloc2"} = "setenv LD_PRELOAD /usr/fit/tmp2/emery/heaplayers/allocators/ptmalloc2/libptmalloc.so:/usr/lib/libdl.so";
$ld_command{"mtmalloc8"} = "setenv LD_PRELOAD /usr/fit/tmp2/emery/heaplayers/allocators/libmtmalloc8.so:/usr/lib/libdl.so";
$ld_command{"mtmalloc9"} = "setenv LD_PRELOAD /usr/fit/tmp2/emery/heaplayers/allocators/libmtmalloc9.so:/usr/lib/libdl.so";

$ld_command{"hoard"} = "setenv LD_PRELOAD /usr/fit/tmp2/emery/heaplayers/allocators/hoard/libhoard.so:/usr/lib/libdl.so";
$ld_command{"hoard-nolockopt"} = "setenv LD_PRELOAD /usr/fit/tmp2/emery/heaplayers/allocators/hoard/libhoard-nolockopt.so:/usr/lib/libdl.so";
$ld_command{"hoard-noclearopt"} = "setenv LD_PRELOAD /usr/fit/tmp2/emery/heaplayers/allocators/hoard/libhoard-noclearopt.so:/usr/lib/libdl.so";
$ld_command{"hoard-noreaps"} = "setenv LD_PRELOAD /usr/fit/tmp2/emery/heaplayers/allocators/hoard/libhoard-noreaps.so:/usr/lib/libdl.so";
$ld_command{"hoard-nada"} = "setenv LD_PRELOAD /usr/fit/tmp2/emery/heaplayers/allocators/hoard/libhoard-nada.so:/usr/lib/libdl.so";

#foreach $bench ("mtmalloc8","mtmalloc9","hoard-noreaps", "hoard-nada") {
foreach $bench ("baseline","hoard","ptmalloc","ptmalloc2","mtmalloc8","mtmalloc9","hoard-noclearopt", "hoard-nolockopt", "hoard-noreaps", "hoard-nada") {
    #open F, ">foo";
    open F, "|tcsh";

    for (my $i = 0; $i < $numbenchmarks; $i++) {
	print $benchmarks[$i], "\n";
	print F "cd ", $dirs[$i], "; rm -f timings-$bench; touch timings-$bench\n";
	print F $ld_command{$bench}, "\n";
	print "bench = $bench\n";
	for (my $j = 0; $j < $numiterations; $j++) {
	    my $cmdstring = "../hirestimer \"./" . $benchmarks[$i] . " >> timings-$bench\" >>& timings-$bench";
	    print F "$cmdstring\n";
	    #print $cmdstring, "\n";
	}
	print F "cd ..\n";
    }
    close F;
}

