#include "tokenmap.h"

map<string,TokenMap::Token> TokenMap::m_tokenMap;
TokenMap::Token TokenMap::m_nextToken=1000;

void TokenMap::Insert(const string& a,Token b){
  m_tokenMap[a]=b;
}

void TokenMap::Init(){
  Insert("@DEF",DEF1);
  Insert("DEF",DEF2);
  Insert("/@DEF",SLASHDEF1);
  Insert("/DEF",SLASHDEF2);
  Insert("@IF",IF1);
  Insert("IF",IF2);
  Insert("@ELSE",ELSE1);
  Insert("ELSE",ELSE2);
  Insert("/@IF",SLASHIF1);
  Insert("/IF",SLASHIF2);
  Insert("@ELSEIF",ELSEIF);
  Insert("@COMMENT",COMMENT);
  Insert("/@COMMENT",SLASHCOMMENT);
  Insert("FOR",FOR);
  Insert("A",A);
  Insert("ABBR",ABBR);
  Insert("ACRONYM",ACRONYM);
  Insert("ADDRESS",ADDRESS);
  Insert("APPLET",APPLET);
  Insert("B",B);
  Insert("BDO",BDO);
  Insert("BIG",BIG);
  Insert("BLOCKQUOTE",BLOCKQUOTE);
  Insert("BODY",BODY);
  Insert("/BODY",SLASHBODY);
  Insert("BR",BR);
  Insert("BUTTON",BUTTON);
  Insert("CAPTION",CAPTION);
  Insert("CENTER",CENTER);
  Insert("/CENTER",SLASHCENTER);
  Insert("CITE",CITE);
  Insert("CODE",CODE);
  Insert("COLGROUP",COLGROUP);
  Insert("DD",DD);
  Insert("/DD",SLASHDD);
  Insert("DEL",DEL);
  Insert("DFN",DFN);
  Insert("DIR",DIR);
  Insert("DIV",DIV);
  Insert("/DIV",SLASHDIV);
  Insert("DL",DL);
  Insert("/DL",SLASHDL);
  Insert("DT",DT);
  Insert("/DT",SLASHDT);
  Insert("EM",EM);
  Insert("FIELDSET",FIELDSET);
  Insert("FONT",FONT);
  Insert("FORM",FORM);
  Insert("FRAMESET",FRAMESET);
  Insert("H1",H1);
  Insert("/H1",SLASHH1);
  Insert("H2",H2);
  Insert("/H2",SLASHH2);
  Insert("H3",H3);
  Insert("/H3",SLASHH3);
  Insert("H4",H4);
  Insert("/H4",SLASHH4);
  Insert("H5",H5);
  Insert("/H5",SLASHH5);
  Insert("H6",H6);
  Insert("/H6",SLASHH6);
  Insert("HEAD",HEAD);
  Insert("/HEAD",SLASHHEAD);
  Insert("HR",HR);
  Insert("HTML",HTML);
  Insert("/HTML",SLASHHTML);
  Insert("I",I);
  Insert("IFRAME",IFRAME);
  Insert("INS",INS);
  Insert("KBD",KBD);
  Insert("LABEL",LABEL);
  Insert("LEGEND",LEGEND);
  Insert("LI",LI);
  Insert("/LI",SLASHLI);
  Insert("LINK",LINK);
  Insert("MAP",MAP);
  Insert("MENU",MENU);
  Insert("/MENU",SLASHMENU);
  Insert("NOFRAMES",NOFRAMES);
  Insert("NOSCRIPT",NOSCRIPT);
  Insert("OBJECT",OBJECT);
  Insert("OL",OL);
  Insert("/OL",SLASHOL);
  Insert("OPTGROUP",OPTGROUP);
  Insert("OPTION",OPTION);
  Insert("P",P);
  Insert("/P",SLASHP);
  Insert("PRE",PRE);
  Insert("Q",Q);
  Insert("S",S);
  Insert("SAMP",SAMP);
  Insert("SCRIPT",SCRIPT);
  Insert("SELECT",SELECT);
  Insert("SMALL",SMALL);
  Insert("SPAN",SPAN);
  Insert("STRIKE",STRIKE);
  Insert("STRONG",STRONG);
  Insert("STYLE",STYLE);
  Insert("SUB",SUB);
  Insert("SUP",SUP);
  Insert("TABLE",TABLE);
  Insert("/TABLE",SLASHTABLE);
  Insert("TBODY",TBODY);
  Insert("TD",TD);
  Insert("/TD",SLASHTD);
  Insert("TEXTAREA",TEXTAREA);
  Insert("TFOOT",TFOOT);
  Insert("TH",TH);
  Insert("THEAD",THEAD);
  Insert("TITLE",TITLE);
  Insert("/TITLE",SLASHTITLE);
  Insert("TR",TR);
  Insert("/TR",SLASHTR);
  Insert("TT",TT);
  Insert("U",U);
  Insert("UL",UL);
  Insert("/UL",SLASHUL);
  Insert("VAR",VAR);
  Insert("!DOCTYPE",PLINGDOCTYPE);
}
