<?php
// File           acc_view.php / ibWebAdmin
// Purpose        html sequence for the views-panel in accessories.php
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <03/01/13 17:47:05 lb>
//
// $Id: acc_view.php,v 1.6 2003/10/05 15:49:03 lbrueckner Exp $

if (isset($s_confirmations['view'])) {
    $subject = 'view';
    include('panels/confirm.php');
}

elseif (isset($view_add_flag)) {

?>
<form method="post" action="<?php echo $HTTP_SERVER_VARS['PHP_SELF']; ?>" name="acc_view_form">
<?php hidden_session_field(); ?>
<?php echo view_definition($acc_strings['CreateView'], $s_viewdefs); ?>
<input type="submit" name="acc_view_create_cancel" value="<?php echo $button_strings['Cancel']; ?>">&nbsp;&nbsp;&nbsp;
<input type="reset" name="acc_view_create_clear" value="<?php echo $button_strings['Reset']; ?>">&nbsp;&nbsp;&nbsp;
<input type="submit" name="acc_view_create_doit" value="<?php echo $button_strings['Create']; ?>">
</form>
<?php

} elseif (isset($view_mod_flag)) {

?>
<form method="post" action="<?php echo $HTTP_SERVER_VARS['PHP_SELF']; ?>" name="acc_modview_form">
<?php hidden_session_field(); ?>
<?php echo view_definition(sprintf($acc_strings['ModView'], $s_viewdefs['name']), $viewdefs); ?>
<input type="submit" name="acc_modview_cancel" value="<?php echo $button_strings['Cancel']; ?>">&nbsp;&nbsp;&nbsp;
<input type="reset" name="acc_view_mod_clear" value="<?php echo $button_strings['Reset']; ?>">&nbsp;&nbsp;&nbsp;
<input type="submit" name="acc_modview_doit" value="<?php echo $button_strings['Modify']; ?>">
</form>

<?php

} elseif ($s_connected == TRUE) {
    if (is_array($s_tables)) {
        $vcnt = 0;
        foreach($s_tables as $viewname => $properties) {
            if ($properties['is_view'] == FALSE) {
                continue;
            }
            $vcnt++;

            $title    = ($s_views_counts == 'yes'  &&  isset($properties['count'])) ? $viewname.'&nbsp;['.$properties['count'].']' : $viewname;
            $fold_url = fold_detail_url('view', $properties['status'], $viewname, $title);

            echo '<div id="'.'v_'.$viewname."\" style=\"border-bottom: 1px solid black; margin: 1px;\">\n";

            if ($properties['status'] == 'open') {

                echo get_opened_view($viewname, $title, $fold_url);
            }
            else {   // $properties['status'] == 'close'

                echo get_closed_detail($title, $fold_url);
            }

            echo "</div>\n";

        }    // foreach $s_tables
    }
    echo '<form method="post" action="'.$HTTP_SERVER_VARS['PHP_SELF']."\" name=\"acc_view_form\">\n";

    if ($vcnt > 0) {
?>
<input type="checkbox" name="acc_show_counts" value="yes"<?php if ($s_views_counts == 'yes') echo ' checked'; ?>>
<?php echo $tb_strings['DispCounts']; ?>&nbsp;&nbsp;&nbsp;
<input type="submit" name="acc_show_reload" value="<?php echo $button_strings['Reload']; ?>">&nbsp;&nbsp;&nbsp;
<?php 
     if ($vcnt > 1) {
         echo '<input type="submit" name="acc_view_open" value="'.$button_strings['OpenAll']."\">&nbsp;&nbsp;&nbsp;\n";
         echo '<input type="submit" name="acc_view_close" value="'.$button_strings['CloseAll']."\">\n";
         
        }
        echo "<br><br>\n";
    }
    hidden_session_field();
?>
<table border cellpadding="3" cellspacing="0">
<tr>
  <th colspan="2" align="left"><?php echo $acc_strings['CreateView']; ?></th>
  <td><input type="submit" name="acc_view_create" value="<?php echo $button_strings['Create']; ?>"></td>
</tr>
<tr>
  <td>
    <b><?php echo $acc_strings['SelViewMod']; ?></b>
  </td>
  <td>
     <select name="acc_modview_name">
        <?php build_table_options('', array('owner', 'views')); ?>
     </select>
  </td>
  <td align="left">
    <input type="submit" name="acc_view_mod" value="<?php echo $button_strings['Modify']; ?>">
  </td>
</tr>
<tr>
  <td>
    <b><?php echo $acc_strings['SelViewDel']; ?></b>
  </td>
  <td>
     <select name="acc_delview_name">
        <?php build_table_options('', array('owner', 'views')); ?>
     </select>
  </td>
  <td align="left">
    <input type="submit" name="acc_view_del" value="<?php echo $button_strings['Delete']; ?>">
  </td>
</tr>
</table>
</form>
<?php

}

?>
