<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

include("../../include/irm.inc");
include("../../include/reports.inc.php");
require_once 'lib/Config.php';
require_once 'include/i18n.php';

AuthCheck("normal");
PRINT "<html><body bgcolor=#ffffff>";

function getTracking($startdate, $enddate)
{
	$DB = Config::Database();
	$startdate = $DB->getTextValue($startdate);
	$enddate = $DB->getTextValue($enddate);
	$query = "SELECT ID FROM tracking where (closedate > $startdate)
					AND (closedate < $enddate)";
	return $DB->getCol($query);
}

function getTrackingByUser($startdate, $enddate, $username)
{
	$DB = Config::Database();
	$username = $DB->getTextValue($username);
	$startdate = $DB->getTextValue($startdate);
	$enddate = $DB->getTextValue($enddate);
	$query = "SELECT ID FROM tracking WHERE (assign = $username)
				AND (closedate > $startdate)
				AND (closedate < $enddate)";
	return $DB->getCol($query);
}

if (@$go == "yes") 
{
	commonHeader(_("Tracking") . " - " . _("Report Results"));
	# 1. Get some number data
	$startdate = $startyear . "-" . $startmonth . "-" . $startday;
	$enddate = $endyear . "-" . $endmonth . "-" . $endday;

	$tracking = getTracking($startdate, $enddate);
	$number_of_tracking = count($tracking);
	
	# 2. Spew out the data in a table
	
	PRINT "<table border=0 width=100%>";
	PRINT "<tr><td>";
	__("Number of Tracking:");
	PRINT "</td><td>$number_of_tracking</td></tr>";	

	PRINT "<tr><td colspan=2><b>";
	__("Tracking by user:");
	PRINT "</b></td></tr>";

	# 3. Get some more number data (operating systems per computer)

	$query = "SELECT name FROM users WHERE type='tech' OR type='admin' ORDER BY name";
	$names = $DB->getCol($query);
	
	foreach ($names as $username)
	{
		$usertracking = getTrackingByUser($startdate, $enddate, $username);
		$numRows2 = count($usertracking);
		PRINT "<tr><td>$username</td><td>$numRows2</td></tr>";
	}
	PRINT "</table>";
}
else 
{
	commonHeader(_("Tracking") . " - " . _("Report"));

	__("Welcome to the Default Tracking Report! This report is designed
	    to inform you of the tracking requests that have been completed
	    or marked old during the time you specify.");
	echo '<p>'._("To generate the report: select a start date, an end
		      date, and click on the go button.");
?>

	<form action="<?php echo Config::AbsLoc('users/reports/tracking.php'); ?>">

	<?php # FIXME this is simply awful!!!! 
	__("Select a start date:"); ?>
	<select name=startyear>
<?php
	for ($i = date('Y'); $i > 1998; $i--)
	{
		echo "\t<OPTION VALUE=\"$i\">$i</OPTION>\n";
	}
?>
	</select>
	-
	<select name=startmonth>
	<OPTION VALUE="01"><?php __("January")?></OPTION>
	<OPTION VALUE="02"><?php __("February")?></OPTION>
	<OPTION VALUE="03"><?php __("March")?></OPTION>
	<OPTION VALUE="04"><?php __("April")?></OPTION>
	<OPTION VALUE="05"><?php __("May")?></OPTION>
	<OPTION VALUE="06"><?php __("June")?></OPTION>
	<OPTION VALUE="07"><?php __("July")?></OPTION>
	<OPTION VALUE="08"><?php __("August")?></OPTION>
	<OPTION VALUE="09"><?php __("September")?></OPTION>
	<OPTION VALUE="10"><?php __("October")?></OPTION>
	<OPTION VALUE="11"><?php __("November")?></OPTION>
	<OPTION VALUE="12"><?php __("December")?></OPTION>
	</select>
	-
	<select name=startday>
	<OPTION VALUE="01">01</OPTION>
	<OPTION VALUE="02">02</OPTION>
	<OPTION VALUE="03">03</OPTION>
	<OPTION VALUE="04">04</OPTION>
	<OPTION VALUE="05">05</OPTION>
	<OPTION VALUE="06">06</OPTION>
	<OPTION VALUE="07">07</OPTION>
	<OPTION VALUE="08">08</OPTION>
	<OPTION VALUE="09">09</OPTION>
	<OPTION VALUE="10">10</OPTION>
	<OPTION VALUE="11">11</OPTION>
	<OPTION VALUE="12">12</OPTION>
	<OPTION VALUE="13">13</OPTION>
	<OPTION VALUE="14">14</OPTION>
	<OPTION VALUE="15">15</OPTION>
	<OPTION VALUE="16">16</OPTION>
	<OPTION VALUE="17">17</OPTION>
	<OPTION VALUE="18">18</OPTION>
	<OPTION VALUE="19">19</OPTION>
	<OPTION VALUE="20">20</OPTION>
	<OPTION VALUE="21">21</OPTION>
	<OPTION VALUE="22">22</OPTION>
	<OPTION VALUE="23">23</OPTION>
	<OPTION VALUE="24">24</OPTION>
	<OPTION VALUE="25">25</OPTION>
	<OPTION VALUE="26">26</OPTION>
	<OPTION VALUE="27">27</OPTION>
	<OPTION VALUE="28">28</OPTION>
	<OPTION VALUE="29">29</OPTION>
	<OPTION VALUE="30">30</OPTION>
	<OPTION VALUE="31">31</OPTION>
	</select>
	<BR>
	<?php __("Select an end date:") ?>;
	<select name=endyear>
<?php
	for ($i = date('Y'); $i > 1998; $i--)
	{
		echo "\t<OPTION VALUE=\"$i\">$i</OPTION>\n";
	}
?>
	</select>
	-
	<select name=endmonth>
	<OPTION VALUE="01"><?php __("January")?></OPTION>
	<OPTION VALUE="02"><?php __("February")?></OPTION>
	<OPTION VALUE="03"><?php __("March")?></OPTION>
	<OPTION VALUE="04"><?php __("April")?></OPTION>
	<OPTION VALUE="05"><?php __("May")?></OPTION>
	<OPTION VALUE="06"><?php __("June")?></OPTION>
	<OPTION VALUE="07"><?php __("July")?></OPTION>
	<OPTION VALUE="08"><?php __("August")?></OPTION>
	<OPTION VALUE="09"><?php __("September")?></OPTION>
	<OPTION VALUE="10"><?php __("October")?></OPTION>
	<OPTION VALUE="11"><?php __("November")?></OPTION>
	<OPTION VALUE="12"><?php __("December")?></OPTION></select>
	-
	<select name=endday>
	<OPTION VALUE="01">01</OPTION>
	<OPTION VALUE="02">02</OPTION>
	<OPTION VALUE="03">03</OPTION>
	<OPTION VALUE="04">04</OPTION>
	<OPTION VALUE="05">05</OPTION>
	<OPTION VALUE="06">06</OPTION>
	<OPTION VALUE="07">07</OPTION>
	<OPTION VALUE="08">08</OPTION>
	<OPTION VALUE="09">09</OPTION>
	<OPTION VALUE="10">10</OPTION>
	<OPTION VALUE="11">11</OPTION>
	<OPTION VALUE="12">12</OPTION>
	<OPTION VALUE="13">13</OPTION>
	<OPTION VALUE="14">14</OPTION>
	<OPTION VALUE="15">15</OPTION>
	<OPTION VALUE="16">16</OPTION>
	<OPTION VALUE="17">17</OPTION>
	<OPTION VALUE="18">18</OPTION>
	<OPTION VALUE="19">19</OPTION>
	<OPTION VALUE="20">20</OPTION>
	<OPTION VALUE="21">21</OPTION>
	<OPTION VALUE="22">22</OPTION>
	<OPTION VALUE="23">23</OPTION>
	<OPTION VALUE="24">24</OPTION>
	<OPTION VALUE="25">25</OPTION>
	<OPTION VALUE="26">26</OPTION>
	<OPTION VALUE="27">27</OPTION>
	<OPTION VALUE="28">28</OPTION>
	<OPTION VALUE="29">29</OPTION>
	<OPTION VALUE="30">30</OPTION>
	<OPTION VALUE="31">31</OPTION>
	</select>
	<input type=submit value=Go><input type=hidden name=go value=yes>
	</form>
<?php
}
PRINT "</body></html>";

?>
