/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjtree;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Vector;
import org.javacc.jjtree.JJTreeIOException;
import org.javacc.parser.JavaCCGlobals;
import org.javacc.parser.Options;

final class IO {
    private String ifn = "<uninitialized input>";
    private String ofn = "<uninitialized output>";
    private Reader in;
    private PrintWriter out;
    private PrintStream msg = System.out;
    private PrintStream err = System.err;
    private Vector toolList;

    IO() {
    }

    String getInputFileName() {
        return this.ifn;
    }

    Reader getIn() {
        return this.in;
    }

    String getOutputFileName() {
        return this.ofn;
    }

    PrintWriter getOut() {
        return this.out;
    }

    PrintStream getMsg() {
        return this.msg;
    }

    PrintStream getErr() {
        return this.err;
    }

    void print(String string) {
        this.out.print(string);
    }

    void println(String string) {
        this.out.println(string);
    }

    void println() {
        this.out.println();
    }

    void closeAll() {
        if (this.out != null) {
            this.out.close();
        }
        if (this.msg != null) {
            this.msg.flush();
        }
        if (this.err != null) {
            this.err.flush();
        }
    }

    private String create_output_file_name(String string, char c) {
        String string2 = Options.S("OUTPUT_FILE");
        String string3 = Options.S("OUTPUT_DIRECTORY");
        if (string2.equals("")) {
            String string4;
            int n;
            int n2 = string.lastIndexOf(c);
            if (n2 >= 0) {
                string = string.substring(n2 + 1);
            }
            string2 = (n = string.lastIndexOf(46)) == -1 ? string + ".jj" : ((string4 = string.substring(n)).equals(".jj") ? string + ".jj" : string.substring(0, n) + ".jj");
        }
        if (string3.equals("")) {
            return string2;
        }
        return string3 + c + string2;
    }

    void setInput(String string) throws JJTreeIOException {
        try {
            File file = new File(string);
            if (!file.exists()) {
                throw new JJTreeIOException("File " + string + " not found.");
            }
            if (file.isDirectory()) {
                throw new JJTreeIOException(string + " is a directory. Please use a valid file name.");
            }
            if (JavaCCGlobals.isGeneratedBy("JJTree", string)) {
                throw new JJTreeIOException(string + " was generated by jjtree.  Cannot run jjtree again.");
            }
            this.toolList = JavaCCGlobals.getToolNames(string);
            this.ifn = file.getPath();
            this.ofn = this.create_output_file_name(this.ifn, File.separatorChar);
            this.in = new FileReader(this.ifn);
        }
        catch (NullPointerException nullPointerException) {
            throw new JJTreeIOException(nullPointerException.toString());
        }
        catch (SecurityException securityException) {
            throw new JJTreeIOException("Security violation while trying to open " + string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JJTreeIOException("File " + string + " not found.");
        }
        catch (IOException iOException) {
            throw new JJTreeIOException(iOException.toString());
        }
        try {
            this.out = new PrintWriter(new FileWriter(this.ofn));
        }
        catch (IOException iOException) {
            throw new JJTreeIOException("Can't create output file " + this.ofn);
        }
    }
}

