<?
/* This file is part of JFFNMS
 * Copyright (C) <2002-2005> Javier Szyszlican <javier@szysz.com>
 * This program is licensed under the GNU GPL, full terms in the LICENSE file
 */
function tree_iptables () {

    $table_names_file = "/proc/net/ip_tables_names";
    $iptables="/sbin/iptables";

    $tables_names = file($table_names_file);

    $table_id = 1;
    
    foreach ($tables_names as $table) {
	$table = trim($table);
	$tables[$table_id][index]=$table_id;
	$tables[$table_id][name]=$table;

	unset ($result);
	exec("$iptables --line-numbers -xvnL -t $table ",$result);

	$pos = 0;
	$chain_id = 1;
	$rule_id = 1;
	foreach ($result as $data) {
	    $data = trim($data);
	    //echo "$data\n";	    

	    if ($pos==0)
		if (preg_match ("/^Chain (\S+) \(policy (\S+) (\d+) packets, (\d+) bytes\)/",$data,$parts)) {
		    $chains[$chain_id][index]=$chain_id;
		    $chains[$chain_id][table]=$table_id;
		    $chains[$chain_id][name]=$parts[1];
		    $chains[$chain_id][policy]=$parts[2];
		    $chains[$chain_id][packets]=$parts[3];
		    $chains[$chain_id][bytes]=$parts[4];

		    truncate_counter($chains[$chain_id][packets]);
		    truncate_counter($chains[$chain_id][bytes]);
		}		

	    if ($pos>1) 
		if (is_array($chains[$chain_id]) &&
		 preg_match ("/^(\d+)\s+(\d+)\s+(\d+) (\S.+)/",$data,$parts)) {
		    $rules[$rule_id][index]=str_pad($table_id,2,"0",STR_PAD_LEFT).str_pad($chain_id,2,"0",STR_PAD_LEFT).str_pad($parts[1],4,"0",STR_PAD_LEFT);
		    $rules[$rule_id][chain]=$chain_id;
		    $rules[$rule_id][description]=$parts[4];
		    $rules[$rule_id][packets]=$parts[2];
		    $rules[$rule_id][bytes]=$parts[3];
		    
		    for ($i = 0; $i < 10 ; $i++)
			$rules[$rule_id][description] = trim(str_replace("  "," ",$rules[$rule_id][description]));
		
		    truncate_counter($rules[$rule_id][packets]);
		    truncate_counter($rules[$rule_id][bytes]);
    
		    $rule_id++;
		}
		
	    $pos++;

	    if (empty($data)) {
		$pos = 0;
		$chain_id++;
	    }
	}
	$table_id++;
    }
    $info[tables]=$tables;
    $info[chains]=$chains;
    $info[rules]=$rules;
    return $info;
}
?>
