/***************************************************************************
                          channeldesc.h  -  description
                             -------------------
    begin                : Fri Dec 5 2003
    copyright            : (C) 2003-2005 by Christophe
    email                : hftom@free.fr
    last modified        : $Date: 2005/02/02 10:08:24 $ by $Author: juergenk $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHANNELDESC_H
#define CHANNELDESC_H

#include <qstring.h>
#include <qptrlist.h>
#include <qdatetime.h>
#include <qvaluelist.h>

#include <linux/dvb/frontend.h>

#define MAXAPID 20



class RecTimer
{

public:

	QString name;
	QString channel;
	QDateTime begin;
	QTime duration;
	int filetype;
	char running;
};



class AudioPid
{

public:

	AudioPid();
	AudioPid( unsigned short apid );
	~AudioPid();

	unsigned short pid;
	QString lang;
	char ac3;
};



class SubPid
{

public:

	unsigned short pid, page, id;
	QString lang;
};



class Transponder
{

public:

	Transponder();
	Transponder( const Transponder &trans ); //copy
	~Transponder();
	bool sameAs( Transponder *trans );
	bool operator==( const Transponder t );
	bool operator!=( const Transponder t );

	QString source;
	fe_type_t type; //   S, C or T
	unsigned long freq;
	QValueList<unsigned long> freqlist;
	char pol;
	unsigned long sr;
	unsigned short tsid;
	fe_spectral_inversion_t inversion;
	fe_modulation_t modulation;
	fe_hierarchy_t hierarchy;
	fe_guard_interval_t guard;
	fe_transmit_mode_t transmission;
	fe_code_rate_t coderateL;
	fe_code_rate_t coderateH;
	fe_bandwidth_t bandwidth;
};



class ChannelDesc
{

public: 

	ChannelDesc();
	ChannelDesc( const ChannelDesc &chan ); //copy
	~ChannelDesc();

	QString provider;
	QString name;
	unsigned int num;
	unsigned short sid;
	unsigned short vpid;
	AudioPid apid[MAXAPID];
	char napid;
	char maxapid;
	unsigned short ttpid;
	SubPid subpid;
	unsigned short pmtpid;
	unsigned char fta; // 0 for free
	unsigned char type; // 1 for TV , 2 for RA
	int completed;
	Transponder tp;
};



class ShortEvent
{

public:

	ShortEvent();
	~ShortEvent();
	
	QString name;
	QString text;
};



class EventDesc
{

public:

	EventDesc();
	~EventDesc();
	void printOut();

	unsigned char tid;
	unsigned short sid;
	unsigned short tsid;
	unsigned char sn;
	unsigned char lsn;
	unsigned short eid;
	unsigned char running;
	QDateTime startDateTime;
	QTime duration;
	QPtrList<ShortEvent> shortEvents;
	QPtrList<QString> extEvents;
	QString title;
	QString subtitle;
};
#endif
