/***************************************************************************
                       kmfruleedit.h  -  description
                          -------------------
 begin                : Thu Feb 7  2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMFRULEEDIT_H
#define KMFRULEEDIT_H
#include "kmyfirewallruleeditor.h"

// qt includes
#include <qvariant.h>
#include <qdialog.h>
#include <qpixmap.h>
#include <qstring.h>
//#include <qguardedptr.h>

// kde includes
#include <kconfig.h>
#include <kiconloader.h>
#include <kstandarddirs.h> 
// project includes
#include "../kmyfirewall.h"
#include "../core/iptable.h"

class KMFDoc;
class KListView;
class QListViewItem;
class KListViewItem;
class KMFRuleLVItem;
class IPTRule;
class IPTChain;
class QString;
class KPopupMenu;
class KMFErrorHandler;
class KMFError;
class KMFCheckInput;
class KMFRuleEditIP;
class KMFRuleEditMac;
class KMFRuleEditorProtocol;
class KMFRuleEditorInterface;
class KMFRuleEditorState;
class KMFRuleEditorLimit;
class KMFRuleEditorTos;
class KMFRuleEditTargetLog;
class KMFRuleEditorTargetNat;
class KMFRuleEditTargetMark;
class KMFChainEdit;
class KMFRuleLVItem;
class KMFChainLVItem;
class KMFOutputViewer;
class KMFRuleEditCustomOpt;
class KMFRuleInfo;

class KMFRuleEdit : public KMyFirewallRuleEditor {
	Q_OBJECT

public:
	KMFRuleEdit( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	~KMFRuleEdit();
	IPTRule* currRule() const {
		return m_rule;
	};

	void showRuleOptionLeds( const IPTRule& );
	bool updateCurrRule();
	void loadDoc( KMFDoc* doc );
	void editChain( IPTChain* );

public slots:
	void slotAddRule();
	void slotEditRule();
	void slotDelRule();
	void slotDelChain();
	void slotRunFirewall();
	void slotResetFirewall();
	void slotShowOutputViewer();
	void slotShowIPTConfig();
	void slotShowFilter();
	void slotShowNat();
	void slotShowMangle();
	void slotShowScript();
	void slotEditChain();
	void slotLoadDocument( KMFDoc* );
	void slotInstallFirewall();
	void slotUninstallFirewall();

signals:
	void documentChanged( KMFDoc& );
	void sigDocumentChanged();
	void currRuleChanged();
	void cb_frag_toggled();

protected:
	bool event( QEvent* );

private:
	// members
	void createRBM( const IPTRule& );
	void createRBM( const IPTChain& );
	void loadIcons();
	void enableEdit( bool on );
	void resetLeds();

	//	void dropEvent( QDropEvent* );
	KMFRuleLVItem* currRuleParentItem();
	KMFRuleLVItem* currRuleParentItem( KMFRuleLVItem* );
	//	KListViewItem* createRuleItem(KListViewItem* item,IPTRule* rule,int number);

	// data

	KMFOutputViewer *m_output_viewer;
	KMFRuleInfo *m_rule_info;
	KMFRuleEditIP *m_iped;
	KMFRuleEditMac *m_maced;
	KMFRuleEditorProtocol *m_proted;
	KMFRuleEditorInterface *m_inted;
	KMFRuleEditorState *m_stateed;
	KMFRuleEditorLimit *m_limited;
	KMFRuleEditorTos *m_tosed;
	KMFRuleEditTargetLog *m_tglog;
	KMFRuleEditorTargetNat *m_tgnat;
	KMFRuleEditTargetMark *m_tgmark;
  KMFRuleEditCustomOpt *m_custom_opt;
	KMFChainEdit *m_editchain;
	KListView *lv_rules;
	KMFDoc *kmfdoc;
	IPTRule *m_rule;
	IPTChain *m_chain;
	KMFError *m_err;
	KMFErrorHandler *m_err_handler;
	KMFCheckInput *m_check_input;
	QString *m_table;
	KPopupMenu *m_contextMenu;
	QStringList *m_curr_chains;
	KMFRuleLVItem* m_curr_rule_item;
	KMFChainLVItem* m_top_item;


	QString m_curr_chain_name;
	int m_curr_rule_number;

	QPtrList<QString>* curr_rule_options;
	QPixmap icon_up, icon_down, icon_del, icon_edit, icon_rule, icon_filter, icon_rename,
	icon_chain, icon_log, icon_accept, icon_drop, icon_cmd, icon_reject, icon_return,
	        icon_target, icon_queue, icon_new, icon_copy, icon_move;


private slots:

	void slotRuleRBM( QListViewItem*, const QPoint &, int );
	void slotRenameRule();
	void slotRenameRule( QListViewItem*, int, const QString& );
	void slotEditRule( QListViewItem*, const QPoint&, int );
	void slotEditRule( QListViewItem* );
	void slotNewOptionType( int index );
	void slotReloadDocument();
	void slotShowOverview();

	void slotEditRuleInfo();
	void slotEditIPopt();
	void slotEditMacOpt();
	void slotEditStateOpt();
	void slotEditLimitOpt();
	void slotEditIntOpt();
	void slotEditProtOpt();
	void slotEditTosOpt();
	void slotEditTargetOption();
	void slotEditCustomOpt();


	void slotFragChanged();
	void slotLogRuleChanged();
	void slotEnableRuleChanged();
	void slotTargetChanged( const QString& );

	void slotNewChainSelected( const QString& );
	void slotNewChainSelected( int );
	void slotNewTableSelected();
	void slotNewRuleSelected( QListViewItem* );

	void slotFillChainCB( const IPTable& );
	void slotAddValidTargets( const IPTChain& chain );
	void slotAddRuleOption( QString*, QPtrList<QString>* );
	void slotDelRuleOption( QString* name );
	void slotAddTargetOption( QString*, QPtrList<QString>* );
	void slotDelTargetOption( QString* name );


	void slotMoveRuleUp();
	void slotMoveRuleDown();
	void slotMoveRule( int );
	void slotCopyRule( int );

	void slotUpdatePreview( bool reload_rule = true );
	void slotHelp();
};

#endif // KMFRULEEDIT_H
