
/***************************************************************************
                         kmfruleeditorstate.cpp  -  description
                            -------------------
   begin                : Wed Mar 13 2002
   copyright            : (C) 2002 by Christian Hubinger
   email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfruleeditorstate.h"

// qt includes
#include <qstring.h>
#include <qptrlist.h>
#include <qmessagebox.h>
#include <qcheckbox.h>

// kde includes
#include <kdebug.h>
#include <klocale.h>
#include <kapplication.h>
#include <kmessagebox.h>


KMFRuleEditorState::KMFRuleEditorState( QWidget *parent, const char *name, WFlags fl /*,IPTRule* cr*/ ) : KMyFirewallRuleEditorState( parent, name, fl ) {}
KMFRuleEditorState::~KMFRuleEditorState() {}

void KMFRuleEditorState::loadRule( IPTRule *rule ) {
	kdDebug() << "void KMFRuleEditorState::loadRule( IPTRule *rule )" << endl;
	c_use_conntrack->setChecked( false );
	c_new->setChecked( false );
	c_related->setChecked( false );
	c_established->setChecked( false );
	c_invalid->setChecked( false );
	curr_rule = rule;
	readRuleConfig();
}

void KMFRuleEditorState::slotOk() {
	bool s_new = c_new->isChecked();
	bool s_related = c_related->isChecked();
	bool s_established = c_established->isChecked();
	bool s_invalid = c_invalid->isChecked();
	if ( c_use_conntrack->isChecked() ) {
		QString * del = new QString( "state" );
		//    curr_rule->delRuleOption(del);
		emit sigDelRuleOpt( del );
		if ( !s_new && !s_related && !s_established && !s_invalid ) {
			KMessageBox::sorry( this, i18n( "You must at least choose one of the available states." ), i18n( "Configure Connection Tracking" ) );
			return ;
		}
		QPtrList<QString>* options = new QPtrList<QString>;
		QString* name = new QString( "state" );
		QString* opt = new QString( "" );
		if ( s_new ) {
			opt->append( ",NEW" );
		}
		if ( s_related ) {
			opt->append( ",RELATED" );
		}
		if ( s_established ) {
			opt->append( ",ESTABLISHED" );
		}
		if ( s_invalid ) {
			opt->append( ",INVALID" );
		}
		if ( opt->startsWith( "," ) )
			* opt = opt->right( opt->length() - 1 );
		options->append( opt );
		emit sigAddRuleOpt( name, options );
	} else {
		QString* del = new QString( "state" );
		//    curr_rule->delRuleOption(del);
		emit sigDelRuleOpt( del );
	}
	emit sigDocumentChanged();
	//	accept();
}
void KMFRuleEditorState::readRuleConfig() {
	QPtrList<QPtrList<QString> > opt_list = curr_rule->ruleOptions();
	for ( uint j = 0;j < opt_list.count();j++ ) {
		options = new QPtrList<QString>;
		options = opt_list.at( j );
		if ( options->count() > 1 ) {
			QString * opt = options->at( 0 );
			QString* cmd = options->at( 1 );
			if ( *opt == "state" ) {
				c_use_conntrack->setChecked( true );
				if ( cmd->contains( "NEW" ) )
					c_new->setChecked( true );
				if ( cmd->contains( "RELATED" ) )
					c_related->setChecked( true );
				if ( cmd->contains( "ESTABLISHED" ) )
					c_established->setChecked( true );
				if ( cmd->contains( "INVALID" ) )
					c_invalid->setChecked( true );
			}
		}
	}
}
void KMFRuleEditorState::slotHelp() {
	kdDebug() << "void KMFRuleEditorState::slotHelp()" << endl;
	kapp->invokeHelp( "state" );
}
void KMFRuleEditorState::reject() {
	kdDebug() << "void KMFRuleEditorState::reject()" << endl;
	emit sigHideMe();
}
#include "kmfruleeditorstate.moc"
