/***************************************************************************
                          kmfnewdocdlg.cpp  -  description
                             -------------------
    begin                : Thu Apr 17 2003
    copyright            : (C) 2003 by animal
    email                : animal@shit
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kapplication.h"
#include "kmfnewdocdlg.h"
#include "version.h"
#include "kmfnewdocdlg.moc"

// QT includes
#include "qpixmap.h"
#include "qpainter.h"
#include "qlabel.h"
#include "qstring.h"
#include "qpushbutton.h"
#include "qrect.h"

// KDE includes
#include "kstandarddirs.h"
#include <kglobalsettings.h>
#include "kdebug.h"

KMFNewDocDlg::KMFNewDocDlg(QWidget *parent, const char *name, WFlags fl ) : KMyFirewallNewDocument(parent,name,fl ) {
    KStandardDirs std_dir;
    QString dir = std_dir.findResource("data","kmyfirewall/pics/splash_cut.png");
    kdDebug() << "\nFound Splashscreen at: " << dir << endl;

    QPixmap pic = QPixmap::fromMimeSource( dir );
    if ( pic.isNull() )
		return;
    QPainter p( &pic );
    QFont f( KGlobalSettings::generalFont().family(), 8, QFont::Bold );
    p.setFont( f );
    p.setPen( Qt::white );
    p.drawText( 165, 45, QString("Version %1").arg(KMYFIREWALL_VERSION) );
    p.drawText( 93, 215, QString("(c)2002-2003") );
    p.drawText( 70, 230, QString("The KMyFirewall Team") );
    l_pic->setPixmap( pic );
    connect(b_cancel,SIGNAL( clicked() ),this,SLOT( reject() ) );
    connect(b_close,SIGNAL( clicked() ),this,SLOT( reject() ) );
    connect(b_empty,SIGNAL( clicked() ),this,SLOT( loadEmpty() ) );
    connect(b_wizard,SIGNAL( clicked() ),this,SLOT( loadWizard() ) );
    connect(b_template,SIGNAL( clicked() ),this,SLOT( loadTemplate() ) );
    connect(b_load_saved,SIGNAL( clicked() ),this,SLOT( loadSaved() ) );
    connect(b_help,SIGNAL( clicked() ),this,SLOT( slotHelp() ) );
    QRect screen = QApplication::desktop()->screenGeometry();
    QRect mainRect;
    screen = QApplication::desktop()->screenGeometry( QApplication::desktop()->screenNumber( mainRect.center() ) );
    move( screen.center() - QPoint( this->width() / 2, this->height() / 2 ) );
}

KMFNewDocDlg::~KMFNewDocDlg(){
}

void KMFNewDocDlg::reject() {
  close();
}

void KMFNewDocDlg::loadEmpty() {
  hide();
	emit sigNewDocLoadEmpty();
	close();
}
void KMFNewDocDlg::loadWizard() {
  hide();
	emit sigNewDocLoadWizard();
  close();
}
void KMFNewDocDlg::loadTemplate() {
  hide();
	emit sigNewDocLoadTemplate();
  close();
}
void KMFNewDocDlg::loadSaved() {
  hide();
	emit sigNewDocLoadSaved();
  close();
}
void KMFNewDocDlg::slotHelp() {
	kapp->invokeHelp();
}

