/***************************************************************************
                          resource.h  -  description
                             -------------------
    begin                : Tue Jul 17 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RESOURCE_H
#define RESOURCE_H


/**
  *@author Troy Corbin Jr.
  */

/* KDE */
#include <kapp.h>
#include <klocale.h>
#include <kcursor.h>
#include <klistview.h>
#include <kcmdlineargs.h>
/* Qt */
#include <qstylesheet.h>
#include <qvaluelist.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qpixmap.h>
#include <qimage.h>
/* Local */
#include "definitions.h"

class audio;
class KnightsPixCache;
class TabManager;
class Accel;

typedef struct engineResource
{
		QListViewItem	*Item;
		QString				Name;
		QString				Filename;
		QString				Arguments;
		QString				LogFile;
		int						Protocol;
		int						Wins;
		int						Losses;
		int						Draws;
		int						CurrentRef;
};

typedef struct serverResource
{
		QListViewItem *Item;
		QString				Name;
		QString				URL;
		QString				UserName;
		QString				Password;
		QString				LogFile;
		QString				Timeseal;
		bool					StorePass;
		int						Port;
		int						CurrentRef;
};

typedef QValueList<engineResource> engineList;
typedef QValueList<serverResource> serverList;

class resource
{
	public:
													/* The current Theme */
		int										ThemeSize;
		bool									ThemeBorder;
		QStyleSheet						*ConsoleStyle;
		QString								CurrentBoard;
		QString								CurrentChessmen;
		QString								CurrentAudio;
		ThemeHeader						boardHeader;
		ThemeHeader						chessmenHeader;
		ThemeHeader						audioHeader;
		KnightsPixCache				*pixCache;
		TabManager						*tabManager;
		Accel									*myAccel;

													/* General Settings */
		QString								Local_Player;
		QString								Local_Email_Address;
		int										Config_Version;
		bool									Accepted_License;
		int										OPTION_On_Init;
		int										Audio_Volume;
		bool 									OPTION_Audio;
		bool									OPTION_Audio_Current_Only;
		bool 									OPTION_Auto_Queen;
		bool 									OPTION_Auto_Preview;
		bool 									OPTION_Auto_Call_Flag;
		bool									OPTION_Auto_Close_Last_ICS;
		bool									OPTION_Animate_Moves;
		bool									OPTION_Book_White;
		bool									OPTION_Book_Black;
		bool									OPTION_Board_Orientation;
		bool									OPTION_Ponder;
		bool									OPTION_Show_Coord;
		bool									OPTION_Show_Last_Move;
		bool									OPTION_Show_Splash;
		bool									OPTION_Show_Extended_PGN;
		bool									OPTION_Pause_On_Minimize;
		bool									OPTION_Reuse_PGN;
		bool									OPTION_3DBoard;
		QString								PGN_Filename;
		QString								Email_Command_Line;
		QString								Email_Address;
		QString								SCID_Image_Path;
		int										Widget_Height;
													/* ICS Options */
		int										Seek_Timer;
		int										OPTION_Profanity;
		bool									OPTION_Premove;
		bool									OPTION_Kibitz;
		bool									OPTION_Private;
		bool									OPTION_Shout;
		bool									OPTION_Tell;
		bool									OPTION_Seek;
													/* Notification Prompts */
		QString								PromptForSaving;
													/* Colors */
		QColor								COLOR_White;
		QColor								COLOR_Black;
		QColor								COLOR_Background;
		QColor								COLOR_Standard;
		QColor								COLOR_PrivateTell;
		QColor								COLOR_ChannelTell;
		QColor								COLOR_Shout;
		QColor								COLOR_Whisper;
		QColor								COLOR_Notification;
		QColor								COLOR_Notation;
		QColor								COLOR_Notation_Shadow;
		QColor								COLOR_GraphBackground;
		QColor								COLOR_GraphForeground;
													/* Fonts */
		QFont									FONT_Standard;
		QFont									FONT_PrivateTell;
		QFont									FONT_ChannelTell;
		QFont									FONT_Shout;
		QFont									FONT_Whisper;
		QFont									FONT_Notification;
													/* Cursors */
		QCursor								CURSOR_Standard;
		QCursor								CURSOR_Thinking;
		QCursor								CURSOR_Text;
													/* Chess Engines */
		engineList						engines;
		engineList::Iterator	enginesIT;
													/* Chess Servers */
		serverList						servers;
		serverList::Iterator	serversIT;
													/* New Match Presets */
		TCPList								TCPWhite;
		TCPList								TCPBlack;
		char									MatchRules;
		char									Type[4];
		char									Strength[4];

													resource( KCmdLineArgs *args );
													~resource();

		void									ConfigRead( void );
		void									ConfigWrite( void );
		
		void									readThemeDir( void );
		QString								getBoard( int Index=-1 );
		QString								getChessmen( int Index=-1 );
		QString								getSounds( int Index=-1 );
		QString								themeDir( void );
		void									setTheme( int BoardIndex=-1, int ChessmenIndex=-1 );
		void									setAudio( int AudioIndex=-1 );
		void									resizeTheme( const int &size );

													/**
													Call buildStyle whenever you need to reparse the Resource configuration */
		void									buildStyle( void );
		QPixmap								LoadIcon( QString Name, int Group );
		QPixmap								loadSCIDImage( const QString &name );
		void									play( const char );

	private:

		QStyleSheetItem				*SSI_Default;
		QStyleSheetItem				*SSI_PrivateTell;
		QStyleSheetItem				*SSI_ChannelTell;
		QStyleSheetItem				*SSI_Shout;
		QStyleSheetItem				*SSI_Whisper;
		QStyleSheetItem				*SSI_Notification;

		QString								GlobalDataDir;
		QString								LocalDataDir;

		QStringList						Boards;
		QStringList						Chessmen;
		QStringList						Sounds;
		KIconLoader						*Icons;
		audio									*Audio;

		void									ReadEngines( void );
		void									WriteEngines( void );

		void									ReadServers( void );
		void									WriteServers( void );
		
		void									ReadMatchParam( void );
		void									WriteMatchParam( void );
		
		void									ReadColors( void );
		void									WriteColors( void );

		void									ReadFonts( void );
		void									WriteFonts( void );

		/**
			Borrowed from KMail
			Very primitive en/de-cryption so that the password is not
			readable in the config file. But still very easy breakable.
		*/
		QString								encryptStr( const QString& inStr ) const;
		QString								decryptStr( const QString& inStr ) const;
		QString								themeURL( const QString );
		void									loadThemeItem( const QString& URL, QImage& Image );
};

#endif
